/*
 * Decompiled with CFR 0.152.
 */
package com.intellifylearning.metrics.models;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellifylearning.metrics.models.Activity;
import com.intellifylearning.metrics.models.Metric;
import com.intellifylearning.metrics.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class QuizActivity
extends Activity {
    private Metric viewQuiz = Metric.define("quiz-1111", "view-quiz", null);
    private Metric attemptQuiz = Metric.define("quiz-2222", "attempt-quiz", null);
    private Metric submitQuiz = Metric.define("quiz-3333", "submit-quiz", null);
    private Metric viewRemediation = Metric.define("quiz-4444", "view-remediation", null);

    public QuizActivity() {
        this.setType(this.TYPE_QUIZ);
        this.metrics.add(this.viewQuiz);
        this.metrics.add(this.attemptQuiz);
        this.metrics.add(this.submitQuiz);
        this.metrics.add(this.viewRemediation);
    }

    private Metric getViewQuizMetric() {
        return this.viewQuiz;
    }

    private Metric getAttemptQuizMetric() {
        return this.attemptQuiz;
    }

    private Metric getSubmitQuizMetric() {
        return this.submitQuiz;
    }

    private Metric getViewRemediationMetric() {
        return this.viewRemediation;
    }

    @Override
    public List<Metric> getLogicalMetricSequence() {
        ArrayList metricList = Lists.newArrayList();
        metricList.add(this.getStartActivityMetric());
        Object metric = null;
        for (int i = 0; i < Utils.getRandomIntBetween(2, 1); ++i) {
            metricList.add(this.getViewQuizMetric());
        }
        boolean attemptQuiz = Utils.getRandomBoolean();
        if (attemptQuiz) {
            metricList.add(this.getAttemptQuizMetric());
            boolean submitQuiz = Utils.getRandomBoolean();
            if (submitQuiz) {
                metricList.add(this.addQuizSubmitData(this.getSubmitQuizMetric()));
                boolean viewRemediation = Utils.getRandomBoolean();
                if (viewRemediation) {
                    metricList.add(this.getViewRemediationMetric());
                }
            }
        }
        metricList.add(QuizActivity.getCompleteActivityMetric());
        return metricList;
    }

    private Metric addQuizSubmitData(Metric metric) {
        int maxScore = 5;
        int achievedScore = Utils.getRandomIntBetween(5, 1);
        HashMap metricData = Maps.newHashMap();
        metricData.put("achieved-score", String.valueOf(achievedScore));
        metricData.put("max-score", String.valueOf(maxScore));
        Metric pageReadMetric = new Metric();
        pageReadMetric.setId(metric.getId());
        pageReadMetric.setName(metric.getName());
        pageReadMetric.setMetricData(metricData);
        return pageReadMetric;
    }
}

