/*
 * Decompiled with CFR 0.152.
 */
package com.intellifylearning.metrics.models;

import com.google.common.collect.Lists;
import com.intellifylearning.metrics.models.DigitalResource;
import com.intellifylearning.metrics.models.EdApp;
import com.intellifylearning.metrics.models.Metric;
import com.intellifylearning.metrics.utils.Utils;
import java.util.List;

public class Activity
extends DigitalResource {
    private String type;
    private String tags;
    private List<String> objectives = Lists.newArrayList();
    private String attemptScore;
    private String maxAttemptScore;
    private EdApp providingEdApp;
    protected List<Metric> metrics = Lists.newArrayList();
    private static Metric startActivityMetric = Metric.define("engage-1111", "start-activity", null);
    private static Metric completeActivityMetric = Metric.define("engage-2222", "complete-activity", null);
    private static Metric achieveScoreMetric = Metric.define("performance-1111", "achieve-score", null);

    public Activity() {
        this.setType(this.TYPE_GENERIC_ACTIVITY);
    }

    public Metric getStartActivityMetric() {
        return startActivityMetric;
    }

    public static Metric getCompleteActivityMetric() {
        return completeActivityMetric;
    }

    public static Metric getAchieveScoreMetric() {
        return achieveScoreMetric;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public List<String> getObjectives() {
        return this.objectives;
    }

    public void setObjectives(List<String> objectives) {
        this.objectives = objectives;
    }

    public void addObjective(String objective) {
        this.objectives.add(objective);
    }

    public String getAttemptScore() {
        return this.attemptScore;
    }

    public void setAttemptScore(String attemptScore) {
        this.attemptScore = attemptScore;
    }

    public String getMaxAttemptScore() {
        return this.maxAttemptScore;
    }

    public void setMaxAttemptScore(String maxAttemptScore) {
        this.maxAttemptScore = maxAttemptScore;
    }

    public EdApp getProvidingEdApp() {
        return this.providingEdApp;
    }

    public void setProvidingEdApp(EdApp providingEdApp) {
        this.providingEdApp = providingEdApp;
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<Metric> metrics) {
        this.metrics = metrics;
    }

    public Metric getRandomMetric() {
        return this.metrics.get(Utils.getRandomIntInInterval(this.metrics.size()));
    }

    public List<Metric> getLogicalMetricSequence() {
        return null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }
}

