/*
 * Decompiled with CFR 0.152.
 */
package com.intellifylearning.gson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.intellify.api.caliper.impl.entities.Entity;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntellifyEntitySerializer
extends JsonSerializer<Entity> {
    private static final Logger logger = LoggerFactory.getLogger((String)"intellisense");
    private static final String CLASSNAME = "iType";
    private static final String INSTANCE = "@instance";

    public void serialize(Entity value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        logger.debug("%%%% Custom Serialization in progress");
        jgen.writeStartObject();
        JsonSerializer serializer = provider.findValueSerializer(Entity.class, null);
        serializer.unwrappingSerializer(null).serialize((Object)value, jgen, provider);
        String className = value.getClass().getCanonicalName();
        logger.debug("%%%% About to write custom property iType = " + className);
        jgen.writeObjectField(CLASSNAME, (Object)className);
        jgen.writeEndObject();
    }
}

