/*
 * Decompiled with CFR 0.152.
 */
package com.intellifylearning.flush;

import com.intellify.api.caliper.CaliperEntity;
import com.intellify.api.caliper.impl.IntellifyBase;
import com.intellifylearning.Client;
import com.intellifylearning.IntellifyQueueFullException;
import com.intellifylearning.flush.IBatchFactory;
import com.intellifylearning.models.Batch;
import com.intellifylearning.models.BatchIntellifyBase;
import com.intellifylearning.request.IRequester;
import com.intellifylearning.utils.ManualResetEvent;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Flusher
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger((String)"intellisense");
    private final LinkedBlockingQueue<CaliperEntity> queue;
    private final LinkedBlockingQueue<IntellifyBase> queue2;
    private final ManualResetEvent idle;
    private final ManualResetEvent idle2;
    private final Client client;
    private final IBatchFactory factory;
    private final IRequester requester;
    private final boolean errorOnQueueFull;
    private final int queueWaitTimeout;
    private boolean go;

    public Flusher(Client client, IBatchFactory factory, IRequester requester) {
        this.client = client;
        this.factory = factory;
        this.requester = requester;
        int maxQueueSize = client.getOptions().getMaxQueueSize();
        this.queue = new LinkedBlockingQueue(maxQueueSize);
        this.queue2 = new LinkedBlockingQueue(maxQueueSize);
        this.errorOnQueueFull = client.getOptions().isErrorOnQueueFull();
        this.queueWaitTimeout = client.getOptions().getQueueWaitTimeout();
        this.go = true;
        this.idle = new ManualResetEvent(true);
        this.idle2 = new ManualResetEvent(true);
    }

    @Override
    public void run() {
        while (this.go) {
            this.batchAndSend();
            this.batchAndSendIntellifyBaseObjects();
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while sleeping flushing thread.", (Throwable)e);
            }
        }
    }

    private void batchAndSend() {
        LinkedList<CaliperEntity> current = new LinkedList<CaliperEntity>();
        int batchSize = this.getBatchSize();
        do {
            if (this.queue.size() == 0) {
                this.idle.set();
            }
            CaliperEntity caliperEntity = null;
            try {
                caliperEntity = this.queue.poll(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while trying to flush intellisense queue.", (Throwable)e);
            }
            if (caliperEntity == null) continue;
            this.idle.reset();
            current.add(caliperEntity);
            this.client.getStatistics().updateQueued(this.queue.size());
        } while (this.go && this.queue.size() > 0 && current.size() < batchSize);
        if (current.size() > 0) {
            logger.debug("Preparing to send batch.. [ " + current.size() + " items]");
            Batch batch = this.factory.create(current);
            this.client.getStatistics().updateFlushAttempts(1.0);
            this.requester.send(batch);
            logger.debug("Initiated batch request .. [ " + current.size() + " items]");
        }
    }

    private void batchAndSendIntellifyBaseObjects() {
        LinkedList<IntellifyBase> current = new LinkedList<IntellifyBase>();
        int batchSize = this.getBatchSize();
        do {
            if (this.queue2.size() == 0) {
                this.idle2.set();
            }
            IntellifyBase intellifyBaseEntity = null;
            try {
                intellifyBaseEntity = this.queue2.poll(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while trying to flush intellisense queue for IntellifyBase objects", (Throwable)e);
            }
            if (intellifyBaseEntity == null) continue;
            this.idle2.reset();
            current.add(intellifyBaseEntity);
            this.client.getStatistics().updateQueued(this.queue2.size());
        } while (this.go && this.queue2.size() > 0 && current.size() < batchSize);
        if (current.size() > 0) {
            logger.debug("Preparing to send batch of IntellifyBase objects.. [ " + current.size() + " items]");
            BatchIntellifyBase batch = this.factory.createIntellifyBaseBatch(current);
            this.client.getStatistics().updateFlushAttempts(1.0);
            this.requester.sendIntellifyBaseBatch(batch);
            logger.debug("Initiated batch of IntellifyBase objects request for [ " + current.size() + " items]");
        }
    }

    private int getBatchSize() {
        int batchSize = 20;
        if (this.client.getOptions().getBatchSize() > 0) {
            batchSize = this.client.getOptions().getBatchSize();
        }
        return batchSize;
    }

    public void enqueue(CaliperEntity payload) {
        this.enqueue(this.queue, payload);
    }

    public void enqueue(IntellifyBase intellifyBaseObj) {
        this.enqueue(this.queue2, intellifyBaseObj);
    }

    private <T> void enqueue(LinkedBlockingQueue<T> q, T obj) {
        try {
            boolean success = this.errorOnQueueFull ? q.offer(obj) : q.offer(obj, this.queueWaitTimeout, TimeUnit.MILLISECONDS);
            if (!success) {
                throw new IntellifyQueueFullException("Exceeded wait timeout of " + (this.errorOnQueueFull ? 0 : this.queueWaitTimeout) + "ms for intellify queue with capacity: " + this.client.getOptions().getMaxQueueSize());
            }
            this.client.getStatistics().updateInserted(1.0);
            this.client.getStatistics().updateQueued(q.size());
        }
        catch (InterruptedException e) {
            throw new IntellifyQueueFullException("Interrupted waiting on full intellify queue with capacity: " + this.client.getOptions().getMaxQueueSize());
        }
    }

    public void flush() {
        try {
            this.idle.waitOne();
        }
        catch (InterruptedException e) {
            logger.error("Interrupted while waiting for the thread to flush.", (Throwable)e);
        }
    }

    public void close() {
        this.go = false;
        this.queue.clear();
    }
}

