/*
 * Decompiled with CFR 0.152.
 */
package com.intellifylearning;

import org.apache.commons.lang.StringUtils;

public class Options {
    private String host;
    private int maxQueueSize;
    private boolean errorOnQueueFull;
    private int queueWaitTimeout;
    private int batchSize = 0;
    private int timeout;
    private String sensorId;
    private String correlationId;
    private boolean enableTestMode;

    public Options() {
        this("http://dev-null-intellifylearning-com-heax6eiumqow.runscope.net", 10000, 10000, 10000);
    }

    Options(String host, int maxQueueSize, int queueWaitTimeout, int timeout) {
        this.setHost(host);
        this.setMaxQueueSize(maxQueueSize);
        this.setQueueWaitTimeout(queueWaitTimeout);
        this.setTimeout(timeout);
    }

    public String getHost() {
        return this.host;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getQueueWaitTimeout() {
        return this.queueWaitTimeout;
    }

    public boolean isErrorOnQueueFull() {
        return this.errorOnQueueFull;
    }

    public Options setMaxQueueSize(int maxQueueSize) {
        if (maxQueueSize < 1) {
            throw new IllegalArgumentException("IntellifyBase#option#maxQueueSize must be greater than 0.");
        }
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    public Options setHost(String host) {
        if (StringUtils.isEmpty((String)host)) {
            throw new IllegalArgumentException("IntellifyBase#option#host must be a valid host, like 'https://api.IntelliSense'.");
        }
        this.host = host;
        return this;
    }

    public Options setTimeout(int timeout) {
        if (timeout < 1000) {
            throw new IllegalArgumentException("IntellifyBase#option#timeout must be at least 1000 milliseconds.");
        }
        this.timeout = timeout;
        return this;
    }

    public Options setQueueWaitTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("IntellifyBase#option#queueWaitTimeout must be greater than 0.");
        }
        this.queueWaitTimeout = timeout;
        return this;
    }

    public Options setErrorOnQueueFull(boolean errorOnQueueFull) {
        this.errorOnQueueFull = errorOnQueueFull;
        return this;
    }

    public String getSensorId() {
        return this.sensorId;
    }

    public void setSensorId(String sensorId) {
        this.sensorId = sensorId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public boolean isEnableTestMode() {
        return this.enableTestMode;
    }

    public void setEnableTestMode(boolean enableTestMode) {
        this.enableTestMode = enableTestMode;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

