/*
 * Decompiled with CFR 0.152.
 */
package com.intellifylearning;

import com.intellify.api.caliper.impl.entities.Entity;
import com.intellify.api.caliper.impl.events.Event;
import com.intellifylearning.Client;
import com.intellifylearning.Options;
import com.intellifylearning.metrics.events.CaliperEvent;
import com.intellifylearning.metrics.models.Agent;
import com.intellifylearning.metrics.models.DigitalResource;
import com.intellifylearning.models.Callback;
import com.intellifylearning.stats.IntelliSenseStatistics;

public class Intellify {
    private static Client defaultClient;

    public static synchronized void initialize(String apiKey) {
        if (defaultClient == null) {
            defaultClient = new Client(apiKey, new Options());
        }
    }

    public static synchronized void initialize(String apiKey, Options options) {
        if (defaultClient == null) {
            defaultClient = new Client(apiKey, options);
        }
    }

    private static void checkInitialized() {
        if (defaultClient == null) {
            throw new IllegalStateException("IntellifyBase client is not initialized. Please call IntellifyBase.iniitalize(..); before calling identify / track / or flush.");
        }
    }

    public static void describe(DigitalResource digitalResource) {
        Intellify.checkInitialized();
        defaultClient.identify(digitalResource);
    }

    public static void describeSync(DigitalResource digitalResource) {
        Intellify.checkInitialized();
        defaultClient.identifySync(digitalResource);
    }

    public static void describe(Agent agent) {
        Intellify.checkInitialized();
        defaultClient.identify(agent);
    }

    public static void describeSync(Agent agent) {
        Intellify.checkInitialized();
        defaultClient.identifySync(agent);
    }

    public static void describe(Entity entity) {
        Intellify.checkInitialized();
        defaultClient.identify(entity);
    }

    public static void describeSync(Entity entity) {
        Intellify.checkInitialized();
        defaultClient.identifySync(entity);
    }

    public static void measure(CaliperEvent caliperEvent) {
        Intellify.checkInitialized();
        defaultClient.measure(caliperEvent);
    }

    public static void measureSync(CaliperEvent caliperEvent) {
        Intellify.checkInitialized();
        defaultClient.measureSync(caliperEvent);
    }

    public static void measure(Event event) {
        Intellify.checkInitialized();
        defaultClient.measure(event);
    }

    public static void measureSync(Event event) {
        Intellify.checkInitialized();
        defaultClient.measureSync(event);
    }

    public static void send(Event event) {
        Intellify.checkInitialized();
        defaultClient.measure(event);
    }

    public static void sendSync(Event event) {
        Intellify.checkInitialized();
        defaultClient.measureSync(event);
    }

    public static void registerCallback(Callback callback) {
        Intellify.checkInitialized();
        defaultClient.registerCallback(callback);
    }

    public static void flush() {
        Intellify.checkInitialized();
        defaultClient.flush();
    }

    public static void close() {
        Intellify.checkInitialized();
        defaultClient.close();
    }

    public static void flushAndClose() {
        Intellify.flush();
        Intellify.close();
    }

    public static IntelliSenseStatistics getStatistics() {
        Intellify.checkInitialized();
        return defaultClient.getStatistics();
    }

    public static Client getDefaultClient() {
        return defaultClient;
    }
}

