/*
 * Decompiled with CFR 0.152.
 */
package com.intellifylearning;

import com.intellify.api.caliper.CaliperEntity;
import com.intellify.api.caliper.DescribeData;
import com.intellify.api.caliper.LearningEventData;
import com.intellify.api.caliper.impl.EntityData;
import com.intellify.api.caliper.impl.EventData;
import com.intellify.api.caliper.impl.IntellifyBase;
import com.intellify.api.caliper.impl.entities.Entity;
import com.intellify.api.caliper.impl.events.Event;
import com.intellifylearning.Options;
import com.intellifylearning.flush.Flusher;
import com.intellifylearning.flush.IBatchFactory;
import com.intellifylearning.metrics.events.CaliperEvent;
import com.intellifylearning.metrics.models.Agent;
import com.intellifylearning.metrics.models.DigitalResource;
import com.intellifylearning.models.Batch;
import com.intellifylearning.models.BatchIntellifyBase;
import com.intellifylearning.models.Callback;
import com.intellifylearning.request.BlockingRequester;
import com.intellifylearning.stats.IntelliSenseStatistics;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Client {
    private static final Logger logger = LoggerFactory.getLogger((String)"intellisense");
    private String apiKey;
    private Options options;
    private Flusher flusher;
    private BlockingRequester requester;
    private IntelliSenseStatistics statistics;
    private Callback callback;
    private IBatchFactory factory = new IBatchFactory(){

        @Override
        public Batch create(List<CaliperEntity> batch) {
            return new Batch(Client.this.apiKey, batch);
        }

        @Override
        public BatchIntellifyBase createIntellifyBaseBatch(List<IntellifyBase> batch) {
            return new BatchIntellifyBase(Client.this.apiKey, batch);
        }
    };

    public Client(String apiKey) {
        this(apiKey, new Options());
    }

    public Client(String apiKey, Options options) {
        String errorPrefix = "intellisense-java client must be initialized with a valid ";
        if (StringUtils.isEmpty((String)apiKey)) {
            throw new IllegalArgumentException(errorPrefix + "apiKey.");
        }
        if (options == null) {
            throw new IllegalArgumentException(errorPrefix + "options.");
        }
        this.apiKey = apiKey;
        this.options = options;
        this.statistics = new IntelliSenseStatistics();
        this.requester = new BlockingRequester(this);
        this.flusher = new Flusher(this, this.factory, this.requester);
        this.flusher.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Client.this.flusher.flush();
            }
        });
        logger.debug("Successfully initialized intellisense-java-client with apiKey = " + this.apiKey + " and host = " + this.options.getHost() + " and sensorId = " + this.options.getSensorId());
    }

    public void describe(DigitalResource digitalResource) {
        this.identify(digitalResource);
    }

    public void describeSync(DigitalResource digitalResource) {
        this.identifySync(digitalResource);
    }

    public void identify(DigitalResource digitalResource) {
        DescribeData describeData = this.wrapDescribeData(digitalResource);
        this.flusher.enqueue(describeData);
        logger.debug("Enqueued describe for DigitalResource: " + describeData);
        this.statistics.updateIdentifies(1.0);
    }

    public void identifySync(DigitalResource digitalResource) {
        DescribeData describeData = this.wrapDescribeData(digitalResource);
        this.sendSync(describeData);
    }

    private DescribeData wrapDescribeData(DigitalResource digitalResource) {
        DescribeData describeData = new DescribeData();
        describeData.setEntityId(digitalResource.getId());
        describeData.setProperties(digitalResource.getProperties());
        describeData.setType(digitalResource.getType());
        if (digitalResource.getLastModifiedAt() != 0L) {
            describeData.setTimestamp(digitalResource.getLastModifiedAt());
        } else {
            describeData.setTimestamp(DateTime.now().getMillis());
        }
        this.addIntellifyMetadata(describeData);
        return describeData;
    }

    public void describe(Agent agent) {
        this.identify(agent);
    }

    public void describeSync(Agent agent) {
        this.identifySync(agent);
    }

    public void identify(Agent agent) {
        DescribeData describeData = this.wrapDescribeData(agent);
        this.flusher.enqueue(describeData);
        logger.debug("Enqueued describe for Agent: " + describeData);
        this.statistics.updateIdentifies(1.0);
    }

    public void identifySync(Agent agent) {
        DescribeData describeData = this.wrapDescribeData(agent);
        this.sendSync(describeData);
    }

    private DescribeData wrapDescribeData(Agent agent) {
        DescribeData describeData = new DescribeData();
        describeData.setEntityId(agent.getId());
        describeData.setProperties(agent.getProperties());
        describeData.setType(agent.getType());
        if (agent.getLastModifiedAt() != 0L) {
            describeData.setTimestamp(agent.getLastModifiedAt());
        } else {
            describeData.setTimestamp(DateTime.now().getMillis());
        }
        this.addIntellifyMetadata(describeData);
        return describeData;
    }

    public void describe(Entity entity) {
        this.identify(entity);
    }

    public void describeSync(Entity entity) {
        this.identifySync(entity);
    }

    public void identify(Entity entity) {
        EntityData entityData = this.wrapEntityData(entity);
        this.flusher.enqueue(entityData);
        logger.debug("Enqueued describe for Entity: " + entityData);
        this.statistics.updateIdentifies(1.0);
    }

    public void identifySync(Entity entity) {
        EntityData entityData = this.wrapEntityData(entity);
        this.sendSync(entityData);
    }

    private EntityData wrapEntityData(Entity entity) {
        EntityData entityData = new EntityData();
        entityData.setEntity(entity);
        entityData.setEntityId(entity.getId());
        entityData.setType(entity.getType());
        if (entity.getDateModified() != 0L) {
            entityData.setTimestamp(entity.getDateModified());
        } else {
            entityData.setTimestamp(DateTime.now().getMillis());
        }
        entityData.setEntity(entity);
        this.addIntellifyMetadata(entityData);
        return entityData;
    }

    public void measure(CaliperEvent caliperEvent) {
        LearningEventData event = this.wrapEventData(caliperEvent);
        this.flusher.enqueue(event);
        logger.debug("Enqueued event : " + event);
        this.statistics.updateTracks(1.0);
    }

    public void measureSync(CaliperEvent caliperEvent) {
        LearningEventData event = this.wrapEventData(caliperEvent);
        this.sendSync(event);
    }

    private LearningEventData wrapEventData(CaliperEvent caliperEvent) {
        LearningEventData event = new LearningEventData();
        event.setAction(caliperEvent.getAction());
        event.setActivityContext(caliperEvent.getActivityContext());
        event.setLearningContext(caliperEvent.getLearningContext());
        if (caliperEvent.getTimestamp() != 0L) {
            event.setTimestamp(caliperEvent.getTimestamp());
        } else {
            event.setTimestamp(DateTime.now().getMillis());
        }
        this.addIntellifyMetadata(event);
        return event;
    }

    public void measure(Event event) {
        EventData eventData = this.wrapEventData(event);
        this.flusher.enqueue(eventData);
        logger.debug("Enqueued event data : " + eventData);
        this.statistics.updateTracks(1.0);
    }

    public void measureSync(Event event) {
        EventData eventData = this.wrapEventData(event);
        this.sendSync(eventData);
    }

    private EventData wrapEventData(Event event) {
        EventData eventData = new EventData();
        eventData.setEvent(event);
        if (event.getStartedAtTime() != 0L) {
            eventData.setTimestamp(event.getStartedAtTime());
        } else {
            eventData.setTimestamp(DateTime.now().getMillis());
        }
        this.addIntellifyMetadata(eventData);
        return eventData;
    }

    private void addIntellifyMetadata(IntellifyBase intellifyBaseObj) {
        intellifyBaseObj.setApiKey(this.getapiKey());
        intellifyBaseObj.setSensorId(this.getOptions().getSensorId());
        intellifyBaseObj.setCorrelationId(this.getOptions().getCorrelationId());
    }

    private void addIntellifyMetadata(CaliperEntity caliperEntity) {
        caliperEntity.setApiKey(this.getapiKey());
        caliperEntity.setIl_sensorId(this.getOptions().getSensorId());
        caliperEntity.setIl_correlationId(this.getOptions().getCorrelationId());
    }

    private void sendSync(CaliperEntity entity) {
        Batch batch = new Batch(this.getapiKey(), Collections.singletonList(entity));
        this.requester.send(batch);
    }

    private void sendSync(IntellifyBase entity) {
        BatchIntellifyBase batch = new BatchIntellifyBase(this.getapiKey(), Collections.singletonList(entity));
        this.requester.sendIntellifyBaseBatch(batch);
    }

    public void flush() {
        this.flusher.flush();
    }

    public void close() {
        this.flusher.close();
        this.requester.close();
    }

    public String getapiKey() {
        return this.apiKey;
    }

    public void setapiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public Options getOptions() {
        return this.options;
    }

    public IntelliSenseStatistics getStatistics() {
        return this.statistics;
    }

    protected void registerCallback(Callback callback) {
        this.callback = callback;
    }

    public void notifyEntitySend(boolean success, Entity entity) {
        this.callback.onResponse(success, entity);
    }

    public void notifyEventSend(boolean success, Event event) {
        this.callback.onResponse(success, event);
    }
}

