/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.security;

import com.google.common.collect.Lists;
import com.intellify.api.security.Group;
import com.intellify.api.security.Principal;
import com.intellify.api.security.Role;
import com.intellify.api.security.UserPreferences;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class User
extends Principal {
    @Indexed
    private String externalUserId;
    @Indexed
    private String orgId;
    @NotEmpty
    @Indexed(unique=true)
    private String username;
    @NotEmpty
    private String password;
    @NotEmpty
    private String firstName;
    @NotEmpty
    private String lastName;
    private String middleName;
    @NotEmpty
    private String eMail;
    @NotEmpty
    private String city;
    @NotEmpty
    private String country;
    private String timeZone;
    private String language;
    private String description;
    private String picture;
    private String personalLearningSpaceUUID;
    private boolean active = true;
    @DBRef
    private List<Role> roles = Lists.newArrayList();
    private List<String> groups = Lists.newArrayList();
    UserPreferences userPreferences;

    public User() {
    }

    public User(String uuid) {
        super.setUuid(uuid);
    }

    public String getExternalUserId() {
        return this.externalUserId;
    }

    public void setExternalUserId(String externalUserId) {
        this.externalUserId = externalUserId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getName() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    public void addRole(Role role) {
        this.roles.add(role);
    }

    public void removeRole(Role role) {
        this.roles.remove(role);
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public void addGroup(Group group) {
        this.groups.add(group.getUuid());
    }

    public void removeGroup(Group group) {
        this.groups.remove(group.getUuid());
    }

    public String geteMail() {
        return this.eMail;
    }

    public void seteMail(String eMail) {
        this.eMail = eMail;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public String getPersonalLearningSpaceUUID() {
        return this.personalLearningSpaceUUID;
    }

    public void setPersonalLearningSpaceUUID(String personalLearningSpaceUUID) {
        this.personalLearningSpaceUUID = personalLearningSpaceUUID;
    }

    public UserPreferences getUserPreferences() {
        return this.userPreferences;
    }

    public void setUserPreferences(UserPreferences userPreferences) {
        this.userPreferences = userPreferences;
    }

    @Override
    public boolean equals(Object obj) {
        User other;
        try {
            other = (User)obj;
        }
        catch (ClassCastException ex) {
            return false;
        }
        return this.getUuid().equalsIgnoreCase(other.getUuid());
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("User [externalUserId=").append(this.externalUserId).append(", orgId=").append(this.orgId).append(", username=").append(this.username).append(", password=").append(this.password).append(", active=").append(this.active).append(", firstName=").append(this.firstName).append(", lastName=").append(this.lastName).append(", middleName=").append(this.middleName).append(", eMail=").append(this.eMail).append(", city=").append(this.city).append(", country=").append(this.country).append(", timeZone=").append(this.timeZone).append(", language=").append(this.language).append(", description=").append(this.description).append(", picture=").append(this.picture).append(", roles=").append(this.roles).append(", groups=").append(this.groups).append(", userPreferences=").append(this.userPreferences).append("]");
        return builder.toString();
    }
}

