/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.security;

import com.google.common.collect.Lists;
import com.intellify.api.security.Principal;
import com.intellify.api.security.User;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class Group
extends Principal {
    private List<String> userUuidList = Lists.newArrayList();

    @Override
    @NotEmpty
    public String getName() {
        return super.getName();
    }

    public List<String> getUserUuidList() {
        return this.userUuidList;
    }

    public void setUserUuidList(List<String> userUuidList) {
        this.userUuidList = userUuidList;
    }

    public void addUser(User user) {
        this.userUuidList.add(user.getUuid());
    }

    public void removeUser(User user) {
        this.userUuidList.remove(user.getUuid());
    }

    @Override
    public boolean equals(Object obj) {
        Group other;
        try {
            other = (Group)obj;
        }
        catch (ClassCastException ex) {
            return false;
        }
        return this.getUuid().equalsIgnoreCase(other.getUuid()) && this.getName() != null && this.getName().equalsIgnoreCase(other.getName());
    }
}

