/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.intellify.api.security.User;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class AccessToken {
    @Id
    private String uuid;
    @DBRef
    private User user;
    private long grantTime;
    private long VALIDITY_PERIOD = 28800000L;
    @Indexed
    private String oneTimeToken;

    public AccessToken() {
        this.grantTime = System.currentTimeMillis();
    }

    public AccessToken(long validityPeriodInSeconds) {
        this();
        this.VALIDITY_PERIOD = validityPeriodInSeconds * 1000L;
    }

    public AccessToken(String uuid) {
        this.uuid = uuid;
    }

    public long getGrantTime() {
        return this.grantTime;
    }

    public void setGrantTime(long grantTime) {
        this.grantTime = grantTime;
    }

    @JsonIgnore
    public boolean isValid() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.grantTime > this.VALIDITY_PERIOD) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public boolean equals(Object obj) {
        AccessToken other = (AccessToken)obj;
        return this.getUuid().equalsIgnoreCase(other.getUuid());
    }

    public String getOneTimeToken() {
        return this.oneTimeToken;
    }

    public void setOneTimeToken(String oneTimeToken) {
        this.oneTimeToken = oneTimeToken;
    }
}

