/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.caliper.impl.profiles;

import com.intellify.api.caliper.impl.entities.DigitalResource;
import com.intellify.api.caliper.impl.entities.Targetable;
import com.intellify.api.caliper.impl.entities.media.MediaLocation;
import com.intellify.api.caliper.impl.entities.reading.Frame;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public abstract class Profile {
    public static String getNavigatedToActionFromBundle(String key) {
        if (key.equals("navigation.navigatedTo")) {
            return ResourceBundle.getBundle("actions").getString(key);
        }
        throw new IllegalArgumentException("Unrecognized key: " + key);
    }

    public static DigitalResource validateDigitalResource(Object object) {
        if (object instanceof DigitalResource) {
            return (DigitalResource)object;
        }
        throw new ClassCastException("Object must be of type CreativeWork.");
    }

    public static Targetable validateTarget(Targetable target) {
        if (target instanceof Frame) {
            return (Frame)target;
        }
        if (target instanceof MediaLocation) {
            return (MediaLocation)target;
        }
        throw new ClassCastException("Object must implement the Targetable interface.");
    }

    public static enum Actions {
        DOWNLOADED("item.downloaded"),
        UPLOADED("item.uploaded"),
        LOGGED_IN("session.loggedIn"),
        LOGGED_OUT("session.loggedOut"),
        NAVIGATED_TO("navigation.navigatedTo");

        private final String key;
        private static final Map<String, Actions> lookup;

        private Actions(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }

        public static boolean hasKey(String key) {
            return lookup.containsKey(key);
        }

        public static Actions lookupConstant(String key) {
            return lookup.get(key);
        }

        static {
            lookup = new HashMap<String, Actions>();
            for (Actions constants : Actions.values()) {
                lookup.put(constants.key(), constants);
            }
        }
    }
}

