/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.caliper.impl.profiles;

import com.intellify.api.caliper.impl.entities.Generatable;
import com.intellify.api.caliper.impl.entities.assignable.Attempt;
import com.intellify.api.caliper.impl.entities.outcome.Result;
import com.intellify.api.caliper.impl.profiles.Profile;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class OutcomeProfile
extends Profile {
    public static String getActionFromBundle(String key) {
        if (OutcomeActions.hasKey(key) || Profile.Actions.hasKey(key)) {
            return ResourceBundle.getBundle("actions").getString(key);
        }
        throw new IllegalArgumentException("Unrecognized key: " + key);
    }

    public static Attempt validateObject(Object object) {
        if (object instanceof Attempt) {
            return (Attempt)object;
        }
        throw new ClassCastException("Object must be of type Attempt.");
    }

    public static Result validateGenerated(Generatable generated) {
        if (generated instanceof Result) {
            return (Result)generated;
        }
        throw new ClassCastException("Generatable must be of type Result.");
    }

    public static enum OutcomeActions {
        GRADED("outcome.graded"),
        POSTED("outcome.posted"),
        REPORTED("outcome.reported"),
        NAVIGATED_TO("navigation.navigatedTo");

        private final String key;
        private static final Map<String, OutcomeActions> lookup;

        private OutcomeActions(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }

        public static boolean hasKey(String key) {
            return lookup.containsKey(key);
        }

        public static OutcomeActions lookupConstant(String key) {
            return lookup.get(key);
        }

        static {
            lookup = new HashMap<String, OutcomeActions>();
            for (OutcomeActions constants : OutcomeActions.values()) {
                lookup.put(constants.key(), constants);
            }
        }
    }
}

