/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.caliper.impl.profiles;

import com.intellify.api.caliper.impl.entities.Generatable;
import com.intellify.api.caliper.impl.entities.assignable.AssignableDigitalResource;
import com.intellify.api.caliper.impl.entities.assignable.Attempt;
import com.intellify.api.caliper.impl.profiles.Profile;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class AssignableProfile
extends Profile {
    public static String getActionFromBundle(String key) {
        if (AssignableActions.hasKey(key) || Profile.Actions.hasKey(key)) {
            return ResourceBundle.getBundle("actions").getString(key);
        }
        throw new IllegalArgumentException("Unrecognized key: " + key);
    }

    public static AssignableDigitalResource validateObject(Object object) {
        if (object instanceof AssignableDigitalResource) {
            return (AssignableDigitalResource)object;
        }
        throw new ClassCastException("Object must be of type AssignableDigitalResource.");
    }

    public static Attempt validateGenerated(Generatable generated) {
        if (generated instanceof Attempt) {
            return (Attempt)generated;
        }
        throw new ClassCastException("Generated must be of type Attempt.");
    }

    public static enum AssignableActions {
        ABANDONED("assignable.abandoned"),
        ACTIVATED("assignable.activated"),
        COMPLETED("assignable.completed"),
        DEACTIVATED("assignable.deactivated"),
        HID("assignable.hid"),
        REVIEWED("assignable.reviewed"),
        SHOWED("assignable.showed"),
        STARTED("assignable.started"),
        SUBMITTED("assignable.submitted"),
        NAVIGATED_TO("navigation.navigatedTo");

        private final String key;
        private static final Map<String, AssignableActions> lookup;

        private AssignableActions(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }

        public static boolean hasKey(String key) {
            return lookup.containsKey(key);
        }

        public static AssignableActions lookupConstant(String key) {
            return lookup.get(key);
        }

        static {
            lookup = new HashMap<String, AssignableActions>();
            for (AssignableActions constants : AssignableActions.values()) {
                lookup.put(constants.key(), constants);
            }
        }
    }
}

