/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.caliper.impl.profiles;

import com.intellify.api.caliper.impl.entities.Targetable;
import com.intellify.api.caliper.impl.entities.annotation.Annotation;
import com.intellify.api.caliper.impl.entities.annotation.BookmarkAnnotation;
import com.intellify.api.caliper.impl.entities.annotation.HighlightAnnotation;
import com.intellify.api.caliper.impl.entities.annotation.SharedAnnotation;
import com.intellify.api.caliper.impl.entities.annotation.TagAnnotation;
import com.intellify.api.caliper.impl.entities.reading.Frame;
import com.intellify.api.caliper.impl.profiles.Profile;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class AnnotationProfile
extends Profile {
    public static String getActionFromBundle(String key) {
        if (AnnotationActions.hasKey(key) || Profile.Actions.hasKey(key)) {
            return ResourceBundle.getBundle("actions").getString(key);
        }
        throw new IllegalArgumentException("Unrecognized key: " + key);
    }

    public static Annotation validateObject(Object object) {
        if (object instanceof BookmarkAnnotation) {
            return (BookmarkAnnotation)object;
        }
        if (object instanceof HighlightAnnotation) {
            return (HighlightAnnotation)object;
        }
        if (object instanceof SharedAnnotation) {
            return (SharedAnnotation)object;
        }
        if (object instanceof TagAnnotation) {
            return (TagAnnotation)object;
        }
        throw new ClassCastException("Object must be of type Annotation.");
    }

    public static Frame validateTarget(Targetable target) {
        if (target instanceof Frame) {
            return (Frame)target;
        }
        throw new ClassCastException("Target must be of type Frame.");
    }

    public static enum AnnotationActions {
        ATTACHED("annotation.attached"),
        BOOKMARKED("annotation.bookmarked"),
        CLASSIFIED("annotation.classified"),
        COMMENTED("annotation.commented"),
        DESCRIBED("annotation.described"),
        HIGHLIGHTED("annotation.highlighted"),
        IDENTIFIED("annotation.identified"),
        LIKED("annotation.liked"),
        LINKED("annotation.linked"),
        RANKED("annotation.ranked"),
        QUESTIONED("annotation.questioned"),
        RECOMMENDED("annotation.recommended"),
        REPLIED("annotation.replied"),
        SHARED("annotation.shared"),
        SUBSCRIBED("annotation.subscribed"),
        TAGGED("annotation.tagged");

        private final String key;
        private static final Map<String, AnnotationActions> lookup;

        private AnnotationActions(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }

        public static boolean hasKey(String key) {
            return lookup.containsKey(key);
        }

        public static AnnotationActions lookupConstant(String key) {
            return lookup.get(key);
        }

        static {
            lookup = new HashMap<String, AnnotationActions>();
            for (AnnotationActions constants : AnnotationActions.values()) {
                lookup.put(constants.key(), constants);
            }
        }
    }
}

