/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.caliper.impl.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.intellify.api.caliper.impl.entities.Generatable;
import com.intellify.api.caliper.impl.entities.SoftwareApplication;
import com.intellify.api.caliper.impl.entities.Targetable;
import com.intellify.api.caliper.impl.entities.foaf.Agent;
import com.intellify.api.caliper.impl.entities.lis.Organization;
import com.intellify.api.caliper.impl.events.AnnotationEvent;
import com.intellify.api.caliper.impl.events.AssessmentEvent;
import com.intellify.api.caliper.impl.events.AssessmentItemEvent;
import com.intellify.api.caliper.impl.events.AssignableEvent;
import com.intellify.api.caliper.impl.events.MediaEvent;
import com.intellify.api.caliper.impl.events.NavigationEvent;
import com.intellify.api.caliper.impl.events.OutcomeEvent;
import com.intellify.api.caliper.impl.events.SessionEvent;
import com.intellify.api.caliper.impl.events.ViewEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="iType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SessionEvent.class, name="SessionEvent"), @JsonSubTypes.Type(value=AnnotationEvent.class, name="AnnotationEvent"), @JsonSubTypes.Type(value=AssessmentEvent.class, name="AssessmentEvent"), @JsonSubTypes.Type(value=AssessmentItemEvent.class, name="AssessmentItemEvent"), @JsonSubTypes.Type(value=AssignableEvent.class, name="AssignableEvent"), @JsonSubTypes.Type(value=OutcomeEvent.class, name="OutcomeEvent"), @JsonSubTypes.Type(value=MediaEvent.class, name="MediaEvent"), @JsonSubTypes.Type(value=NavigationEvent.class, name="NavigationEvent"), @JsonSubTypes.Type(value=ViewEvent.class, name="ViewEvent")})
@JsonPropertyOrder(value={"@context", "@type", "actor", "action", "object", "target", "generated", "startedAtTime", "endedAtTime", "duration", "edApp", "group"})
public abstract class Event {
    private static final Logger LOG = LoggerFactory.getLogger(Event.class);
    @JsonProperty(value="@context")
    protected String context;
    @JsonProperty(value="@type")
    protected String type;
    @JsonProperty(value="edApp")
    protected SoftwareApplication edApp;
    @JsonProperty(value="group")
    protected Organization lisOrganization;
    @JsonProperty(value="actor")
    protected Agent actor;
    @JsonProperty(value="action")
    protected String action;
    @JsonProperty(value="object")
    protected Object object;
    @JsonProperty(value="target")
    protected Targetable target;
    @JsonProperty(value="generated")
    protected Generatable generated;
    @JsonProperty(value="startedAtTime")
    @Deprecated
    protected long startedAtTime;
    @JsonProperty(value="endedAtTime")
    @Deprecated
    protected long endedAtTime;
    @JsonProperty(value="eventTime")
    protected String eventTime;
    @JsonProperty(value="duration")
    protected String duration;

    public Event() {
    }

    protected Event(Builder<?> builder) {
        this.setContext(builder.context);
        this.setType(builder.type);
        this.setEdApp(builder.edApp);
        this.setLisOrganization(builder.lisOrganization);
        this.setActor(builder.actor);
        this.setAction(builder.action);
        this.setObject(builder.object);
        this.setTarget(builder.target);
        this.setGenerated(builder.generated);
        this.setStartedAtTime(builder.startedAtTime);
        this.setEndedAtTime(builder.endedAtTime);
        this.setDuration(builder.duration);
        this.setEventTime(builder.eventTime);
    }

    public String getContext() {
        return this.context;
    }

    public String getType() {
        return this.type;
    }

    public SoftwareApplication getEdApp() {
        return this.edApp;
    }

    public Organization getLisOrganization() {
        return this.lisOrganization;
    }

    public Agent getActor() {
        return this.actor;
    }

    public String getAction() {
        return this.action;
    }

    public Object getObject() {
        return this.object;
    }

    public Targetable getTarget() {
        return this.target;
    }

    public Generatable getGenerated() {
        return this.generated;
    }

    public long getStartedAtTime() {
        return this.startedAtTime;
    }

    public long getEndedAtTime() {
        return this.endedAtTime;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setEdApp(SoftwareApplication edApp) {
        this.edApp = edApp;
    }

    public void setLisOrganization(Organization lisOrganization) {
        this.lisOrganization = lisOrganization;
    }

    public void setActor(Agent actor) {
        this.actor = actor;
    }

    public void setAction(String action) {
        this.action = action;
        LOG.debug("Intellify Event - action = " + this.action);
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setTarget(Targetable target) {
        this.target = target;
    }

    public void setGenerated(Generatable generated) {
        this.generated = generated;
    }

    public void setStartedAtTime(long startedAtTime) {
        this.startedAtTime = startedAtTime;
    }

    public void setEndedAtTime(long endedAtTime) {
        this.endedAtTime = endedAtTime;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(String eventTime) {
        this.eventTime = eventTime;
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String context;
        protected String type;
        protected SoftwareApplication edApp;
        protected Organization lisOrganization;
        protected Agent actor;
        protected String action;
        protected Object object;
        protected Targetable target;
        protected Generatable generated;
        protected long startedAtTime;
        protected long endedAtTime;
        protected String eventTime;
        protected String duration;

        protected abstract T self();

        public Builder() {
            this.context(Context.EVENT.uri());
            this.type(Type.EVENT.uri());
        }

        protected T context(String context) {
            this.context = context;
            return this.self();
        }

        protected T type(String type) {
            this.type = type;
            return this.self();
        }

        public T edApp(SoftwareApplication edApp) {
            this.edApp = edApp;
            return this.self();
        }

        public T lisOrganization(Organization lisOrganization) {
            this.lisOrganization = lisOrganization;
            return this.self();
        }

        public T actor(Agent actor) {
            this.actor = actor;
            return this.self();
        }

        public T action(String action) {
            this.action = action;
            return this.self();
        }

        public T object(Object object) {
            this.object = object;
            return this.self();
        }

        public T target(Targetable target) {
            this.target = target;
            return this.self();
        }

        public T generated(Generatable generated) {
            this.generated = generated;
            return this.self();
        }

        public T startedAtTime(long startedAtTime) {
            this.startedAtTime = startedAtTime;
            return this.self();
        }

        public T endedAtTime(long endedAtTime) {
            this.endedAtTime = endedAtTime;
            return this.self();
        }

        public T eventTime(String eventTime) {
            this.eventTime = eventTime;
            return this.self();
        }

        public T duration(String duration) {
            this.duration = duration;
            return this.self();
        }
    }

    public static enum Type {
        ANNOTATION("http://purl.imsglobal.org/caliper/v1/AnnotationEvent"),
        ASSESSMENT("http://purl.imsglobal.org/caliper/v1/AssessmentEvent"),
        ASSESSMENT_ITEM("http://purl.imsglobal.org/caliper/v1/AssessmentItemEvent"),
        ASSIGNABLE("http://purl.imsglobal.org/caliper/v1/AssignableEvent"),
        EVENT("http://purl.imsglobal.org/caliper/v1/Event"),
        MEDIA("http://purl.imsglobal.org/caliper/v1/MediaEvent"),
        NAVIGATION("http://purl.imsglobal.org/caliper/v1/NavigationEvent"),
        OUTCOME("http://purl.imsglobal.org/caliper/v1/OutcomeEvent"),
        SESSION("http://purl.imsglobal.org/caliper/v1/SessionEvent"),
        READING("http://purl.imsglobal.org/caliper/v1/ReadingEvent"),
        VIEW("http://purl.imsglobal.org/caliper/v1/ViewEvent");

        private final String uri;

        private Type(String uri) {
            this.uri = uri;
        }

        public String uri() {
            return this.uri;
        }
    }

    public static enum Context {
        ANNOTATION("http://purl.imsglobal.org/ctx/caliper/v1/AnnotationEvent"),
        ASSESSMENT("http://purl.imsglobal.org/ctx/caliper/v1/AssessmentEvent"),
        ASSESSMENT_ITEM("http://purl.imsglobal.org/ctx/caliper/v1/AssessmentItemEvent"),
        ASSIGNABLE("http://purl.imsglobal.org/ctx/caliper/v1/AssignableEvent"),
        EVENT("http://purl.imsglobal.org/ctx/caliper/v1/Event"),
        MEDIA("http://purl.imsglobal.org/ctx/caliper/v1/MediaEvent"),
        NAVIGATION("http://purl.imsglobal.org/ctx/caliper/v1/NavigationEvent"),
        OUTCOME("http://purl.imsglobal.org/ctx/caliper/v1/OutcomeEvent"),
        SESSION("http://purl.imsglobal.org/ctx/caliper/v1/SessionEvent"),
        READING("http://purl.imsglobal.org/ctx/caliper/v1/ReadingEvent"),
        VIEW("http://purl.imsglobal.org/ctx/caliper/v1/ViewEvent");

        private final String uri;

        private Context(String uri) {
            this.uri = uri;
        }

        public String uri() {
            return this.uri;
        }
    }
}

