/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.caliper.impl.entities.annotation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.intellify.api.caliper.impl.entities.annotation.Annotation;
import com.intellify.api.caliper.impl.entities.annotation.TextPositionSelector;

@JsonPropertyOrder(value={"@id", "@type", "name", "dateCreated", "dateModified", "selection", "selectionText"})
public class HighlightAnnotation
extends Annotation {
    @JsonProperty(value="selection")
    private TextPositionSelector selection;
    @JsonProperty(value="selectionText")
    private String selectionText;

    public HighlightAnnotation() {
    }

    protected HighlightAnnotation(Builder<?> builder) {
        super((Annotation.Builder<?>)builder);
        this.selection = ((Builder)builder).selection;
        this.selectionText = ((Builder)builder).selectionText;
    }

    public TextPositionSelector getSelection() {
        return this.selection;
    }

    public String getSelectionText() {
        return this.selectionText;
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public void setSelection(TextPositionSelector selection) {
        this.selection = selection;
    }

    public void setSelectionText(String selectionText) {
        this.selectionText = selectionText;
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Annotation.Builder<T> {
        private TextPositionSelector selection;
        private String selectionText;

        public Builder() {
            this.type(Annotation.Type.HIGHLIGHT_ANNOTATION.uri());
            this.selection = new TextPositionSelector();
        }

        public T selectionStart(String start) {
            this.selection.setStart(start);
            return (T)((Builder)this.self());
        }

        public T selectionEnd(String end) {
            this.selection.setEnd(end);
            return (T)((Builder)this.self());
        }

        public T selectionText(String selectionText) {
            this.selectionText = selectionText;
            return (T)((Builder)this.self());
        }

        public HighlightAnnotation build() {
            return new HighlightAnnotation(this);
        }
    }
}

