/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.caliper.impl.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellify.api.caliper.impl.entities.Entity;
import com.intellify.api.caliper.impl.entities.LearningObjective;
import com.intellify.api.caliper.impl.entities.schemadotorg.CreativeWork;
import java.util.Collection;
import java.util.List;

@JsonPropertyOrder(value={"@id", "@type", "name", "objectType", "alignedLearningObjective", "keywords", "isPartOf", "dateCreated", "dateModified"})
public class DigitalResource
extends Entity
implements CreativeWork {
    @JsonProperty(value="objectType")
    private ImmutableList<String> objectTypes;
    @JsonProperty(value="alignedLearningObjective")
    private ImmutableList<LearningObjective> learningObjectives;
    @JsonProperty(value="keywords")
    private ImmutableList<String> keywords;
    @JsonProperty(value="isPartOf")
    private Object isPartOf;
    @JsonProperty(value="author")
    private String author;
    @JsonProperty(value="datePublished")
    protected long datePublished;

    public DigitalResource() {
    }

    protected DigitalResource(Builder<?> builder) {
        super(builder);
        this.setType(builder.type);
        this.objectTypes = ImmutableList.copyOf((Collection)((Builder)builder).objectTypes);
        this.learningObjectives = ImmutableList.copyOf((Collection)((Builder)builder).learningObjectives);
        this.keywords = ImmutableList.copyOf((Collection)((Builder)builder).keywords);
        this.isPartOf = ((Builder)builder).isPartOf;
        this.author = ((Builder)builder).author;
        this.datePublished = builder.datePublished;
    }

    public ImmutableList<String> getObjectTypes() {
        return this.objectTypes;
    }

    public ImmutableList<LearningObjective> getLearningObjectives() {
        return this.learningObjectives;
    }

    public ImmutableList<String> getKeywords() {
        return this.keywords;
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setObjectTypes(ImmutableList<String> objectTypes) {
        this.objectTypes = objectTypes;
    }

    public void setLearningObjectives(ImmutableList<LearningObjective> learningObjectives) {
        this.learningObjectives = learningObjectives;
    }

    public void setKeywords(ImmutableList<String> keywords) {
        this.keywords = keywords;
    }

    public long getDatePublished() {
        return this.datePublished;
    }

    public void setDatePublished(long datePublished) {
        this.datePublished = datePublished;
    }

    public Object getIsPartOf() {
        return this.isPartOf;
    }

    public void setIsPartOf(Object isPartOf) {
        this.isPartOf = isPartOf;
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Entity.Builder<T> {
        private List<String> objectTypes = Lists.newArrayList();
        private List<LearningObjective> learningObjectives = Lists.newArrayList();
        private List<String> keywords = Lists.newArrayList();
        private Object isPartOf;
        private String author;
        protected long datePublished;

        public Builder() {
            this.type(Entity.Type.DIGITAL_RESOURCE.uri());
        }

        public T objectTypes(List<String> objectTypes) {
            this.objectTypes = objectTypes;
            return (T)((Builder)this.self());
        }

        public T objectType(String objectType) {
            this.objectTypes.add(objectType);
            return (T)((Builder)this.self());
        }

        public T datePublished(long datePublished) {
            this.datePublished = datePublished;
            return (T)((Builder)this.self());
        }

        public T learningObjectives(List<LearningObjective> learningObjectives) {
            this.learningObjectives = learningObjectives;
            return (T)((Builder)this.self());
        }

        public T learningObjective(LearningObjective learningObjective) {
            this.learningObjectives.add(learningObjective);
            return (T)((Builder)this.self());
        }

        public T keywords(List<String> keywords) {
            this.keywords = keywords;
            return (T)((Builder)this.self());
        }

        public T keyword(String keyword) {
            this.keywords.add(keyword);
            return (T)((Builder)this.self());
        }

        public T isPartOf(Object isPartOf) {
            this.isPartOf = isPartOf;
            return (T)((Builder)this.self());
        }

        public T author(String author) {
            this.author = author;
            return (T)((Builder)this.self());
        }

        public DigitalResource build() {
            return new DigitalResource(this);
        }
    }

    public static enum Type {
        ASSIGNABLE_DIGITAL_RESOURCE("http://purl.imsglobal.org/caliper/v1/AssignableDigitalResource"),
        EPUB_CHAPTER("http://www.idpf.org/epub/vocab/structure/#chapter"),
        EPUB_PART("http://www.idpf.org/epub/vocab/structure/#part"),
        EPUB_SUB_CHAPTER("http://www.idpf.org/epub/vocab/structure/#subchapter"),
        EPUB_VOLUME("http://www.idpf.org/epub/vocab/structure/#volume"),
        FRAME("http://purl.imsglobal.org/caliper/v1/Frame"),
        MEDIA_LOCATION("http://purl.imsglobal.org/caliper/v1/MediaLocation"),
        MEDIA_OBJECT("http://purl.imsglobal.org/caliper/v1/MediaObject"),
        READING("http://www.idpf.org/epub/vocab/structure"),
        WEB_PAGE("http://purl.imsglobal.org/caliper/v1/WebPage");

        private final String uri;

        private Type(String uri) {
            this.uri = uri;
        }

        public String uri() {
            return this.uri;
        }
    }
}

