/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.admin.spec;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellify.api.admin.spec.AggregationOperator;
import com.intellify.api.admin.spec.ProcessingSpec;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReshapeSpec
implements ProcessingSpec {
    private static final Logger LOG = LoggerFactory.getLogger(ReshapeSpec.class);
    private List<String> includeFields = Lists.newArrayList();
    private Map<String, String> renameFields = Maps.newHashMap();
    private Map<String, AggregationOperator> computedFields = Maps.newHashMap();

    public List<String> getIncludeFields() {
        return this.includeFields;
    }

    public void setIncludeFields(List<String> includeFields) {
        this.includeFields = includeFields;
    }

    public Map<String, String> getRenameFields() {
        return this.renameFields;
    }

    public void setRenameFields(Map<String, String> renameFields) {
        this.renameFields = renameFields;
    }

    public Map<String, AggregationOperator> getComputedFields() {
        return this.computedFields;
    }

    public void setComputedFields(Map<String, AggregationOperator> computedFields) {
        this.computedFields = computedFields;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReshapeSpec)) {
            return false;
        }
        ReshapeSpec objToCompare = (ReshapeSpec)obj;
        ReshapeSpec thisObj = this;
        boolean equals = true;
        if (Iterables.size(thisObj.getIncludeFields()) != Iterables.size(objToCompare.getIncludeFields())) {
            return false;
        }
        int index = 0;
        for (String includeField : thisObj.getIncludeFields()) {
            if (!includeField.equals(objToCompare.getIncludeFields().get(index))) {
                equals = false;
            }
            ++index;
        }
        if (!thisObj.getRenameFields().equals(objToCompare.getRenameFields())) {
            equals = false;
        }
        if (thisObj.getComputedFields().keySet().size() != objToCompare.getComputedFields().keySet().size()) {
            equals = false;
        }
        Set<String> compFields = thisObj.getComputedFields().keySet();
        for (String compField : compFields) {
            LOG.debug("ReshapeSpec.equals(): Comparing " + thisObj.getComputedFields().get(compField) + " to " + objToCompare.getComputedFields().get(compField));
            if (thisObj.getComputedFields().get(compField).equals(objToCompare.getComputedFields().get(compField))) continue;
            equals = false;
        }
        return equals;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ReshapeSpec [includeFields=").append(this.includeFields).append(", renameFields=").append(this.renameFields).append(", computedFields=").append(this.computedFields).append("]");
        return builder.toString();
    }
}

