/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.admin.spec;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.intellify.api.admin.spec.ProcessingSpec;
import com.intellify.api.admin.spec.RemoteServiceMethod;
import java.util.Arrays;

public class RemoteServiceSpec
implements ProcessingSpec {
    private static final long serialVersionUID = 1L;
    private String consumes;
    private String produces;
    private RemoteServiceMethod[] methods;
    private String protocol;
    private String hostname;
    private String port;

    public String getConsumes() {
        return this.consumes;
    }

    public void setConsumes(String consumes) {
        this.consumes = consumes;
    }

    public String getProduces() {
        return this.produces;
    }

    public void setProduces(String produces) {
        this.produces = produces;
    }

    public RemoteServiceMethod[] getMethods() {
        return this.methods;
    }

    public void setMethods(RemoteServiceMethod[] methods) {
        this.methods = methods;
    }

    @JsonIgnore
    public String getURL() {
        String fullHostname = this.getHostname();
        if (!Strings.isNullOrEmpty((String)this.getPort())) {
            fullHostname = fullHostname + ":" + this.getPort();
        }
        return this.getProtocol() + "://" + fullHostname;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RemoteServiceSpec)) {
            return false;
        }
        RemoteServiceSpec o = (RemoteServiceSpec)obj;
        return Objects.equal((Object)this.consumes, (Object)o.consumes) && Objects.equal((Object)this.produces, (Object)o.produces) && Objects.equal((Object)this.protocol, (Object)o.protocol) && Objects.equal((Object)this.hostname, (Object)o.hostname) && Objects.equal((Object)this.port, (Object)o.port) && Arrays.equals(this.methods, o.methods);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.consumes, this.produces, this.protocol, this.hostname, this.port, this.methods});
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }
}

