/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.admin;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.intellify.api.Entity;
import com.intellify.api.admin.SensorType;
import com.intellify.api.admin.spec.DataSourceSpec;
import java.util.List;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class DataSource
extends Entity
implements DataSourceSpec {
    @JsonIgnore
    private String OWN_SENSOR_ONLY = "own_sensor_only";
    @JsonIgnore
    private String ANY_SENSOR_IN_COLLECTION = "any_sensor_in_collection";
    private boolean active = false;
    private boolean jobRequired = false;
    @Indexed
    private String sensorId;
    private SensorType sensorType;
    private String rawEventStreamName;
    private String rawDescribeStreamName;
    private boolean usesSharedStream = false;
    private boolean streamIsSearchable = true;
    @Indexed
    private String parentDataCollectionId;
    private String cronExpression;
    private List<String> courseIds = Lists.newArrayList();
    @Deprecated
    private String sharedSecret;
    private String url;
    private String trustLevel = this.OWN_SENSOR_ONLY;
    private boolean allowNullSensorId;
    private List<String> learningContextUniqueAttr = Lists.newArrayList((Object[])new String[]{"personId", "courseId"});
    private List<String> activityContextUniqueAttr = Lists.newArrayList((Object[])new String[]{"activityId"});

    public DataSource() {
    }

    public DataSource(String sensorId, SensorType sensorType) {
        this.sensorId = sensorId;
        this.sensorType = sensorType;
    }

    public String getSensorId() {
        return this.sensorId;
    }

    public void setSensorId(String sensorId) {
        this.sensorId = sensorId;
    }

    public SensorType getSensorType() {
        return this.sensorType;
    }

    public void setSensorType(SensorType sensorType) {
        this.sensorType = sensorType;
    }

    public String getParentDataCollectionId() {
        return this.parentDataCollectionId;
    }

    public void setParentDataCollectionId(String parentDataCollectionId) {
        this.parentDataCollectionId = parentDataCollectionId;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public List<String> getCourseIds() {
        return this.courseIds;
    }

    public void setCourseIds(List<String> courseIds) {
        this.courseIds = courseIds;
    }

    public void addCourseId(String courseId) {
        this.courseIds.add(courseId);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isJobRequired() {
        return this.jobRequired;
    }

    public void setJobRequired(boolean jobRequired) {
        this.jobRequired = jobRequired;
    }

    @Deprecated
    public String getSharedSecret() {
        return this.sharedSecret;
    }

    @Deprecated
    public void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getTrustLevel() {
        return this.trustLevel;
    }

    public void setTrustLevel(String trustLevel) {
        this.trustLevel = trustLevel;
    }

    public boolean isAllowNullSensorId() {
        return this.allowNullSensorId;
    }

    public void setAllowNullSensorId(boolean allowNullSensorId) {
        this.allowNullSensorId = allowNullSensorId;
    }

    public List<String> getLearningContextUniqueAttr() {
        return this.learningContextUniqueAttr;
    }

    public void setLearningContextUniqueAttr(List<String> learningContextUniqueAttr) {
        this.learningContextUniqueAttr = learningContextUniqueAttr;
    }

    public List<String> getActivityContextUniqueAttr() {
        return this.activityContextUniqueAttr;
    }

    public void setActivityContextUniqueAttr(List<String> activityContextUniqueAttr) {
        this.activityContextUniqueAttr = activityContextUniqueAttr;
    }

    public String getRawEventStreamName() {
        return this.rawEventStreamName;
    }

    public void setRawEventStreamName(String rawEventStreamName) {
        this.rawEventStreamName = rawEventStreamName;
    }

    public String getRawDescribeStreamName() {
        return this.rawDescribeStreamName;
    }

    public void setRawDescribeStreamName(String rawDescribeStreamName) {
        this.rawDescribeStreamName = rawDescribeStreamName;
    }

    public boolean isUsesSharedStream() {
        return this.usesSharedStream;
    }

    public void setUsesSharedStream(boolean usesSharedStream) {
        this.usesSharedStream = usesSharedStream;
    }

    public boolean isStreamIsSearchable() {
        return this.streamIsSearchable;
    }

    public void setStreamIsSearchable(boolean streamIsSearchable) {
        this.streamIsSearchable = streamIsSearchable;
    }
}

