/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.spring.data.common;

import com.google.common.base.CaseFormat;
import com.infobip.spring.data.common.ParameterAndExpressionPair;
import com.infobip.spring.data.common.PreferredConstructorDiscoverer;
import com.infobip.spring.data.common.QSet;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Projections;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.relational.core.mapping.Embedded;
import org.springframework.data.relational.core.mapping.MappedCollection;
import org.springframework.util.ReflectionUtils;

public class QuerydslExpressionFactory {
    private final Class<?> repositoryTargetType;

    public QuerydslExpressionFactory(Class<?> repositoryTargetType) {
        this.repositoryTargetType = repositoryTargetType;
    }

    public ConstructorExpression<?> getConstructorExpression(Class<?> type, RelationalPath<?> pathBase) {
        Constructor<?> constructor = this.getConstructor(type);
        if (constructor == null) {
            throw new IllegalArgumentException("Could not discover preferred constructor for " + type);
        }
        Map<String, Expression<?>> columnNameToExpression = pathBase.getColumns().stream().collect(Collectors.toMap(column -> column.getMetadata().getName(), Function.identity()));
        Parameter[] parameters = constructor.getParameters();
        Map<String, Expression<?>> embeddedConstructorParameterNameToPath = this.getEmbeddedConstructorParameterNameToPath(type, pathBase, columnNameToExpression, parameters);
        List pairs = Stream.of(constructor.getParameters()).map(parameter -> this.getExpression(type, columnNameToExpression, embeddedConstructorParameterNameToPath, (Parameter)parameter)).collect(Collectors.toList());
        Class[] paramTypes = (Class[])pairs.stream().map(ParameterAndExpressionPair::parameterType).toArray(Class[]::new);
        Expression[] expressions = (Expression[])pairs.stream().map(ParameterAndExpressionPair::expression).toArray(Expression[]::new);
        return Projections.constructor(type, (Class[])paramTypes, (Expression[])expressions);
    }

    private ParameterAndExpressionPair getExpression(Class<?> type, Map<String, Expression<?>> columnNameToPath, Map<String, Expression<?>> embeddedConstructorParameterNameToPath, Parameter parameter) {
        Expression<?> path = columnNameToPath.get(parameter.getName());
        if (Objects.isNull(path)) {
            return this.resolveNonColumnParameter(type, embeddedConstructorParameterNameToPath, parameter);
        }
        return new ParameterAndExpressionPair(parameter.getType(), path);
    }

    private ParameterAndExpressionPair resolveNonColumnParameter(Class<?> type, Map<String, Expression<?>> embeddedConstructorParameterNameToPath, Parameter parameter) {
        String name = parameter.getName();
        if (embeddedConstructorParameterNameToPath.containsKey(name)) {
            return new ParameterAndExpressionPair(parameter.getType(), embeddedConstructorParameterNameToPath.get(name));
        }
        Field field = ReflectionUtils.findField(type, (String)name);
        if (Objects.nonNull(field) && Objects.nonNull(AnnotationUtils.getAnnotation((AnnotatedElement)field, MappedCollection.class))) {
            return this.resolveMappedCollectionParameter(parameter);
        }
        throw new IllegalArgumentException("Failed to match parameter " + name + " to QClass column for " + type);
    }

    private ParameterAndExpressionPair resolveMappedCollectionParameter(Parameter parameter) {
        Class<?> collectionType = parameter.getType();
        if (Set.class.isAssignableFrom(collectionType)) {
            ResolvableType resolvableType = ResolvableType.forType((Type)parameter.getParameterizedType()).as(Set.class).getGeneric(new int[]{0});
            Class target = Objects.requireNonNull(resolvableType.resolve());
            RelationalPathBase<?> qClass = this.getRelationalPathBaseFromQueryClass(this.getQueryClass(target));
            return new ParameterAndExpressionPair(collectionType, (Expression<?>)new QSet((Expression<?>[])new Expression[]{qClass}));
        }
        throw new IllegalArgumentException("Unsupported collection type " + collectionType);
    }

    private Map<String, Expression<?>> getEmbeddedConstructorParameterNameToPath(Class<?> type, RelationalPath<?> pathBase, Map<String, Expression<?>> columnNameToColumn, Parameter[] parameters) {
        HashMap embeddedConstructorParameterNameToPath = new HashMap();
        Stream.of(parameters).filter(parameter -> !columnNameToColumn.containsKey(parameter.getName())).forEach(parameter -> this.getEmbeddedType(type, (Parameter)parameter).map(embeddedType -> this.getConstructorExpression((Class<?>)embeddedType, pathBase)).ifPresent(path -> embeddedConstructorParameterNameToPath.put(parameter.getName(), (Expression<?>)path)));
        return embeddedConstructorParameterNameToPath;
    }

    private Optional<Class<?>> getEmbeddedType(Class<?> type, Parameter parameter) {
        return Stream.of(type.getDeclaredFields()).filter(field -> field.getName().equals(parameter.getName())).filter(field -> field.isAnnotationPresent(Embedded.class)).map(Field::getType).findAny();
    }

    private Constructor<?> getConstructor(Class<?> type) {
        PreferredConstructor preferredConstructor = PreferredConstructorDiscoverer.discover(type);
        if (preferredConstructor == null) {
            return null;
        }
        return preferredConstructor.getConstructor();
    }

    public RelationalPathBase<?> getRelationalPathBaseFromQueryRepositoryClass(Class<?> repositoryInterface) {
        Class entityType = ResolvableType.forClass(repositoryInterface).as(this.repositoryTargetType).getGeneric(new int[]{0}).resolve();
        if (entityType == null) {
            throw new IllegalArgumentException("Could not resolve query class for " + repositoryInterface);
        }
        return this.getRelationalPathBaseFromQueryClass(this.getQueryClass(entityType));
    }

    private Class<?> getQueryClass(Class<?> entityType) {
        String fullName = entityType.getPackage().getName() + ".Q" + entityType.getSimpleName();
        try {
            return entityType.getClassLoader().loadClass(fullName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to load class " + fullName);
        }
    }

    private RelationalPathBase<?> getRelationalPathBaseFromQueryClass(Class<?> queryClass) {
        String fieldName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, queryClass.getSimpleName().substring(1));
        Field field = ReflectionUtils.findField(queryClass, (String)fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Did not find a static field of the same type in " + queryClass);
        }
        return (RelationalPathBase)ReflectionUtils.getField((Field)field, null);
    }
}

