/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.spring.data.common;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.querydsl.QSort;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.util.Assert;

public class Querydsl {
    private final SQLQueryFactory sqlQueryFactory;
    private final RelationalPersistentEntity<?> entity;

    public Querydsl(SQLQueryFactory sqlQueryFactory, RelationalPersistentEntity<?> entity) {
        this.sqlQueryFactory = sqlQueryFactory;
        this.entity = entity;
    }

    public SQLQuery<?> createQuery() {
        return this.sqlQueryFactory.query();
    }

    public SQLQuery<?> createQuery(EntityPath<?> ... paths) {
        Assert.notNull(paths, (String)"Paths must not be null!");
        return (SQLQuery)this.createQuery().from(paths);
    }

    public <T> SQLQuery<T> applyPagination(Pageable pageable, SQLQuery<T> query) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
        Assert.notNull(query, (String)"SQLQuery must not be null!");
        if (pageable.isUnpaged()) {
            return query;
        }
        query.offset(pageable.getOffset());
        query.limit((long)pageable.getPageSize());
        return this.applySorting(pageable.getSort(), query);
    }

    public <T> SQLQuery<T> applySorting(Sort sort, SQLQuery<T> query) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        Assert.notNull(query, (String)"Query must not be null!");
        if (sort.isUnsorted()) {
            return query;
        }
        if (sort instanceof QSort) {
            return this.addOrderByFrom((QSort)sort, query);
        }
        return this.addOrderByFrom(sort, query);
    }

    private <T> SQLQuery<T> addOrderByFrom(QSort qsort, SQLQuery<T> query) {
        List orderSpecifiers = qsort.getOrderSpecifiers();
        return (SQLQuery)query.orderBy(orderSpecifiers.toArray(new OrderSpecifier[0]));
    }

    private <T> SQLQuery<T> addOrderByFrom(Sort sort, SQLQuery<T> query) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        Assert.notNull(query, (String)"Query must not be null!");
        for (Sort.Order order : sort) {
            query.orderBy(this.toOrderSpecifier(order));
        }
        return query;
    }

    private OrderSpecifier<?> toOrderSpecifier(Sort.Order order) {
        return new OrderSpecifier(order.isAscending() ? Order.ASC : Order.DESC, this.buildOrderPropertyPathFrom(order), this.toQueryDslNullHandling(order.getNullHandling()));
    }

    private OrderSpecifier.NullHandling toQueryDslNullHandling(Sort.NullHandling nullHandling) {
        Assert.notNull((Object)nullHandling, (String)"NullHandling must not be null!");
        return switch (nullHandling) {
            default -> throw new IncompatibleClassChangeError();
            case Sort.NullHandling.NULLS_FIRST -> OrderSpecifier.NullHandling.NullsFirst;
            case Sort.NullHandling.NULLS_LAST -> OrderSpecifier.NullHandling.NullsLast;
            case Sort.NullHandling.NATIVE -> OrderSpecifier.NullHandling.Default;
        };
    }

    private Expression<?> buildOrderPropertyPathFrom(Sort.Order order) {
        Assert.notNull((Object)order, (String)"Order must not be null!");
        RelationalPersistentProperty persistentProperty = (RelationalPersistentProperty)this.entity.getRequiredPersistentProperty(order.getProperty());
        String columnName = persistentProperty.getColumnName().getReference();
        return Expressions.stringPath((String)columnName);
    }
}

