/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.write.internal;

import com.influxdb.client.domain.WritePrecision;
import java.math.BigInteger;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public final class NanosecondConverter {
    private static final BigInteger NANOS_PER_SECOND = BigInteger.valueOf(1000000000L);
    private static final BigInteger MICRO_PER_NANOS = BigInteger.valueOf(1000L);
    private static final BigInteger MILLIS_PER_NANOS = BigInteger.valueOf(1000000L);
    private static final BigInteger SECONDS_PER_NANOS = BigInteger.valueOf(1000000000L);
    private static final Map<WritePrecision, Function<BigInteger, BigInteger>> TIMESTAMP_CALCULATIONS = new HashMap<WritePrecision, Function<BigInteger, BigInteger>>();

    private NanosecondConverter() {
    }

    public static BigInteger convert(long millis, WritePrecision precision) {
        return TIMESTAMP_CALCULATIONS.get((Object)precision).apply(BigInteger.valueOf(millis).multiply(MILLIS_PER_NANOS));
    }

    public static BigInteger convert(Instant instant, WritePrecision precision) {
        BigInteger nanos = BigInteger.valueOf(instant.getEpochSecond()).multiply(NANOS_PER_SECOND).add(BigInteger.valueOf(instant.getNano()));
        return TIMESTAMP_CALCULATIONS.get((Object)precision).apply(nanos);
    }

    public static BigInteger currentTimestamp(WritePrecision precision) {
        Instant now = Instant.now();
        return NanosecondConverter.convert(now, precision);
    }

    static {
        TIMESTAMP_CALCULATIONS.put(WritePrecision.S, timestamp -> timestamp.divide(SECONDS_PER_NANOS));
        TIMESTAMP_CALCULATIONS.put(WritePrecision.MS, timestamp -> timestamp.divide(MILLIS_PER_NANOS));
        TIMESTAMP_CALCULATIONS.put(WritePrecision.US, timestamp -> timestamp.divide(MICRO_PER_NANOS));
        TIMESTAMP_CALCULATIONS.put(WritePrecision.NS, Function.identity());
    }
}

