/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.write.events;

import com.influxdb.client.write.events.AbstractWriteEvent;
import com.influxdb.exceptions.InfluxException;
import com.influxdb.utils.Arguments;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class WriteErrorEvent
extends AbstractWriteEvent {
    private static final Logger LOG = Logger.getLogger(WriteErrorEvent.class.getName());
    private final Throwable throwable;

    public WriteErrorEvent(@Nonnull Throwable throwable) {
        Arguments.checkNotNull((Object)throwable, (String)"Throwable");
        this.throwable = throwable;
    }

    @Nonnull
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public void logEvent() {
        Throwable throwable = this.throwable;
        if (throwable instanceof InfluxException) {
            InfluxException ie = (InfluxException)throwable;
            String selectHeaders = Stream.of("trace-id", "trace-sampled", "X-Influxdb-Build", "X-Influxdb-Request-ID", "X-Influxdb-Version").filter(name -> ie.headers().get(name) != null).reduce("", (message, name) -> message.concat(String.format("%s: %s\n", name, ie.headers().get(name))));
            LOG.log(Level.SEVERE, String.format("An error occurred during writing of data.  Select Response Headers:\n%s", selectHeaders), this.throwable);
        } else {
            LOG.log(Level.SEVERE, "An error occurred during writing of data", this.throwable);
        }
    }
}

