/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.EquinoxClassLoader;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.storage.BundleInfo;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;

public class SystemBundleLoader
extends BundleLoader {
    public static final String EQUINOX_EE = "x-equinox-ee";
    final ClassLoader classLoader;
    final ModuleClassLoader moduleClassLoader;

    public SystemBundleLoader(ModuleWiring wiring, EquinoxContainer container, ClassLoader frameworkLoader) {
        super(wiring, container, frameworkLoader.getParent());
        this.classLoader = frameworkLoader;
        this.moduleClassLoader = new SystemModuleClassLoader(this.classLoader.getParent(), container.getConfiguration(), this, (BundleInfo.Generation)wiring.getRevision().getRevisionInfo());
    }

    @Override
    public Class<?> findClass(String name2) throws ClassNotFoundException {
        Class<?> result = this.findLocalClass(name2);
        if (result == null) {
            throw new ClassNotFoundException(name2);
        }
        return result;
    }

    @Override
    public Class<?> findLocalClass(String name2) {
        try {
            return this.classLoader.loadClass(name2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public URL findLocalResource(String name2) {
        return this.classLoader.getResource(name2);
    }

    @Override
    public Enumeration<URL> findLocalResources(String name2) {
        try {
            return this.classLoader.getResources(name2);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public URL findResource(String name2) {
        return this.findLocalResource(name2);
    }

    @Override
    public Enumeration<URL> findResources(String name2) throws IOException {
        return this.findLocalResources(name2);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public ModuleClassLoader getModuleClassLoader() {
        return this.moduleClassLoader;
    }

    @Override
    void loadClassLoaderFragments(Collection<ModuleRevision> fragments) {
        this.moduleClassLoader.loadFragments(fragments);
    }

    class SystemModuleClassLoader
    extends EquinoxClassLoader {
        public SystemModuleClassLoader(ClassLoader parent, EquinoxConfiguration configuration, BundleLoader delegate, BundleInfo.Generation generation) {
            super(parent, configuration, delegate, generation);
        }

        @Override
        protected Class<?> loadClass(String name2, boolean resolve) throws ClassNotFoundException {
            return SystemBundleLoader.this.findClass(name2);
        }

        @Override
        public void loadFragments(Collection<ModuleRevision> fragments) {
            Module systemModule = SystemBundleLoader.this.getWiring().getRevision().getRevisions().getModule();
            try {
                this.getGeneration().getBundleInfo().getStorage().getExtensionInstaller().addExtensionContent(fragments, systemModule);
            }
            catch (BundleException e) {
                systemModule.getContainer().getAdaptor().publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.ERROR, systemModule, e, new FrameworkListener[0]);
            }
            this.getClasspathManager().loadFragments(fragments);
        }
    }
}

