/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader;

import java.security.AccessController;
import java.util.Map;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.framework.util.KeyedHashSet;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.sources.FilteredSourcePackage;
import org.eclipse.osgi.internal.loader.sources.PackageSource;
import org.eclipse.osgi.internal.loader.sources.SingleSourcePackage;

public class BundleLoaderSources {
    static SecureAction secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    private final KeyedHashSet pkgSources = new KeyedHashSet(false);
    private final BundleLoader loader;

    public BundleLoaderSources(BundleLoader loader) {
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackageSource getPackageSource(String pkgName) {
        KeyedHashSet keyedHashSet = this.pkgSources;
        synchronized (keyedHashSet) {
            PackageSource pkgSource = (PackageSource)this.pkgSources.getByKey(pkgName);
            if (pkgSource == null) {
                pkgSource = new SingleSourcePackage(pkgName, this.loader);
                this.pkgSources.add(pkgSource);
            }
            return pkgSource;
        }
    }

    boolean forceSourceCreation(ModuleCapability packageCapability) {
        Map<String, String> directives = packageCapability.getDirectives();
        return directives.get("exclude") != null || directives.get("exclude") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageSource createPackageSource(ModuleCapability packageCapability, boolean storeSource) {
        PackageSource pkgSource = null;
        String name2 = (String)packageCapability.getAttributes().get("osgi.wiring.package");
        String includes = packageCapability.getDirectives().get("include");
        String excludes = packageCapability.getDirectives().get("exclude");
        if (includes != null || excludes != null) {
            pkgSource = new FilteredSourcePackage(name2, this.loader, includes, excludes);
        }
        if (storeSource) {
            if (pkgSource != null) {
                KeyedHashSet keyedHashSet = this.pkgSources;
                synchronized (keyedHashSet) {
                    if (this.pkgSources.getByKey(name2) == null) {
                        this.pkgSources.add(pkgSource);
                    }
                }
            }
        } else if (pkgSource == null && (pkgSource = this.getPackageSource(name2)).getClass() != SingleSourcePackage.class) {
            return new SingleSourcePackage(name2, this.loader);
        }
        return pkgSource;
    }
}

