/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciilist.commons;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.NotImplementedException;

public enum RomanNumberLiterals {
    I(1, "I", "i", "\u2160", "\u2170", "\u24be", "\u24d8"),
    II(2, "II", "ii", "\u2161", "\u2171", "\u24be\u24be", "\u24d8\u24d8"),
    III(3, "III", "iii", "\u2162", "\u2172", "\u24be\u24be\u24be", "\u24d8\u24d8\u24d8"),
    IV(4, "IV", "iv", "\u2163", "\u2173", "\u24be\u24cb", "\u24d8\u24e5"),
    V(5, "V", "v", "\u2164", "\u2174", "\u24cb", "\u24e5"),
    VI(6, "VI", "vi", "\u2165", "\u2175", "\u24cb\u24be", "\u24e5\u24d8"),
    VII(7, "VII", "vii", "\u2166", "\u2176", "\u24cb\u24be\u24be", "\u24e5\u24d8\u24d8"),
    VIII(8, "VIII", "viii", "\u2167", "\u2177", "\u24cb\u24be\u24be\u24be", "\u24e5\u24d8\u24d8\u24d8"),
    IX(9, "IX", "ix", "\u2168", "\u2178", "\u24be\u24cd", "\u24d8\u24e7"),
    X(10, "X", "x", "\u2169", "\u2179", "\u24cd", "\u24e7"),
    XI(11, "XI", "xi", "\u216a", "\u217a", "\u24cd\u24be", "\u24e7\u24d8"),
    XII(12, "XII", "xii", "\u216b", "\u217b", "\u24cd\u24be\u24be", "\u24e7\u24d8\u24d8"),
    L(50, "L", "l", "\u216c", "\u217c", "\u24c1", "\u24db"),
    C(100, "C", "c", "\u216d", "\u217d", "\u24b8", "\u24d2"),
    D(500, "D", "d", "\u216e", "\u217e", "\u24b9", "\u24d3"),
    M(1000, "M", "m", "\u216f", "\u217f", "\u24c2", "\u24dc");

    int number;
    String ascii7;
    String ascii7_LC;
    String numberForms;
    String numberForms_LC;
    String circledLatinCapital;
    String circledLatinSmall;
    public static final int[] NUMBERS;
    public static final String[] LETTERS;

    private RomanNumberLiterals(int number, String ascii7, String ascii7_LC, String numberForms, String numberForms_LC, String circledLatinCapital, String circledLatinSmall) {
        this.number = number;
        this.ascii7 = ascii7;
        this.ascii7_LC = ascii7_LC;
        this.numberForms = numberForms;
        this.numberForms_LC = numberForms_LC;
        this.circledLatinCapital = circledLatinCapital;
        this.circledLatinSmall = circledLatinSmall;
    }

    public static final String INTEGER_2_ROMAN(int number) {
        if (number < 1 || number > 3999) {
            throw new NotImplementedException("Roman literals supported 0<number<4000 - number was: " + number);
        }
        String ret = "";
        for (int i = 0; i < NUMBERS.length; ++i) {
            while (number >= NUMBERS[i]) {
                ret = ret + LETTERS[i];
                number -= NUMBERS[i];
            }
        }
        return ret;
    }

    public static final RomanNumberLiterals[] ROMAN_2_ENUM(String roman) {
        RomanNumberLiterals[] ret = new RomanNumberLiterals[]{};
        try {
            RomanNumberLiterals rnl = RomanNumberLiterals.valueOf(roman);
            if (rnl != null) {
                return ArrayUtils.add(ret, rnl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        char[] cArray = roman.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            RomanNumberLiterals rnl = RomanNumberLiterals.valueOf(c.toString());
            ret = ArrayUtils.add(ret, rnl);
        }
        return ret;
    }

    public static final String toAscii(int number) {
        return RomanNumberLiterals.INTEGER_2_ROMAN(number);
    }

    public static final String toAsciiLC(int number) {
        return RomanNumberLiterals.INTEGER_2_ROMAN(number).toLowerCase();
    }

    public static final String toNumberForms(int number) {
        RomanNumberLiterals[] ar = RomanNumberLiterals.ROMAN_2_ENUM(RomanNumberLiterals.INTEGER_2_ROMAN(number));
        String ret = "";
        for (RomanNumberLiterals enumerate : ar) {
            ret = ret + enumerate.numberForms;
        }
        return ret;
    }

    public static final String toNumberFormsLC(int number) {
        RomanNumberLiterals[] ar = RomanNumberLiterals.ROMAN_2_ENUM(RomanNumberLiterals.INTEGER_2_ROMAN(number));
        String ret = "";
        for (RomanNumberLiterals enumerate : ar) {
            ret = ret + enumerate.numberForms_LC;
        }
        return ret;
    }

    public static final String toCircledLatinCaptial(int number) {
        RomanNumberLiterals[] ar = RomanNumberLiterals.ROMAN_2_ENUM(RomanNumberLiterals.INTEGER_2_ROMAN(number));
        String ret = "";
        for (RomanNumberLiterals enumerate : ar) {
            ret = ret + enumerate.circledLatinCapital;
        }
        return ret;
    }

    public static final String toCircledLatinSmall(int number) {
        RomanNumberLiterals[] ar = RomanNumberLiterals.ROMAN_2_ENUM(RomanNumberLiterals.INTEGER_2_ROMAN(number));
        String ret = "";
        for (RomanNumberLiterals enumerate : ar) {
            ret = ret + enumerate.circledLatinSmall;
        }
        return ret;
    }

    static {
        NUMBERS = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        LETTERS = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    }
}

