/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer.text;

import com.ibm.ws.report.Messages;
import com.ibm.ws.report.inventory.AppPackage;
import com.ibm.ws.report.inventory.Archive;
import com.ibm.ws.report.inventory.ArchiveInventory;
import com.ibm.ws.report.inventory.UtilityJar;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.writer.ReportWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class TextInventoryReportWriter
implements ReportWriter {
    private static String newLine = System.getProperty("line.separator");
    private static final String tab = "\t";
    protected static SimpleDateFormat localDateFormat = new SimpleDateFormat();
    protected static Archive.Fields[] allFields = Archive.Fields.values();
    private boolean hasSharedLibraries = false;
    private final ArchiveInventory inv;
    private final List<String> projects;
    private final List<String> sharedLibProjectNames;
    private String result;

    public TextInventoryReportWriter(ArchiveInventory inv, List<String> arrayOfProjects, List<String> sharedLibProjectNames) {
        this.inv = inv;
        this.projects = arrayOfProjects;
        this.sharedLibProjectNames = sharedLibProjectNames;
        this.hasSharedLibraries = sharedLibProjectNames.size() != 0;
        Collections.sort(this.projects);
    }

    private void buildHeader(StringBuilder resultBuffer) {
        resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        resultBuffer.append(Messages.getString("INVENTORY_REPORT_MAIN_TITLE"));
        resultBuffer.append(newLine);
    }

    private void buildGeneratedOnAndFor(StringBuilder resultBuffer) {
        resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        resultBuffer.append(localDateFormat.format(new Date()));
        resultBuffer.append(newLine);
        if (this.projects != null) {
            for (String item : this.projects) {
                resultBuffer.append(item);
                resultBuffer.append(newLine);
            }
        }
        if (this.hasSharedLibraries) {
            resultBuffer.append(Messages.getString("INVENTORY_REPORT_SHARED_LIBRARIES_COLON"));
            resultBuffer.append(newLine);
            for (String item : this.sharedLibProjectNames) {
                resultBuffer.append(item);
                resultBuffer.append(newLine);
            }
        }
    }

    private void buildDashboard(StringBuilder resultBuffer) {
        resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        this.buildArchiveCountSummary(resultBuffer, "", true, null);
    }

    private void buildArchiveCountSummary(StringBuilder resultBuffer, String tabs, boolean topLevelSummary, Archive arch) {
        ArchiveInventory.ArchiveTypes[] ats = null;
        ats = topLevelSummary ? ArchiveInventory.ArchiveTypes.values() : ArchiveInventory.ArchiveTypes.getAllowedArchiveTypes(arch.getArchiveType());
        ArchiveInventory.ArchiveTypes[] archiveTypesArray = ats;
        int n = ats.length;
        int n2 = 0;
        while (n2 < n) {
            ArchiveInventory.ArchiveTypes at = archiveTypesArray[n2];
            resultBuffer.append(tabs);
            resultBuffer.append(at.toString());
            resultBuffer.append(": ");
            if (topLevelSummary) {
                resultBuffer.append(this.inv.getArchiveCount(at));
            } else {
                resultBuffer.append(arch.getArchiveCount(at));
            }
            resultBuffer.append(newLine);
            ++n2;
        }
        if (ats.length > 0 && !topLevelSummary) {
            resultBuffer.append(tabs);
            resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        }
    }

    private void buildSummary(StringBuilder resultBuffer) {
        resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        resultBuffer.append(Messages.getString("ANALYSIS_REPORT_SUMMARY"));
        resultBuffer.append(newLine);
        resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        this.buildFieldInfo(resultBuffer, "", true, null);
    }

    private void buildFieldInfo(StringBuilder resultBuffer, String tabs, boolean topLevelSummary, Archive arch) {
        String tabsPlusOne = String.valueOf(tabs) + tab;
        int webServices = topLevelSummary ? this.inv.getSummaryFieldTotal(Archive.Fields.getWebServiceFields()) : arch.getFieldTotal(Archive.Fields.getWebServiceFields());
        int ejbBeans = topLevelSummary ? this.inv.getSummaryFieldTotal(Archive.Fields.getEjbBeanFields()) : arch.getFieldTotal(Archive.Fields.getEjbBeanFields());
        boolean allWsZero = webServices == 0;
        boolean allBreakdownsZero = allWsZero && ejbBeans == 0;
        boolean foundEJBBean = false;
        boolean foundWS = false;
        Archive.Fields[] fieldsArray = allFields;
        int n = allFields.length;
        int n2 = 0;
        while (n2 < n) {
            Archive.Fields field = fieldsArray[n2];
            if (field.isEJBBean()) {
                if (!foundEJBBean) {
                    if (ejbBeans == 0) {
                        resultBuffer.append(tabs);
                        resultBuffer.append(Messages.getString("INVENTORY_REPORT_EJB_BEAN"));
                        resultBuffer.append(": 0");
                    } else {
                        resultBuffer.append(newLine);
                        resultBuffer.append(tabs);
                        resultBuffer.append(Messages.getString("INVENTORY_REPORT_EJB_BEAN"));
                    }
                    resultBuffer.append(newLine);
                    foundEJBBean = true;
                }
                if (ejbBeans > 0) {
                    resultBuffer.append(tabsPlusOne);
                    resultBuffer.append(field.toString());
                    resultBuffer.append(": ");
                    if (topLevelSummary) {
                        resultBuffer.append(this.inv.getSummaryFieldValue(field));
                    } else {
                        resultBuffer.append(arch.getFieldTotal(field));
                    }
                    resultBuffer.append(newLine);
                }
            } else if (field.isWebService()) {
                if (!foundWS) {
                    if (allBreakdownsZero) {
                        resultBuffer.append(tabs);
                        resultBuffer.append(Messages.getString("INVENTORY_REPORT_WEB_SERVICES"));
                        resultBuffer.append(": 0");
                    } else if (allWsZero) {
                        resultBuffer.append(newLine);
                        resultBuffer.append(tabs);
                        resultBuffer.append(Messages.getString("INVENTORY_REPORT_WEB_SERVICES"));
                        resultBuffer.append(": 0");
                    } else {
                        resultBuffer.append(newLine);
                        resultBuffer.append(tabs);
                        resultBuffer.append(Messages.getString("INVENTORY_REPORT_WEB_SERVICES"));
                    }
                    resultBuffer.append(newLine);
                    foundWS = true;
                }
                if (!allWsZero) {
                    resultBuffer.append(tabsPlusOne);
                    resultBuffer.append(field.toString());
                    resultBuffer.append(": ");
                    if (topLevelSummary) {
                        resultBuffer.append(this.inv.getSummaryFieldValue(field));
                    } else {
                        resultBuffer.append(arch.getFieldTotal(field));
                    }
                    resultBuffer.append(newLine);
                }
            } else {
                resultBuffer.append(tabs);
                resultBuffer.append(field.toString());
                resultBuffer.append(": ");
                if (topLevelSummary) {
                    resultBuffer.append(this.inv.getSummaryFieldValue(field));
                } else {
                    resultBuffer.append(arch.getFieldTotal(field));
                }
                resultBuffer.append(newLine);
            }
            ++n2;
        }
        resultBuffer.append(newLine);
    }

    private void buildInventoryDetails(StringBuilder resultBuffer) {
        resultBuffer.append(Messages.getString("INVENTORY_REPORT_SEPARATOR"));
        resultBuffer.append(Messages.getString("INVENTORY_REPORT_INV_DETAILS_BY_APP"));
        resultBuffer.append(newLine);
        resultBuffer.append(Messages.getString("INVENTORY_REPORT_SEPARATOR"));
        int size = this.projects.size();
        int i = 1;
        for (String name2 : this.projects) {
            Archive appArchive = this.inv.get(name2);
            resultBuffer.append(Messages.getFormattedMessage(Messages.getString("INVENTORY_REPORT_APP"), name2));
            resultBuffer.append(newLine);
            resultBuffer.append(Messages.getFormattedMessage(Messages.getString("INVENTORY_REPORT_ARCHIVE_TYPE"), appArchive.getArchiveType().getType()));
            resultBuffer.append(newLine);
            String version = appArchive.getVersion();
            if (version == null) {
                version = Messages.getString("INVENTORY_REPORT_UNSPECIFIED_ATTRIBUTE");
            }
            resultBuffer.append(Messages.getFormattedMessage(Messages.getString("INVENTORY_REPORT_ARCHIVE_VERSION"), version));
            resultBuffer.append(newLine);
            String metadataComplete = appArchive.getMetadataComplete();
            if (metadataComplete == null) {
                metadataComplete = Messages.getString("INVENTORY_REPORT_UNSPECIFIED_ATTRIBUTE");
            }
            resultBuffer.append(Messages.getFormattedMessage(Messages.getString("INVENTORY_REPORT_METADATA_COMPLETE"), metadataComplete));
            resultBuffer.append(newLine);
            resultBuffer.append(Messages.getString("INVENTORY_REPORT_SEPARATOR"));
            this.buildArchiveCountSummary(resultBuffer, "", false, appArchive);
            this.buildFieldInfo(resultBuffer, "", false, appArchive);
            if (appArchive.hasIssues()) {
                resultBuffer.append(tab);
                resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
                resultBuffer.append(tab);
                resultBuffer.append(Messages.getString("INVENTORY_REPORT_PROBLEM_SECTION"));
                resultBuffer.append(newLine);
                resultBuffer.append(tab);
                resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
                resultBuffer.append(tab);
                resultBuffer.append(Messages.getString("INVENTORY_REPORT_DUP_PROBLEM_SUMMARY"));
                resultBuffer.append(": ");
                resultBuffer.append(appArchive.getArchiveCount(AppPackage.Issue.DUPLICATE_CLASS));
                resultBuffer.append(newLine);
                resultBuffer.append(tab);
                resultBuffer.append(Messages.getString("INVENTORY_REPORT_JAVAEE_SE_PROBLEM_SUMMARY"));
                resultBuffer.append(": ");
                resultBuffer.append(appArchive.getArchiveCount(AppPackage.Issue.JAVA_EE_SE_CLASS));
                resultBuffer.append(newLine);
                resultBuffer.append(tab);
                resultBuffer.append(Messages.getString("INVENTORY_REPORT_THIRD_PARTY_PROBLEM_SUMMARY"));
                resultBuffer.append(": ");
                resultBuffer.append(appArchive.getArchiveCount(AppPackage.Issue.OSS_CLASS));
                resultBuffer.append(newLine);
                resultBuffer.append(tab);
                resultBuffer.append(Messages.getString("INVENTORY_REPORT_WEBSPHERE_CLASSES_PROBLEM_SUMMARY"));
                resultBuffer.append(": ");
                resultBuffer.append(appArchive.getArchiveCount(AppPackage.Issue.WAS_CLASS));
                resultBuffer.append(newLine);
                resultBuffer.append(tab);
                resultBuffer.append(Messages.getString("INVENTORY_REPORT_UNUSED_ARCHIVES_PROBLEM_SUMMARY"));
                resultBuffer.append(": ");
                resultBuffer.append(appArchive.getArchiveCount(AppPackage.Issue.UNUSED_ARCHIVES));
                resultBuffer.append(newLine);
                resultBuffer.append(tab);
                resultBuffer.append(Messages.getString("INVENTORY_REPORT_MISSING_DEPENDENCIES_PROBLEM_SUMMARY"));
                resultBuffer.append(": ");
                resultBuffer.append(appArchive.getArchiveCount(AppPackage.Issue.MISSING_DEP));
                resultBuffer.append(newLine);
                if (this.hasSharedLibraries) {
                    resultBuffer.append(tab);
                    resultBuffer.append(Messages.getString("INVENTORY_REPORT_SHARED_LIBRARY_DEPENDENCIES_PROBLEM_SUMMARY"));
                    resultBuffer.append(": ");
                    resultBuffer.append(appArchive.getArchiveCount(AppPackage.Issue.SHARED_LIB_DEPENDENCIES));
                    resultBuffer.append(newLine);
                }
                resultBuffer.append(newLine);
                this.buildAppProblemBreakdown(resultBuffer, appArchive, 1);
            }
            Set<String> metadataSuggestions = appArchive.getMetadataSuggestions(false);
            TreeMap<String, String> excessiveArchiveList = appArchive.getArchivesWithExcessFiles(Archive.ExcessFileType.EXCESS_CLASS);
            TreeMap<String, String> excessiveWebModuleResourcesArchiveList = appArchive.getArchivesWithExcessFiles(Archive.ExcessFileType.EXCESS_WEB_MODULE_RESOURCE);
            if (!(metadataSuggestions.isEmpty() && excessiveArchiveList.isEmpty() && excessiveWebModuleResourcesArchiveList.isEmpty())) {
                boolean isWAR;
                ArrayList<String> metadataSuggestionsSorted = new ArrayList<String>(metadataSuggestions);
                List<String> excessiveArchiveListSorted = this.convertMapToList(excessiveArchiveList);
                List<String> excessiveWebModuleResourcesArchiveListSorted = this.convertMapToList(excessiveWebModuleResourcesArchiveList);
                Collections.sort(metadataSuggestionsSorted);
                Collections.sort(excessiveArchiveListSorted);
                Collections.sort(excessiveWebModuleResourcesArchiveListSorted);
                resultBuffer.append(tab);
                resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
                resultBuffer.append(tab);
                resultBuffer.append(Messages.getString("INVENTORY_REPORT_PERFORMANCE_CONSIDERATIONS_SECTION"));
                resultBuffer.append(newLine);
                resultBuffer.append(tab);
                resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
                if (!metadataSuggestionsSorted.isEmpty()) {
                    this.addPerformanceConsiderationsEntry(resultBuffer, metadataSuggestionsSorted, Messages.getString("INVENTORY_REPORT_PERFORMANCE_CONSIDERATIONS_METADATA_SUGGESTIONS_TITLE"), Messages.getString("INVENTORY_REPORT_PERFORMANCE_CONSIDERATIONS_METADATA_SUGESSTIONS_DESC_TXT"));
                }
                boolean bl = isWAR = appArchive.getArchiveType() == ArchiveInventory.ArchiveTypes.WAR;
                if (!excessiveArchiveListSorted.isEmpty()) {
                    this.buildExcessFileSection(resultBuffer, Archive.ExcessFileType.EXCESS_CLASS, isWAR, excessiveArchiveList, excessiveArchiveListSorted);
                }
                if (!excessiveWebModuleResourcesArchiveListSorted.isEmpty()) {
                    this.buildExcessFileSection(resultBuffer, Archive.ExcessFileType.EXCESS_WEB_MODULE_RESOURCE, isWAR, excessiveWebModuleResourcesArchiveList, excessiveWebModuleResourcesArchiveListSorted);
                }
            }
            if (appArchive.getTotalNumberOfArchives() > 0) {
                resultBuffer.append(tab);
                resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
                resultBuffer.append(tab);
                resultBuffer.append(Messages.getString("INVENTORY_REPORT_INV_DETAILS_BY_ARCHIVE"));
                resultBuffer.append(newLine);
                this.buildNestedArchiveInventoryDetails(resultBuffer, appArchive, 1);
            }
            if (i < size) {
                resultBuffer.append(Messages.getString("INVENTORY_REPORT_SEPARATOR"));
            }
            ++i;
        }
        resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        resultBuffer.append(Messages.getString("INVENTORY_REPORT_END_OF_REPORT"));
        resultBuffer.append(newLine);
        resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
    }

    public void buildExcessFileSection(StringBuilder resultBuffer, Archive.ExcessFileType type, boolean isWAR, TreeMap<String, String> excessiveArchiveList, List<String> excessiveArchiveListSorted) {
        if (isWAR) {
            this.addPerformanceConsiderationsDescriptionOnly(resultBuffer, type.getArchiveList(), MessageFormat.format(type.getTxtWARDesc(), excessiveArchiveList.firstEntry().getValue()));
        } else {
            this.addPerformanceConsiderationsEntry(resultBuffer, excessiveArchiveListSorted, type.getArchiveList(), type.getTxtDesc());
        }
    }

    private List<String> convertMapToList(TreeMap<String, String> excessiveArchiveList) {
        ArrayList<String> listOfEntries = new ArrayList<String>();
        HashSet<String> keySet = new HashSet<String>(excessiveArchiveList.keySet());
        for (String key : keySet) {
            listOfEntries.add(String.valueOf(key) + ": " + excessiveArchiveList.get(key));
        }
        return listOfEntries;
    }

    private void addPerformanceConsiderationsEntry(StringBuilder resultBuffer, List<String> sortedList, String title, String description) {
        resultBuffer.append(tab);
        resultBuffer.append(tab);
        resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        resultBuffer.append(tab);
        resultBuffer.append(tab);
        resultBuffer.append(title);
        resultBuffer.append(newLine);
        resultBuffer.append(tab);
        resultBuffer.append(tab);
        resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        resultBuffer.append(tab);
        resultBuffer.append(tab);
        resultBuffer.append(description);
        resultBuffer.append(newLine);
        resultBuffer.append(tab);
        resultBuffer.append(tab);
        resultBuffer.append(tab);
        resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        for (String archive : sortedList) {
            resultBuffer.append(tab);
            resultBuffer.append(tab);
            resultBuffer.append(tab);
            resultBuffer.append(archive);
            resultBuffer.append(newLine);
        }
        resultBuffer.append(newLine);
    }

    private void addPerformanceConsiderationsDescriptionOnly(StringBuilder resultBuffer, String title, String description) {
        resultBuffer.append(tab);
        resultBuffer.append(tab);
        resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        resultBuffer.append(tab);
        resultBuffer.append(tab);
        resultBuffer.append(title);
        resultBuffer.append(newLine);
        resultBuffer.append(tab);
        resultBuffer.append(tab);
        resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        resultBuffer.append(tab);
        resultBuffer.append(tab);
        resultBuffer.append(description);
        resultBuffer.append(newLine);
    }

    private void buildAppProblemBreakdown(StringBuilder sb, Archive arc, int nthApp) {
        LinkedHashMap<String, String> locationMapAcross = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> locationMapWithin = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> locationMapJavaEE = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> locationMapWS = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> locationMapOS = new LinkedHashMap<String, String>();
        HashMap<String, String> serversMapOS = new HashMap<String, String>();
        LinkedHashMap<String, String> locationMapMissingDeps = new LinkedHashMap<String, String>();
        List<AppPackage> listOfAppPackages = arc.getPackages();
        if (listOfAppPackages != null) {
            for (AppPackage pack : listOfAppPackages) {
                List<String> listOfLocations;
                List<AppPackage.Issue> issueList = pack.getIssues();
                if (issueList.contains((Object)AppPackage.Issue.DUPLICATE_CLASS)) {
                    listOfLocations = pack.getLocations(AppPackage.Issue.DUPLICATE_CLASS);
                    this.addLocation(listOfLocations, pack, locationMapAcross, locationMapWithin);
                }
                if (issueList.contains((Object)AppPackage.Issue.JAVA_EE_SE_CLASS)) {
                    listOfLocations = pack.getLocations(AppPackage.Issue.JAVA_EE_SE_CLASS);
                    this.addLocation(pack, locationMapJavaEE, null, listOfLocations);
                }
                if (issueList.contains((Object)AppPackage.Issue.WAS_CLASS)) {
                    listOfLocations = pack.getLocations(AppPackage.Issue.WAS_CLASS);
                    this.addLocation(pack, locationMapWS, null, listOfLocations);
                }
                if (issueList.contains((Object)AppPackage.Issue.OSS_CLASS)) {
                    listOfLocations = pack.getLocations(AppPackage.Issue.OSS_CLASS);
                    this.addLocation(pack, locationMapOS, serversMapOS, listOfLocations);
                }
                if (!issueList.contains((Object)AppPackage.Issue.MISSING_DEP)) continue;
                listOfLocations = pack.getLocations(AppPackage.Issue.MISSING_DEP);
                this.addLocation(pack, locationMapMissingDeps, null, listOfLocations);
            }
        }
        SortedMap<String, String> locationMapUnusedJars = arc.getUnusedArchives();
        SortedMap<String, String> checksumMapUnusedJars = arc.getUnusedArchiveChecksums();
        SortedMap<String, String> locationMapSharedLibDependencies = arc.getSharedLibDependencies();
        this.buildAppProblemSection(AppPackage.Issue.DUPLICATE_CLASS_WITHIN, locationMapWithin, null, sb);
        this.buildAppProblemSection(AppPackage.Issue.DUPLICATE_CLASS_ACROSS, locationMapAcross, null, sb);
        this.buildAppProblemSection(AppPackage.Issue.JAVA_EE_SE_CLASS, locationMapJavaEE, null, sb);
        this.buildAppProblemSection(AppPackage.Issue.WAS_CLASS, locationMapWS, null, sb);
        this.buildAppProblemSection(AppPackage.Issue.OSS_CLASS, locationMapOS, serversMapOS, sb);
        this.buildAppProblemSection(AppPackage.Issue.UNUSED_ARCHIVES, new LinkedHashMap<String, String>(locationMapUnusedJars), null, new LinkedHashMap<String, String>(checksumMapUnusedJars), sb);
        this.buildAppProblemSection(AppPackage.Issue.MISSING_DEP, locationMapMissingDeps, null, sb);
        this.buildAppProblemSection(AppPackage.Issue.SHARED_LIB_DEPENDENCIES, new LinkedHashMap<String, String>(locationMapSharedLibDependencies), null, sb);
    }

    private void buildAppProblemSection(AppPackage.Issue issue, LinkedHashMap<String, String> locationMap, Map<String, String> serverMap, StringBuilder sb) {
        this.buildAppProblemSection(issue, locationMap, serverMap, null, sb);
    }

    private void buildAppProblemSection(AppPackage.Issue issue, LinkedHashMap<String, String> locationMap, Map<String, String> serverMap, Map<String, List<String>> unusedArchiveChecksumMap, StringBuilder sb) {
        String tabsPlusOne = "\t\t";
        String tabsPlusTwo = String.valueOf(tabsPlusOne) + tab;
        String tabsPlusThree = String.valueOf(tabsPlusTwo) + tab;
        if (!locationMap.isEmpty()) {
            StringBuilder dupWithinSB = new StringBuilder();
            dupWithinSB.append(tabsPlusOne);
            dupWithinSB.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
            dupWithinSB.append(tabsPlusOne);
            dupWithinSB.append(issue.getTitle());
            dupWithinSB.append(newLine);
            dupWithinSB.append(tabsPlusOne);
            dupWithinSB.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
            dupWithinSB.append(tabsPlusOne);
            dupWithinSB.append(issue.getTextDescription());
            dupWithinSB.append(newLine);
            dupWithinSB.append(newLine);
            dupWithinSB.append(tabsPlusOne);
            dupWithinSB.append(Messages.getString("INVENTORY_REPORT_REC_LABEL"));
            dupWithinSB.append(" ");
            dupWithinSB.append(issue.getTextRecommendation());
            dupWithinSB.append(newLine);
            dupWithinSB.append(newLine);
            for (String path : locationMap.keySet()) {
                dupWithinSB.append(tabsPlusTwo);
                dupWithinSB.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
                dupWithinSB.append(tabsPlusTwo);
                if (AppPackage.Issue.UNUSED_ARCHIVES == issue) {
                    dupWithinSB.append(Messages.getString("INVENTORY_REPORT_DEP_ARCHIVE"));
                } else if (AppPackage.Issue.MISSING_DEP == issue) {
                    dupWithinSB.append(Messages.getString("INVENTORY_REPORT_MISSING_DEP"));
                } else if (AppPackage.Issue.SHARED_LIB_DEPENDENCIES == issue) {
                    dupWithinSB.append(Messages.getString("INVENTORY_REPORT_SHARED_LIB_CLASS"));
                } else {
                    dupWithinSB.append(Messages.getString("INVENTORY_REPORT_CONFLICTING_PACKAGES"));
                }
                dupWithinSB.append(":");
                dupWithinSB.append(newLine);
                dupWithinSB.append(tabsPlusThree);
                if (AppPackage.Issue.UNUSED_ARCHIVES == issue) {
                    dupWithinSB.append(path);
                } else if (AppPackage.Issue.SHARED_LIB_DEPENDENCIES == issue) {
                    dupWithinSB.append(ReportUtility.getQualifiedClassName(path));
                    dupWithinSB.append(newLine);
                } else {
                    dupWithinSB.append(locationMap.get(path));
                    dupWithinSB.append(newLine);
                }
                dupWithinSB.append(tabsPlusTwo);
                String archiveReferencedBy = locationMap.get(path);
                if (AppPackage.Issue.UNUSED_ARCHIVES == issue) {
                    if (!archiveReferencedBy.isEmpty()) {
                        dupWithinSB.append(newLine);
                        dupWithinSB.append(tabsPlusTwo);
                        dupWithinSB.append(Messages.getString("INVENTORY_REPORT_REFERENCED_BY"));
                        dupWithinSB.append(":");
                        dupWithinSB.append(newLine);
                        dupWithinSB.append(tabsPlusThree);
                        dupWithinSB.append(archiveReferencedBy);
                    }
                } else {
                    if (AppPackage.Issue.MISSING_DEP == issue) {
                        dupWithinSB.append(Messages.getString("INVENTORY_REPORT_DEP_ARCHIVE"));
                    } else if (AppPackage.Issue.SHARED_LIB_DEPENDENCIES == issue) {
                        dupWithinSB.append(Messages.getString("INVENTORY_REPORT_REFERENCED_CLASS"));
                    } else {
                        dupWithinSB.append(Messages.getString("INVENTORY_REPORT_PACKAGE_LOCATION"));
                    }
                    dupWithinSB.append(":");
                    dupWithinSB.append(newLine);
                    dupWithinSB.append(tabsPlusThree);
                    if (AppPackage.Issue.SHARED_LIB_DEPENDENCIES == issue) {
                        List<String> appRefs = Arrays.asList(locationMap.get(path).split("<br>"));
                        int i = 0;
                        while (i < appRefs.size()) {
                            dupWithinSB.append(locationMap.get(path));
                            if (i + 1 != appRefs.size()) {
                                dupWithinSB.append(newLine);
                                dupWithinSB.append(tabsPlusThree);
                            }
                            ++i;
                        }
                    } else {
                        dupWithinSB.append(path);
                    }
                }
                dupWithinSB.append(tabsPlusThree);
                if (AppPackage.Issue.UNUSED_ARCHIVES == issue) {
                    dupWithinSB.append(newLine);
                    dupWithinSB.append(tabsPlusTwo);
                    dupWithinSB.append(Messages.getString("INVENTORY_REPORT_ARCHIVE_CHECKSUM_LABEL"));
                    dupWithinSB.append(":");
                    dupWithinSB.append(newLine);
                    dupWithinSB.append(tabsPlusThree);
                    dupWithinSB.append(unusedArchiveChecksumMap.get(path));
                } else if (AppPackage.Issue.OSS_CLASS == issue || AppPackage.Issue.SHARED_LIB_DEPENDENCIES == issue) {
                    dupWithinSB.append(newLine);
                    dupWithinSB.append(tabsPlusTwo);
                    if (AppPackage.Issue.OSS_CLASS == issue) {
                        dupWithinSB.append(Messages.getString("INVENTORY_REPORT_APPLIES_TO"));
                    } else {
                        dupWithinSB.append(Messages.getString("INVENTORY_REPORT_SHARED_LIBRARY_LOCATION"));
                    }
                    dupWithinSB.append(":");
                    dupWithinSB.append(newLine);
                    dupWithinSB.append(tabsPlusThree);
                    if (AppPackage.Issue.OSS_CLASS == issue) {
                        dupWithinSB.append(serverMap.get(path));
                    } else {
                        dupWithinSB.append(ReportUtility.getArchiveNamePath(path));
                    }
                }
                dupWithinSB.append(newLine);
                dupWithinSB.append(newLine);
            }
            sb.append((CharSequence)dupWithinSB);
        }
    }

    private void addLocation(AppPackage pack, LinkedHashMap<String, String> locationMap, Map<String, String> serverMap, List<String> listOfLocations) {
        StringBuilder dupLocationSB = new StringBuilder();
        int size = listOfLocations.size();
        int i = 0;
        while (i < size) {
            String location = listOfLocations.get(i);
            dupLocationSB.append(location);
            if (++i == size) continue;
            dupLocationSB.append(newLine);
            dupLocationSB.append("\t\t\t\t");
        }
        this.addToLocationMap(locationMap, serverMap, dupLocationSB, pack);
    }

    private void addLocation(List<String> listOfLocations, AppPackage pack, LinkedHashMap<String, String> locationMapAcross, LinkedHashMap<String, String> locationMapWithin) {
        StringBuilder dupLocationSB = new StringBuilder();
        boolean includeInWithin = false;
        boolean includeInBoth = false;
        String prevParentArcName = "";
        LinkedHashMap<String, StringBuilder> mapOfParentArchToChild = new LinkedHashMap<String, StringBuilder>();
        int i = 0;
        while (i < listOfLocations.size()) {
            StringBuilder childArchs;
            String currentPackageLocation = listOfLocations.get(i);
            String currentParentArcName = Pattern.compile("([a-zA-Z]:)?\\/.*").matcher(currentPackageLocation).replaceFirst("");
            if (currentParentArcName.equals(currentPackageLocation)) {
                currentParentArcName = "topArchive";
            }
            if (mapOfParentArchToChild.containsKey(currentParentArcName)) {
                childArchs = (StringBuilder)mapOfParentArchToChild.get(currentParentArcName);
                childArchs.append(newLine);
                childArchs.append("\t\t\t\t");
                childArchs.append(currentPackageLocation);
                mapOfParentArchToChild.put(currentParentArcName, childArchs);
            } else {
                childArchs = new StringBuilder(currentPackageLocation);
                mapOfParentArchToChild.put(currentParentArcName, childArchs);
            }
            if (!includeInWithin && !prevParentArcName.isEmpty() && currentPackageLocation.endsWith(".jar") && currentParentArcName.equals(prevParentArcName)) {
                includeInWithin = true;
                if (i > 1) {
                    includeInBoth = true;
                }
            }
            if (includeInWithin && !prevParentArcName.equals(currentParentArcName)) {
                includeInBoth = true;
            }
            prevParentArcName = currentParentArcName;
            dupLocationSB.append(currentPackageLocation);
            if (i + 1 != listOfLocations.size()) {
                dupLocationSB.append(newLine);
                dupLocationSB.append("\t\t\t\t");
            }
            ++i;
        }
        if (includeInBoth) {
            this.addToLocationMap(locationMapAcross, null, dupLocationSB, pack);
            for (String key : mapOfParentArchToChild.keySet()) {
                StringBuilder locationsSB = (StringBuilder)mapOfParentArchToChild.get(key);
                String locations = locationsSB.toString();
                if (!locations.contains(tab) || !key.endsWith(".war") && !key.endsWith(".ear")) continue;
                this.addToLocationMap(locationMapWithin, null, locationsSB, pack);
            }
        } else if (includeInWithin) {
            this.addToLocationMap(locationMapWithin, null, dupLocationSB, pack);
        } else {
            this.addToLocationMap(locationMapAcross, null, dupLocationSB, pack);
        }
    }

    private void addToLocationMap(LinkedHashMap<String, String> locationMap, Map<String, String> serverMap, StringBuilder sb, AppPackage pack) {
        String locations = sb.toString();
        if (serverMap != null) {
            serverMap.put(locations, pack.getAffectServers());
        }
        if (locationMap.containsKey(locations)) {
            String packageNames = locationMap.get(locations);
            packageNames = String.valueOf(packageNames) + newLine + "\t\t\t\t" + pack.getName();
            locationMap.put(locations, packageNames);
        } else {
            locationMap.put(locations, pack.getName());
        }
    }

    public void buildNestedArchiveInventoryDetails(StringBuilder resultBuffer, Archive arch, int nestLevel) {
        String tabs = nestLevel == 1 ? tab : "\t\t";
        String tabsPlusOne = String.valueOf(tabs) + tab;
        Set<String> names = arch.getSubArchiveNames();
        for (String name2 : names) {
            Archive appArchive = arch.getArchive(name2);
            resultBuffer.append(tabs);
            resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
            resultBuffer.append(tabs);
            resultBuffer.append(Messages.getFormattedMessage(Messages.getString("INVENTORY_REPORT_ARCHIVE"), appArchive.getName()));
            resultBuffer.append(newLine);
            resultBuffer.append(tabs);
            resultBuffer.append(Messages.getFormattedMessage(Messages.getString("INVENTORY_REPORT_ARCHIVE_TYPE"), appArchive.getArchiveType().getType()));
            resultBuffer.append(newLine);
            if (appArchive.getArchiveType() != ArchiveInventory.ArchiveTypes.UTILITY_JAR) {
                String version = appArchive.getVersion();
                resultBuffer.append(tabs);
                if (version == null) {
                    resultBuffer.append(Messages.getFormattedMessage(Messages.getString("INVENTORY_REPORT_ARCHIVE_VERSION"), Messages.getString("INVENTORY_REPORT_UNSPECIFIED_ATTRIBUTE")));
                } else {
                    resultBuffer.append(Messages.getFormattedMessage(Messages.getString("INVENTORY_REPORT_ARCHIVE_VERSION"), version));
                }
                resultBuffer.append(newLine);
                resultBuffer.append(tabs);
                String metadataComplete = appArchive.getMetadataComplete();
                if (metadataComplete == null) {
                    metadataComplete = Messages.getString("INVENTORY_REPORT_UNSPECIFIED_ATTRIBUTE");
                } else if (metadataComplete.equals("ignored")) {
                    metadataComplete = Messages.getString("INVENTORY_REPORT_IGNORED_ATTRIBUTE");
                }
                resultBuffer.append(Messages.getFormattedMessage(Messages.getString("INVENTORY_REPORT_METADATA_COMPLETE"), metadataComplete));
                resultBuffer.append(newLine);
            }
            resultBuffer.append(tabs);
            resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
            if (appArchive.getArchiveType() == ArchiveInventory.ArchiveTypes.UTILITY_JAR) {
                UtilityJar utilJar = (UtilityJar)appArchive;
                Iterator<String> packages = utilJar.iterator();
                resultBuffer.append(tabs);
                resultBuffer.append(Messages.getString("INVENTORY_REPORT_UTILITY_JAR_PACKAGES"));
                resultBuffer.append(newLine);
                while (packages.hasNext()) {
                    resultBuffer.append(tabsPlusOne);
                    resultBuffer.append(String.valueOf(packages.next()) + newLine);
                }
            } else {
                this.buildArchiveCountSummary(resultBuffer, tabs, false, appArchive);
                this.buildFieldInfo(resultBuffer, tabs, false, appArchive);
            }
            if (appArchive.getTotalNumberOfArchives() <= 0 || nestLevel != 1) continue;
            this.buildNestedArchiveInventoryDetails(resultBuffer, appArchive, 2);
        }
    }

    @Override
    public void writeReport() {
        StringBuilder sb = new StringBuilder(65536);
        this.buildHeader(sb);
        this.buildGeneratedOnAndFor(sb);
        this.buildDashboard(sb);
        this.buildSummary(sb);
        this.buildInventoryDetails(sb);
        this.result = sb.toString();
    }

    @Override
    public String getResult() {
        return this.result;
    }
}

