/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer.text;

import com.ibm.ws.report.Messages;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.utilities.RuleInfo;
import com.ibm.ws.report.utilities.RuleSeverity;
import com.ibm.ws.report.writer.DetailAnalysisReportWriter;
import com.ibm.ws.report.writer.ReportWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class TextDetailAnalysisReportWriter
extends DetailAnalysisReportWriter
implements ReportWriter {
    private static String newLine = System.getProperty("line.separator");
    private static final String tab = "\t";

    public TextDetailAnalysisReportWriter(List<String> arrayOfProjects, String[] sourceOptions, String[] targetOptions, SortedMap<String, String> scanOptions, Map<String, List<DetailResult>> results, Map<String, Map<String, Map<String, List<String>>>> rulesAnalyzed, boolean formatByFile, Map<String, String> ruleHelp, Map<String, RuleSeverity> ruleSeverities, Map<String, RuleInfo> costs) {
        super(arrayOfProjects, sourceOptions, targetOptions, scanOptions, results, rulesAnalyzed, formatByFile, ruleHelp, null, ruleSeverities, costs, false, null);
    }

    private void buildHeader() {
        this.resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        this.resultBuffer.append(String.valueOf(Messages.getString("ANALYSIS_REPORT_HEADER")) + newLine);
        this.resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
    }

    private void buildSummary() {
        String allScanOptions;
        String allTargetOptions;
        this.resultBuffer.append(Messages.getString("ANALYSIS_REPORT_SUMMARY"));
        this.resultBuffer.append(newLine);
        this.resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        String allSourceOptions = ReportUtility.getOptions(this.sourceOptions, false);
        if (allSourceOptions.length() > 0) {
            this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_SOURCE_OPTIONS"), allSourceOptions));
            this.resultBuffer.append(newLine);
        }
        if ((allTargetOptions = ReportUtility.getOptions(this.targetOptions, false)).length() > 0) {
            this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_TARGET_OPTIONS"), allTargetOptions));
            this.resultBuffer.append(newLine);
        }
        if ((allScanOptions = ReportUtility.getOptions(this.scanOptions, false)).length() > 0) {
            this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_SCAN_OPTIONS"), allScanOptions));
            this.resultBuffer.append(newLine);
        }
        String excludedPackages = (String)this.scanOptions.get("excludePackages");
        String includedPackages = (String)this.scanOptions.get("includePackages");
        String excludedFiles = (String)this.scanOptions.get("excludeFiles");
        if (excludedPackages != null) {
            this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_EXCLUDED_PACKAGES_OPTION"), excludedPackages));
            this.resultBuffer.append(newLine);
        }
        if (includedPackages != null) {
            this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_INCLUDED_PACKAGES_OPTION"), includedPackages));
            this.resultBuffer.append(newLine);
        }
        if (excludedFiles != null) {
            this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_EXCLUDED_FILES_OPTION"), excludedFiles));
            this.resultBuffer.append(newLine);
        }
        this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_RULES_FLAGGED"), this.ruleIdentifiers.size()));
        this.resultBuffer.append(newLine);
        this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_NUMBER_OF_FILES_AFFECTED"), this.filesAffected.size()));
        this.resultBuffer.append(newLine);
        this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_NUMBER_OF_INDIVIDUAL_RESULTS"), this.totalNumberOfResults));
        this.resultBuffer.append(newLine);
        this.resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        this.buildRuleSeveritySummary();
    }

    private void buildRuleSeveritySummary() {
        if (this.totalNumberOfResults > 0) {
            this.resultBuffer.append(Messages.getString("ANALYSIS_REPORT_RULE_SEVERITY_SUMMARY"));
            this.resultBuffer.append(newLine);
            this.resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
            boolean needSeparator = false;
            needSeparator = this.addRuleSeveritySection(needSeparator, Messages.getString("ANALYSIS_REPORT_SEVERITY_SEVERE_LABEL"), Messages.getString("ANALYSIS_REPORT_SEVERITY_SEVERE_DESCRIPTION"), this.numSevereRules, this.numSevereRuleResults);
            needSeparator = this.addRuleSeveritySection(needSeparator, Messages.getString("ANALYSIS_REPORT_SEVERITY_WARNING_LABEL"), Messages.getString("ANALYSIS_REPORT_SEVERITY_WARNING_DESCRIPTION"), this.numWarningRules, this.numWarningRuleResults);
            needSeparator = this.addRuleSeveritySection(needSeparator, Messages.getString("ANALYSIS_REPORT_SEVERITY_INFO_LABEL"), Messages.getString("ANALYSIS_REPORT_SEVERITY_INFO_DESCRIPTION"), this.numInfoRules, this.numInfoRuleResults);
            this.addRuleSeveritySection(needSeparator, Messages.getString("ANALYSIS_REPORT_SEVERITY_NONE_LABEL"), Messages.getString("ANALYSIS_REPORT_SEVERITY_NONE_DESCRIPTION"), this.numNoSeverityRules, this.numNoSeverityRuleResults);
            this.resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        }
    }

    private boolean addRuleSeveritySection(boolean includeSeparator, String label, String desc, int numRules, int numResults) {
        boolean flag = false;
        if (numRules > 0) {
            flag = true;
            if (includeSeparator) {
                this.resultBuffer.append(Messages.getString("TECH_EVAL_DETAIL_RESULTS_SEPARATOR"));
            }
            this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_RULE_SEVERITY_TEXT_REPORT"), label));
            this.resultBuffer.append(newLine);
            this.resultBuffer.append(tab);
            this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_DESCRIPTION"), desc));
            this.resultBuffer.append(newLine);
            this.resultBuffer.append(tab);
            this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_RULES_FLAGGED"), numRules));
            this.resultBuffer.append(newLine);
            this.resultBuffer.append(tab);
            this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_NUMBER_OF_INDIVIDUAL_RESULTS"), numResults));
            this.resultBuffer.append(newLine);
        }
        return flag;
    }

    private void buildResultsByRule() {
        this.resultBuffer.append(String.valueOf(Messages.getString("ANALYSIS_REPORT_DETAILED_RESULTS_BY_RULE")) + newLine);
        this.resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        for (String ruleIdentifier : this.ruleIdentifiers) {
            String ruleId = this.parseRuleIdFromIdentfier(ruleIdentifier);
            String ruleDesc = this.parseRuleNameFromIdentfier(ruleIdentifier);
            this.resultBuffer.append(Messages.getString("ANALYSIS_REPORT_MINOR_SEPARATOR"));
            this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("TECH_EVAL_DETAIL_RESULTS_RULE"), ruleDesc));
            this.resultBuffer.append(newLine);
            RuleSeverity sev = (RuleSeverity)((Object)this.severityByRuleId.get(ruleId));
            String severityString = null;
            switch (sev) {
                case SEVERE: {
                    severityString = Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_RULE_SEVERITY_TEXT_REPORT"), Messages.getString("ANALYSIS_REPORT_SEVERITY_SEVERE_LABEL"));
                    break;
                }
                case WARNING: {
                    severityString = Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_RULE_SEVERITY_TEXT_REPORT"), Messages.getString("ANALYSIS_REPORT_SEVERITY_WARNING_LABEL"));
                    break;
                }
                case INFO: {
                    severityString = Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_RULE_SEVERITY_TEXT_REPORT"), Messages.getString("ANALYSIS_REPORT_SEVERITY_INFO_LABEL"));
                    break;
                }
                default: {
                    severityString = Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_RULE_SEVERITY_TEXT_REPORT"), Messages.getString("ANALYSIS_REPORT_SEVERITY_NONE_LABEL"));
                }
            }
            this.resultBuffer.append(severityString);
            this.resultBuffer.append(newLine);
            this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_RULE_CATEGORY_TEXT_REPORT"), this.categoryByRuleDesc.get(ruleDesc)));
            this.resultBuffer.append(newLine);
            this.resultBuffer.append(Messages.getString("ANALYSIS_REPORT_MINOR_SEPARATOR"));
            this.buildRuleResultsTable(ruleId, ruleDesc);
        }
    }

    private void buildRuleResultsTable(String id, String desc) {
        boolean isFirstFile = true;
        List sortedFileNamesAffected = (List)this.filesAffectedByRuleId.get(id);
        for (String currentFileName : sortedFileNamesAffected) {
            if (!isFirstFile) {
                this.resultBuffer.append(Messages.getString("TECH_EVAL_DETAIL_RESULTS_SEPARATOR"));
            } else {
                isFirstFile = false;
            }
            int length = currentFileName.length();
            if (length > 66) {
                String firstChunk = currentFileName.substring(0, 65);
                int lastIndexOfPeriod = firstChunk.lastIndexOf(46);
                int lastIndexOfSlash = firstChunk.lastIndexOf(47);
                int endIndex = 66;
                if (lastIndexOfPeriod > -1 || lastIndexOfSlash > -1) {
                    int n = endIndex = lastIndexOfPeriod > lastIndexOfSlash ? lastIndexOfPeriod : lastIndexOfSlash;
                    if (endIndex < 66) {
                        ++endIndex;
                    }
                }
                this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("TECH_EVAL_DETAIL_RESULTS_FILENAME"), currentFileName.substring(0, endIndex)));
                this.resultBuffer.append(newLine);
                int startIndex = endIndex;
                endIndex = startIndex + 66;
                while (length > startIndex) {
                    int n = endIndex = endIndex > length - 1 ? length : endIndex;
                    if (endIndex == length) {
                        this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("TECH_EVAL_DETAIL_RESULTS_FILENAME_CONTINUED"), currentFileName.substring(startIndex)));
                        this.resultBuffer.append(newLine);
                    } else {
                        String nextChunk = currentFileName.substring(startIndex, endIndex - 1);
                        lastIndexOfPeriod = nextChunk.lastIndexOf(46);
                        lastIndexOfSlash = nextChunk.lastIndexOf(47);
                        if (lastIndexOfPeriod > -1 || lastIndexOfSlash > -1) {
                            int n2 = endIndex = lastIndexOfPeriod > lastIndexOfSlash ? lastIndexOfPeriod + startIndex : lastIndexOfSlash + startIndex;
                            if (endIndex < startIndex + 66) {
                                ++endIndex;
                            }
                        }
                        this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("TECH_EVAL_DETAIL_RESULTS_FILENAME_CONTINUED"), currentFileName.substring(startIndex, endIndex)));
                        this.resultBuffer.append(newLine);
                    }
                    startIndex = endIndex;
                    endIndex = startIndex + 66;
                }
            } else {
                this.resultBuffer.append(String.valueOf(Messages.getFormattedMessage(Messages.getString("TECH_EVAL_DETAIL_RESULTS_FILENAME"), currentFileName)) + newLine);
                this.resultBuffer.append(newLine);
            }
            List theResults = (List)this.resultsByFileName.get(currentFileName);
            Collections.sort(theResults);
            for (DetailResult thisResult : theResults) {
                int lineNumber;
                if (!desc.equals(thisResult.getRuleDesc())) continue;
                String criteria = thisResult.getCriteria();
                String ref = thisResult.getReference();
                String refDetails = "";
                int numOccurrences = thisResult.getNumberOfOccurrences();
                if (numOccurrences > 1) {
                    refDetails = Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_REFERENCE_AND_OCCURRENCES"), ref, numOccurrences);
                } else if (ref != null) {
                    refDetails = ref;
                }
                if (!refDetails.isEmpty()) {
                    this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_REFERENCE"), refDetails));
                    this.resultBuffer.append(newLine);
                }
                if ((lineNumber = thisResult.getLineNumber()) > 0) {
                    this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_CRITERIA_LINE"), criteria, lineNumber));
                    this.resultBuffer.append(newLine);
                    continue;
                }
                this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_CRITERIA"), criteria));
                this.resultBuffer.append(newLine);
            }
        }
    }

    private void buildRulesAnalyzed() {
        this.resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        this.resultBuffer.append(Messages.getString("ANALYSIS_REPORT_RULES_ANALYZED"));
        this.resultBuffer.append(newLine);
        this.resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        Set keys = this.rulesAnalyzed.keySet();
        ArrayList sortedMainCatKeys = new ArrayList(keys);
        Collections.sort(sortedMainCatKeys);
        for (String mainCatKey : sortedMainCatKeys) {
            Map subcats = (Map)this.rulesAnalyzed.get(mainCatKey);
            if (subcats.containsKey(mainCatKey) && subcats.size() == 1) {
                this.resultBuffer.append(Messages.getString("ANALYSIS_REPORT_MINOR_SEPARATOR"));
                this.resultBuffer.append(mainCatKey);
                this.resultBuffer.append(newLine);
                Map rulesByType = (Map)subcats.get(mainCatKey);
                this.buildRulesAnalyzedByType(mainCatKey, mainCatKey, rulesByType);
                continue;
            }
            Set subcatKeys = subcats.keySet();
            ArrayList sortedSubCatKeys = new ArrayList(subcatKeys);
            Collections.sort(sortedSubCatKeys);
            this.resultBuffer.append(Messages.getString("ANALYSIS_REPORT_MINOR_SEPARATOR"));
            this.resultBuffer.append(mainCatKey);
            this.resultBuffer.append(newLine);
            for (String subcatKey : sortedSubCatKeys) {
                this.resultBuffer.append(Messages.getString("ANALYSIS_REPORT_MINOR_SEPARATOR"));
                this.resultBuffer.append(subcatKey);
                this.resultBuffer.append(newLine);
                Map rulesByType = (Map)subcats.get(subcatKey);
                this.buildRulesAnalyzedByType(mainCatKey, subcatKey, rulesByType);
            }
        }
    }

    public void buildGeneratedOn() {
        this.resultBuffer.append(newLine);
        this.resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        SimpleDateFormat localDateFormat = new SimpleDateFormat();
        this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_FOOTER"), localDateFormat.format(new Date())));
        this.resultBuffer.append(newLine);
        if (this.projects != null) {
            int rowCounter = 0;
            int total = this.projects.size();
            for (String item : this.projects) {
                if (++rowCounter < total) {
                    this.resultBuffer.append(item);
                    this.resultBuffer.append(", ");
                    continue;
                }
                this.resultBuffer.append(item);
                this.resultBuffer.append(newLine);
            }
        }
        this.resultBuffer.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
    }

    public void buildRulesAnalyzedByType(String mainCat, String secondaryCat, Map<String, List<String>> rulesByType) {
        Set<String> keys = rulesByType.keySet();
        ArrayList<String> sortedKeys = new ArrayList<String>(keys);
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            String ruleType = null;
            if (key.equals("file")) {
                ruleType = Messages.getString("ANALYSIS_REPORT_FILE_RULES");
            } else if (key.equals("java")) {
                ruleType = Messages.getString("ANALYSIS_REPORT_JAVA_RULES");
            } else if (key.equals("jsp")) {
                ruleType = Messages.getString("ANALYSIS_REPORT_JSP_RULES");
            } else if (key.equals("mf")) {
                ruleType = Messages.getString("ANALYSIS_REPORT_MANIFEST_RULES");
            } else if (key.equals("property")) {
                ruleType = Messages.getString("ANALYSIS_REPORT_PROPERTY_RULES");
            } else if (key.equals("xml")) {
                ruleType = Messages.getString("ANALYSIS_REPORT_XML_RULES");
            }
            List<String> ruleIdentifiers = rulesByType.get(key);
            if (ruleIdentifiers.size() <= 0) continue;
            this.resultBuffer.append(Messages.getString("ANALYSIS_REPORT_MINOR_SEPARATOR"));
            this.resultBuffer.append(ruleType);
            this.resultBuffer.append(newLine);
            this.resultBuffer.append(Messages.getString("ANALYSIS_REPORT_MINOR_SEPARATOR"));
            for (String ruleIdentifier : ruleIdentifiers) {
                String ruleDesc = this.parseRuleNameFromIdentfier(ruleIdentifier);
                this.resultBuffer.append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_RULE"), ruleDesc));
                this.resultBuffer.append(newLine);
            }
        }
    }

    @Override
    public void writeReport() {
        this.buildHeader();
        this.buildSummary();
        if (!this.formatByFile) {
            this.buildResultsByRule();
        }
        this.buildRulesAnalyzed();
        this.buildGeneratedOn();
        this.close();
    }
}

