/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer.json;

import com.ibm.json.java.OrderedJSONObject;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.File;
import java.util.logging.Level;

public class TAScanStatusWriter {
    private final String startTime;
    private final String endTime;
    private final String statusFilePath;
    private final int warnings;
    private final int errors;
    private final int totalProfiles;
    private final int completedProfiles;
    private final String currentProfile;
    private final int totalApplications;
    private final int completedApplications;
    private final String currentApplication;
    private final int totalSharedLibraries;
    private final int completedSharedLibraries;
    private final String currentSharedLibrary;
    private final int totalZips;
    private final int completedZips;
    private final String currentZip;

    public TAScanStatusWriter(String startTime, String endTime, String statusFilePath, int warnings, int errors, int totalProfiles, int completedProfiles, String currentProfile, int totalApplications, int completedApplications, String currentApplication, int totalSharedLibraries, int completedSharedLibraries, String currentSharedLibrary, int totalZips, int completedZips, String currentZip) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.statusFilePath = statusFilePath;
        this.warnings = warnings;
        this.errors = errors;
        this.totalProfiles = totalProfiles;
        this.completedProfiles = completedProfiles;
        this.currentProfile = currentProfile;
        this.totalApplications = totalApplications;
        this.completedApplications = completedApplications;
        this.currentApplication = currentApplication;
        this.totalSharedLibraries = totalSharedLibraries;
        this.completedSharedLibraries = completedSharedLibraries;
        this.currentSharedLibrary = currentSharedLibrary;
        this.totalZips = totalZips;
        this.completedZips = completedZips;
        this.currentZip = currentZip;
    }

    public OrderedJSONObject toJSONObject() {
        OrderedJSONObject json = new OrderedJSONObject();
        json.put("startTime", this.startTime);
        json.put("endTime", this.endTime);
        json.put("statusFilePath", this.statusFilePath);
        json.put("warnings", (Object)this.warnings);
        json.put("errors", (Object)this.errors);
        json.put("profiles", this.createSummaryJSON(this.totalProfiles, this.completedProfiles, this.currentProfile));
        json.put("applications", this.createSummaryJSON(this.totalApplications, this.completedApplications, this.currentApplication));
        json.put("sharedLibraries", this.createSummaryJSON(this.totalSharedLibraries, this.completedSharedLibraries, this.currentSharedLibrary));
        json.put("zipFiles", this.createSummaryJSON(this.totalZips, this.completedZips, this.currentZip));
        return json;
    }

    public OrderedJSONObject createSummaryJSON(int total, int completed, String current) {
        OrderedJSONObject status2 = new OrderedJSONObject();
        status2.put("total", (Object)total);
        status2.put("completed", (Object)completed);
        status2.put("current", current);
        return status2;
    }

    public OrderedJSONObject createTimestampJSON(String startTime, String endTime) {
        OrderedJSONObject json = new OrderedJSONObject();
        json.put("startTime", startTime);
        json.put("endTime", endTime);
        return json;
    }

    public void writeToJsonFile(String outputDir) throws Exception {
        String fileName = "scan_status.json";
        File outputFile = new File(outputDir != null && !outputDir.isEmpty() ? String.valueOf(outputDir) + File.separator + fileName : fileName);
        OrderedJSONObject scanStatusJson = this.toJSONObject();
        ReportUtility.writeOutStream(outputFile, scanStatusJson.serialize(true), Level.INFO, false);
    }
}

