/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer.json;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.ws.report.analyze.AnalysisResults;
import com.ibm.ws.report.inventory.ArchiveInventory;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.technology.TechSummary;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.utilities.RuleInfo;
import com.ibm.ws.report.utilities.RuleSeverity;
import com.ibm.ws.report.writer.ReportWriter;
import com.ibm.ws.report.writer.json.JSONDetailAnalysisReportWriter;
import com.ibm.ws.report.writer.json.JSONEvaluationReportWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class JSONMigrationReportWriter
implements ReportWriter {
    private SortedMap<String, String> scanOptions = null;
    protected String[] sourceOptions = null;
    protected String[] targetOptions = null;
    private String returnString;
    private List<String> projects = null;
    private List<String> sharedLibProjectNames = null;
    private ArchiveInventory inventory = null;
    private SortedSet<String> coreFeatures = null;
    private SortedSet<String> baseFeatures = null;
    private List<String> featureConflictMessages = null;
    private boolean hasConflicts = false;
    private boolean includeFeatureList = false;
    private JSONDetailAnalysisReportWriter analyzeWriter = null;
    private JSONEvaluationReportWriter evalWriter = null;

    public JSONMigrationReportWriter(List<String> arrayOfProjects, SortedMap<String, TechSummary> listOfTechSummaries, List<String> productsToShow, SortedMap<String, String> scanOptions, String[] sourceOptions, String[] targetOptions, Map<String, List<DetailResult>> analyzeResults, Map<String, Map<String, Map<String, List<String>>>> rulesAnalyzed, boolean formatByFile, Map<String, String> ruleHelp, Map<String, RuleSeverity> ruleSeverities, Map<String, RuleInfo> costs, ArchiveInventory ai, List<String> sharedLibProjectNames, boolean includeFeatureList, SortedSet<String> coreFeatures, SortedSet<String> baseFeatures, List<String> featureConflictMessages, boolean hasConflicts, Map<String, Set<String>> appToRuleDescs, Map<String, String> categoryNameToKey, boolean includeHelpLocation, int maxUserDefinedRuleResults, AnalysisResults analysisResults) {
        this.scanOptions = scanOptions;
        this.sourceOptions = sourceOptions;
        this.targetOptions = targetOptions;
        this.projects = arrayOfProjects;
        this.inventory = ai;
        this.sharedLibProjectNames = sharedLibProjectNames;
        this.coreFeatures = coreFeatures;
        this.baseFeatures = baseFeatures;
        this.featureConflictMessages = featureConflictMessages;
        this.hasConflicts = hasConflicts;
        this.includeFeatureList = includeFeatureList;
        this.evalWriter = new JSONEvaluationReportWriter(arrayOfProjects, listOfTechSummaries, productsToShow, scanOptions, appToRuleDescs);
        this.analyzeWriter = new JSONDetailAnalysisReportWriter(arrayOfProjects, sourceOptions, targetOptions, scanOptions, analyzeResults, rulesAnalyzed, false, ruleHelp, ruleSeverities, costs, arrayOfProjects, categoryNameToKey, includeHelpLocation, maxUserDefinedRuleResults, analysisResults);
    }

    private JSONArray getAllOptions() {
        String option;
        JSONArray allOptions = new JSONArray();
        for (String key : this.scanOptions.keySet()) {
            allOptions.add(this.scanOptions.get(key));
        }
        String[] stringArray = this.sourceOptions;
        int n = this.sourceOptions.length;
        int n2 = 0;
        while (n2 < n) {
            option = stringArray[n2];
            allOptions.add(option);
            ++n2;
        }
        stringArray = this.targetOptions;
        n = this.targetOptions.length;
        n2 = 0;
        while (n2 < n) {
            option = stringArray[n2];
            allOptions.add(option);
            ++n2;
        }
        return allOptions;
    }

    @Override
    public String getResult() {
        return this.returnString;
    }

    private void writeHeader(OrderedJSONObject reportObject) {
        ReportUtility.writeJSONHeader(reportObject, "migration", "4.0", this.getAllOptions());
        reportObject.put("application", this.projects.get(0));
        if (!this.sharedLibProjectNames.isEmpty()) {
            JSONArray sharedLibrariesArray = new JSONArray();
            for (String appName : this.sharedLibProjectNames) {
                sharedLibrariesArray.add(appName);
            }
            reportObject.put("sharedLibraries", sharedLibrariesArray);
        }
    }

    private void writeEvaluateSection(OrderedJSONObject reportObject) {
        OrderedJSONObject evalObject = new OrderedJSONObject();
        this.evalWriter.addSummaryAndTable(evalObject);
        reportObject.put("evaluate", evalObject);
    }

    private void writeAnalyzeSection(OrderedJSONObject reportObject) {
        OrderedJSONObject analyzeObject = new OrderedJSONObject();
        this.analyzeWriter.buildDashboard(analyzeObject);
        this.analyzeWriter.buildRuleSeveritySummary(analyzeObject);
        this.analyzeWriter.buildRulesArray(analyzeObject);
        reportObject.put("analyze", analyzeObject);
    }

    private void writeInventorySection(OrderedJSONObject reportObject) {
        OrderedJSONObject inventoryObject = new OrderedJSONObject();
        this.inventory.toJSON(inventoryObject, this.projects, this.sharedLibProjectNames);
        if (inventoryObject.containsKey("applications")) {
            inventoryObject.remove("applications");
        }
        reportObject.put("inventory", inventoryObject);
    }

    private void writeFeatureListSection(OrderedJSONObject reportObject) {
        OrderedJSONObject featureListObject = new OrderedJSONObject();
        JSONArray coreFeatureArray = new JSONArray();
        for (String nextFeature : this.coreFeatures) {
            coreFeatureArray.add(nextFeature);
        }
        featureListObject.put("allEditionFeatures", coreFeatureArray);
        JSONArray baseFeatureArray = new JSONArray();
        for (String nextFeature : this.baseFeatures) {
            baseFeatureArray.add(nextFeature);
        }
        featureListObject.put("baseAndAboveFeatures", baseFeatureArray);
        if (this.hasConflicts) {
            JSONArray featureConflicts = new JSONArray();
            for (String nextFeature : this.featureConflictMessages) {
                featureConflicts.add(nextFeature);
            }
            featureListObject.put("featureConflicts", featureConflicts);
        }
        reportObject.put("featureList", featureListObject);
    }

    @Override
    public void writeReport() {
        OrderedJSONObject reportObject = new OrderedJSONObject();
        this.writeHeader(reportObject);
        this.writeEvaluateSection(reportObject);
        this.writeAnalyzeSection(reportObject);
        this.writeInventorySection(reportObject);
        if (this.includeFeatureList) {
            this.writeFeatureListSection(reportObject);
        }
        this.convertJsonToString(reportObject);
    }

    private void convertJsonToString(OrderedJSONObject reportObject) {
        try {
            String jsonString = reportObject.serialize(true);
            this.returnString = jsonString = jsonString.replace("\\/", "/");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

