/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModuleHierarchy {
    String moduleName = null;
    Map<String, ModuleHierarchy> children = new HashMap<String, ModuleHierarchy>();
    int[] numberResultsPerRuleIncludingChildren = null;
    int[] numberResultsPerRuleThisModule = null;

    public ModuleHierarchy(List<String> modules, int numberOfOccurences, int ruleIndex, int numberOfRules) {
        this.numberResultsPerRuleThisModule = new int[numberOfRules];
        this.numberResultsPerRuleIncludingChildren = new int[numberOfRules];
        this.numberResultsPerRuleIncludingChildren[ruleIndex] = this.numberResultsPerRuleIncludingChildren[ruleIndex] + numberOfOccurences;
        this.moduleName = modules.get(0);
        if (modules.size() == 1) {
            this.numberResultsPerRuleThisModule[ruleIndex] = this.numberResultsPerRuleThisModule[ruleIndex] + numberOfOccurences;
        } else {
            ModuleHierarchy child = new ModuleHierarchy(modules.subList(1, modules.size()), numberOfOccurences, ruleIndex, numberOfRules);
            this.children.put(child.getModuleName(), child);
        }
    }

    public void addModules(List<String> modules, int numberOfOccurences, int ruleIndex) {
        this.numberResultsPerRuleIncludingChildren[ruleIndex] = this.numberResultsPerRuleIncludingChildren[ruleIndex] + numberOfOccurences;
        if (modules.size() == 1) {
            this.numberResultsPerRuleThisModule[ruleIndex] = this.numberResultsPerRuleThisModule[ruleIndex] + numberOfOccurences;
        } else {
            String childModuleName = modules.get(1);
            if (this.children.containsKey(childModuleName)) {
                ModuleHierarchy child = this.children.get(childModuleName);
                child.addModules(modules.subList(1, modules.size()), numberOfOccurences, ruleIndex);
            } else {
                ModuleHierarchy child = new ModuleHierarchy(modules.subList(1, modules.size()), numberOfOccurences, ruleIndex, this.numberResultsPerRuleThisModule.length);
                this.children.put(childModuleName, child);
            }
        }
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getDisplayModuleName() {
        int index = this.moduleName.lastIndexOf(47);
        if (index > -1) {
            return this.moduleName.substring(index + 1);
        }
        return this.moduleName;
    }

    public int[] getResultsPerRuleIncludingChildren() {
        return this.numberResultsPerRuleIncludingChildren;
    }

    public int[] getResultsPerRuleThisModule() {
        return this.numberResultsPerRuleThisModule;
    }

    public List<String> getSortedChildren() {
        Set<String> keys = this.children.keySet();
        ArrayList<String> sortedKeys = new ArrayList<String>(keys);
        Collections.sort(sortedKeys);
        return sortedKeys;
    }

    public ModuleHierarchy getChild(String moduleName) {
        return this.children.get(moduleName);
    }
}

