/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.was2liberty.technology;

import com.ibm.ws.report.technology.AbstractTechnology;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.was2liberty.technology.Was2LibertyTechnologyFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Was2LibertyTechnology
implements AbstractTechnology {
    private String _name = null;
    private String _id = null;
    private String _referredToAs = null;
    private int[] _support = null;
    private HashSet<Set<String>> _triggerOnAnyRules = new HashSet();
    private HashSet<String> _triggerOnAllRules = new HashSet();
    private HashSet<String> _triggerOnNoneRules = new HashSet();
    private List<DetailResult> _detailResults = new ArrayList<DetailResult>();

    public Was2LibertyTechnology(String name2, String id, int[] support) {
        this(name2, id, support, null);
    }

    public Was2LibertyTechnology(String name2, String id, int[] support, String referredToAs) {
        this._name = name2;
        this._id = id;
        this._support = support;
        this._referredToAs = referredToAs;
    }

    @Override
    @Deprecated
    public String getKey() {
        return this._name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public int[] getSupport() {
        return this._support;
    }

    @Override
    public String getReferredToAs() {
        return this._referredToAs;
    }

    @Override
    public List<DetailResult> getDetailResults() {
        return this._detailResults;
    }

    protected String[] getTriggerOnNoneRules() {
        String[] rules = new String[this._triggerOnNoneRules.size()];
        if (this._triggerOnNoneRules.size() > 0) {
            rules = this._triggerOnNoneRules.toArray(rules);
        }
        return rules;
    }

    protected String[] getTriggerOnAnyRules() {
        HashSet<String> allAnyRules = new HashSet<String>();
        for (Set<String> theseRules : this._triggerOnAnyRules) {
            allAnyRules.addAll(theseRules);
        }
        String[] rules = new String[allAnyRules.size()];
        if (allAnyRules.size() > 0) {
            rules = allAnyRules.toArray(rules);
        }
        return rules;
    }

    protected String[] getTriggerOnAllRules() {
        String[] rules = new String[this._triggerOnAllRules.size()];
        if (this._triggerOnAllRules.size() > 0) {
            rules = this._triggerOnAllRules.toArray(rules);
        }
        return rules;
    }

    @Override
    public String[] getRulesToTrigger() {
        String[] triggerOnAnyRules = this.getTriggerOnAnyRules();
        String[] triggerOnAllRules = this.getTriggerOnAllRules();
        String[] triggerOnNoneRules = this.getTriggerOnNoneRules();
        int totalSize = triggerOnAnyRules.length + triggerOnAllRules.length + triggerOnNoneRules.length;
        String[] allRules = null;
        if (totalSize > 0) {
            if (totalSize == triggerOnAnyRules.length) {
                allRules = triggerOnAnyRules;
            } else if (totalSize == triggerOnAllRules.length) {
                allRules = triggerOnAllRules;
            } else if (totalSize == triggerOnNoneRules.length) {
                allRules = triggerOnNoneRules;
            } else {
                allRules = new String[totalSize];
                int i = 0;
                while (i < triggerOnAnyRules.length) {
                    allRules[i] = triggerOnAnyRules[i];
                    ++i;
                }
                int j = 0;
                while (j < triggerOnAllRules.length) {
                    allRules[i] = triggerOnAllRules[j];
                    ++i;
                    ++j;
                }
                j = 0;
                while (j < triggerOnNoneRules.length) {
                    allRules[i] = triggerOnNoneRules[j];
                    ++i;
                    ++j;
                }
            }
        } else {
            allRules = new String[]{};
        }
        return allRules;
    }

    @Override
    public boolean trigger(List<String> rulesFound) {
        String[] triggerOnAnyRules = this.getTriggerOnAnyRules();
        String[] triggerOnAllRules = this.getTriggerOnAllRules();
        String[] triggerOnNoneRules = this.getTriggerOnNoneRules();
        boolean emptyList = triggerOnAllRules.length == 0 && triggerOnAnyRules.length == 0 && triggerOnNoneRules.length == 0;
        boolean hasAll = false;
        boolean hasAny = false;
        boolean hasNone = false;
        if (!emptyList) {
            boolean bl = hasAll = triggerOnAllRules.length > 0 ? Was2LibertyTechnologyFactory.triggerOnAll(triggerOnAllRules, rulesFound) : true;
            if (hasAll) {
                boolean bl2 = triggerOnNoneRules.length > 0 ? !Was2LibertyTechnologyFactory.triggerOnAny(triggerOnNoneRules, rulesFound) : (hasNone = true);
                if (hasNone) {
                    if (this._triggerOnAnyRules.size() > 1) {
                        for (Set<String> anyRules : this._triggerOnAnyRules) {
                            int size = anyRules.size();
                            String[] triggerRules = new String[size];
                            hasAny = Was2LibertyTechnologyFactory.triggerOnAny(triggerRules = anyRules.toArray(triggerRules), rulesFound);
                            if (hasAny) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        boolean bl3 = hasAny = triggerOnAnyRules.length > 0 ? Was2LibertyTechnologyFactory.triggerOnAny(triggerOnAnyRules, rulesFound) : true;
                    }
                }
            }
        }
        return !emptyList && hasAll && hasNone && hasAny;
    }

    @Override
    public void addTriggerOnAnyRules(Set<Set<String>> ruleNames) {
        this._triggerOnAnyRules.addAll(ruleNames);
    }

    @Override
    public void addTriggerOnAllRules(Set<String> ruleNames) {
        this._triggerOnAllRules.addAll(ruleNames);
    }

    @Override
    public void addTriggerOnNoneRules(Set<String> ruleNames) {
        this._triggerOnNoneRules.addAll(ruleNames);
    }

    @Override
    public List<DetailResult> calculateDetailResults(Map<String, List<String>> projectsToRulesFound, Map<String, List<DetailResult>> projectsToDetailResults) {
        Set<String> keys = projectsToRulesFound.keySet();
        for (String key : keys) {
            List<String> rulesFound = projectsToRulesFound.get(key);
            ArrayList<String> rulesTriggered = new ArrayList<String>();
            String[] triggerOnAnyRules = this.getTriggerOnAnyRules();
            String[] triggerOnAllRules = this.getTriggerOnAllRules();
            String[] triggerOnNoneRules = this.getTriggerOnNoneRules();
            boolean emptyList = triggerOnAllRules.length == 0 && triggerOnAnyRules.length == 0 && triggerOnNoneRules.length == 0;
            boolean hasAll = false;
            boolean hasAny = false;
            boolean hasNone = false;
            if (emptyList) continue;
            boolean bl = hasAll = triggerOnAllRules.length > 0 ? Was2LibertyTechnologyFactory.triggerOnAll(triggerOnAllRules, rulesFound) : true;
            if (hasAll) {
                boolean bl2 = triggerOnNoneRules.length > 0 ? !Was2LibertyTechnologyFactory.triggerOnAny(triggerOnNoneRules, rulesFound) : (hasNone = true);
                if (hasNone) {
                    rulesTriggered.addAll(this._triggerOnAllRules);
                    if (triggerOnAnyRules.length == 0) {
                        hasAny = true;
                    }
                    if (this._triggerOnAnyRules.size() > 1) {
                        for (Set<String> anyRules : this._triggerOnAnyRules) {
                            hasAny = false;
                            for (String ruleName : anyRules) {
                                if (rulesFound == null || !rulesFound.contains(ruleName)) continue;
                                hasAny = true;
                                rulesTriggered.add(ruleName);
                            }
                            if (hasAny) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        String[] stringArray = triggerOnAnyRules;
                        int n = triggerOnAnyRules.length;
                        int anyRules = 0;
                        while (anyRules < n) {
                            String ruleName = stringArray[anyRules];
                            if (rulesFound != null && rulesFound.contains(ruleName)) {
                                hasAny = true;
                                rulesTriggered.add(ruleName);
                            }
                            ++anyRules;
                        }
                    }
                }
            }
            if (!hasAll || !hasNone || !hasAny) continue;
            List<DetailResult> detailResults = projectsToDetailResults.get(key);
            for (DetailResult thisResult : detailResults) {
                if (!rulesTriggered.contains(thisResult.getRuleName())) continue;
                this._detailResults.add(thisResult);
            }
        }
        return this._detailResults;
    }
}

