/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.processor;

import com.ibm.ws.report.Messages;
import com.ibm.ws.report.SupportConstants;
import com.ibm.ws.report.technology.AbstractTechnologyFactory;
import com.ibm.ws.report.technology.ReportHeader;
import com.ibm.ws.report.technology.ReportRow;
import com.ibm.ws.report.utilities.Constants;
import com.ibm.ws.report.utilities.FileHelper;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.utilities.RuleInfo;
import com.ibm.ws.report.utilities.RuleSeverity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReportBuilder {
    private static final boolean DEBUG = false;
    public Set<String> _ruleIds = new HashSet<String>();
    public Map<String, String> _helpIds = new HashMap<String, String>();
    public Map<String, RuleSeverity> _severities = new HashMap<String, RuleSeverity>();
    public Map<String, RuleInfo> _costs = new HashMap<String, RuleInfo>();
    public Map<String, SortedSet<String>> _descToRuleIds = new HashMap<String, SortedSet<String>>();
    public boolean _foundInvalidRule = false;
    public int returnCode = 0;
    public Set<File> loadedLists = new HashSet<File>();
    public Map<File, String> mapOfListToCategory = new HashMap<File, String>();
    public String currentCategory = null;
    public Map<String, Set<String>> targetToCategories = new HashMap<String, Set<String>>();
    public Set<String> currentCategories;
    private Set<String> _excludedRuleList = null;

    public void setExcludedRuleList(Set<String> excludedRules) {
        this._excludedRuleList = excludedRules;
    }

    public void createCategorySet(String targetAppServer) {
        this.currentCategories = new HashSet<String>();
        this.targetToCategories.put(targetAppServer, this.currentCategories);
    }

    public void buildReport(AbstractTechnologyFactory factory, String reportList) {
        ArrayList<ReportHeader> headers = new ArrayList<ReportHeader>();
        ArrayList<String> headerIds = new ArrayList<String>();
        Map<String, List<String>> fileNamesByHeader = this.getNamesOfXmlRuleFiles(reportList, headerIds);
        String prefix = "";
        int index = reportList.lastIndexOf(47);
        if (index > -1) {
            prefix = reportList.substring(0, index + 1);
        }
        int numHeaders = headerIds.size();
        int i = 0;
        while (i < numHeaders) {
            String headerId = (String)headerIds.get(i);
            List<String> ruleFileNames = fileNamesByHeader.get(headerId);
            ReportHeader header = new ReportHeader(headerId);
            headers.add(header);
            if (ruleFileNames != null) {
                for (String ruleFile : ruleFileNames) {
                    InputStream xmlFile = this.getClass().getResourceAsStream(String.valueOf(prefix) + ruleFile);
                    if (xmlFile == null) {
                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Found"), String.valueOf(prefix) + ruleFile));
                        continue;
                    }
                    try {
                        try {
                            Document xmlDoc = FileHelper.getParsedDocument(xmlFile);
                            if (xmlDoc != null) {
                                HashSet<String> andRules = new HashSet<String>();
                                HashSet<Set<String>> orRules = new HashSet<Set<String>>();
                                HashSet<String> notRules = new HashSet<String>();
                                NodeList nl = xmlDoc.getElementsByTagName("group");
                                Node ruleNode = nl.item(0);
                                String techName = ruleNode.getAttributes().getNamedItem("id").getNodeValue();
                                Node supportNode = ruleNode.getAttributes().getNamedItem("support");
                                int[] support = SupportConstants.ALL_PROFILES;
                                if (supportNode != null) {
                                    String supportStr = supportNode.getNodeValue();
                                    support = SupportConstants.getSupportConstant(supportStr);
                                }
                                String referredToAs = null;
                                Node referredToAsNode = ruleNode.getAttributes().getNamedItem("referredToAs");
                                if (referredToAsNode != null) {
                                    referredToAs = referredToAsNode.getNodeValue();
                                }
                                this.loadTechRules(ruleNode, andRules, orRules, notRules);
                                ReportRow row = new ReportRow(techName, referredToAs, support, orRules, andRules, notRules);
                                header.addRow(row);
                            } else {
                                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Valid"), String.valueOf(prefix) + ruleFile));
                            }
                        }
                        catch (Exception e) {
                            if (ReportUtility.isDebug()) {
                                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Loaded_Log"), String.valueOf(prefix) + ruleFile), e);
                            } else {
                                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Loaded"), String.valueOf(prefix) + ruleFile, e.getLocalizedMessage()));
                            }
                            try {
                                xmlFile.close();
                            }
                            catch (IOException e2) {
                                if (!ReportUtility.isDebug()) continue;
                                ReportUtility.logger.get().log(Level.WARNING, "File not closed: " + ruleFile, e2);
                            }
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        block22: {
                            try {
                                xmlFile.close();
                            }
                            catch (IOException e) {
                                if (!ReportUtility.isDebug()) break block22;
                                ReportUtility.logger.get().log(Level.WARNING, "File not closed: " + ruleFile, e);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        xmlFile.close();
                    }
                    catch (IOException e) {
                        if (!ReportUtility.isDebug()) continue;
                        ReportUtility.logger.get().log(Level.WARNING, "File not closed: " + ruleFile, e);
                    }
                }
            }
            ++i;
        }
        factory.calculateListOfTechnologies(headers);
    }

    protected Map<String, List<String>> getNamesOfXmlRuleFiles(String reportList, List<String> headers) {
        HashMap<String, List<String>> filesByHeader = new HashMap<String, List<String>>();
        InputStream xmlFile = this.getClass().getResourceAsStream(reportList);
        if (xmlFile == null) {
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Found"), reportList));
            return filesByHeader;
        }
        try {
            try {
                Document xmlDoc = FileHelper.getParsedDocument(xmlFile);
                if (xmlDoc != null) {
                    NodeList nl = xmlDoc.getElementsByTagName("report");
                    Node ruleNode = nl.item(0);
                    Element ruleElement = (Element)ruleNode;
                    this.loadRules(ruleElement);
                    NodeList children = ruleElement.getElementsByTagName("header");
                    int numHeaders = children.getLength();
                    String id = null;
                    int i = 0;
                    while (i < numHeaders) {
                        Element firstChild = (Element)children.item(i);
                        id = firstChild.getAttributes().getNamedItem("id").getNodeValue();
                        headers.add(id);
                        ArrayList<String> fileNames = new ArrayList<String>();
                        NodeList files = firstChild.getElementsByTagName("group");
                        int numFiles = files.getLength();
                        String fileName = null;
                        int j = 0;
                        while (j < numFiles) {
                            Element firstFile = (Element)files.item(j);
                            fileName = firstFile.getAttributes().getNamedItem("fileName").getNodeValue();
                            if (fileName != null) {
                                fileNames.add(fileName);
                            }
                            ++j;
                        }
                        filesByHeader.put(id, fileNames);
                        ++i;
                    }
                } else {
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Valid"), reportList));
                }
            }
            catch (Exception e) {
                if (ReportUtility.isDebug()) {
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Loaded_Log"), reportList), e);
                } else {
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Loaded"), reportList, e.getLocalizedMessage()));
                }
                try {
                    xmlFile.close();
                }
                catch (IOException e2) {
                    if (ReportUtility.isDebug()) {
                        ReportUtility.logger.get().log(Level.WARNING, "File not closed: " + reportList, e2);
                    }
                }
            }
        }
        finally {
            block21: {
                try {
                    xmlFile.close();
                }
                catch (IOException e) {
                    if (!ReportUtility.isDebug()) break block21;
                    ReportUtility.logger.get().log(Level.WARNING, "File not closed: " + reportList, e);
                }
            }
        }
        return filesByHeader;
    }

    protected void loadRules(Element parent) {
        ArrayList<String> fileNames = new ArrayList<String>();
        NodeList ruleFileElements = parent.getElementsByTagName("rules");
        int numRuleFiles = ruleFileElements.getLength();
        String fileName = null;
        int i = 0;
        while (i < numRuleFiles) {
            Element firstChild = (Element)ruleFileElements.item(i);
            fileName = firstChild.getAttributes().getNamedItem("fileName").getNodeValue();
            fileNames.add(fileName);
            ++i;
        }
        for (String nextRuleFileName : fileNames) {
            this.loadList(nextRuleFileName, null, ListType.Analysis);
        }
    }

    protected String loadRule(Node ruleNode, String mainCategory, String secondaryCategory, StringBuilder desc, boolean userDefinedRule) {
        String ruleId = null;
        Node idAttr = ruleNode.getAttributes().getNamedItem("id");
        if (idAttr != null) {
            ruleId = idAttr.getNodeValue();
            if (userDefinedRule && !ruleId.startsWith("userDefined_")) {
                ruleId = "userDefined_" + ruleId;
            }
        }
        if (this.isExcludedRule(ruleId)) {
            return null;
        }
        return ruleId;
    }

    protected String loadCustomRule(String className, String mainCategory, String secondaryCategory, StringBuilder desc) {
        String ruleId = className.substring(className.lastIndexOf(46) + 1);
        if (this.isExcludedRule(ruleId)) {
            return null;
        }
        return ruleId;
    }

    protected boolean isExcludedRule(String ruleID) {
        if (this._excludedRuleList != null && !this._excludedRuleList.isEmpty()) {
            for (String ruleName : this._excludedRuleList) {
                if (!ruleName.equals(ruleID)) continue;
                ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Exclude_RuleName"), ruleName));
                return true;
            }
        }
        return false;
    }

    protected Set<String> getRuleIds(String id) {
        Set<String> returnIds;
        Set<String> ruleIds = Constants.RULE_ID_MAPPING.get(id);
        if (ruleIds != null) {
            returnIds = ruleIds;
        } else {
            ReportUtility.logger.get().log(Level.FINEST, "Rule id not found in map: " + id);
            returnIds = new HashSet<String>();
            returnIds.add(id);
        }
        return returnIds;
    }

    public void setReturnCode(int rc) {
        if (this.returnCode == 0) {
            this.returnCode = rc;
        }
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    protected void loadTechRules(Node ruleNode, Set<String> andRules, Set<Set<String>> orRules, Set<String> notRules) {
        Node nextChild = ruleNode.getFirstChild();
        while (nextChild != null) {
            if (nextChild.getNodeType() == 1) {
                Element nextEl = (Element)nextChild;
                if (nextEl.getTagName().equals("detectRule")) {
                    String id = nextChild.getAttributes().getNamedItem("id").getNodeValue();
                    if (this._ruleIds.contains(id)) {
                        andRules.addAll(this.getRuleIds(id));
                    } else {
                        ReportUtility.logger.get().log(Level.FINEST, "Rule not found by id: " + id);
                    }
                } else if (nextEl.getTagName().equals("or")) {
                    HashSet<String> oneOrRuleGroup = new HashSet<String>();
                    this.loadRules(nextChild, oneOrRuleGroup);
                    orRules.add(oneOrRuleGroup);
                } else if (nextEl.getTagName().equals("not")) {
                    this.loadRules(nextChild, notRules);
                }
            }
            nextChild = nextChild.getNextSibling();
        }
    }

    protected void loadRules(Node ruleNode, Set<String> groupOfRules) {
        Node nextChild = ruleNode.getFirstChild();
        while (nextChild != null) {
            Element nextEl;
            if (nextChild.getNodeType() == 1 && (nextEl = (Element)nextChild).getTagName().equals("detectRule")) {
                String id = nextChild.getAttributes().getNamedItem("id").getNodeValue();
                if (this._ruleIds.contains(id)) {
                    groupOfRules.addAll(this.getRuleIds(id));
                } else {
                    ReportUtility.logger.get().log(Level.FINEST, "Rule not found by id: " + id);
                }
            }
            nextChild = nextChild.getNextSibling();
        }
    }

    public File getFileFromRelativePath(String path) {
        File file;
        block28: {
            file = null;
            InputStream initialStream = null;
            OutputStream outStream = null;
            try {
                try {
                    initialStream = this.getClass().getResourceAsStream(path);
                    byte[] buffer = new byte[initialStream.available()];
                    initialStream.read(buffer);
                    file = File.createTempFile(path, null);
                    outStream = new FileOutputStream(file);
                    outStream.write(buffer);
                    outStream.close();
                }
                catch (Exception e) {
                    if (ReportUtility.isDebug()) {
                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Loaded_Log"), path), e);
                    } else {
                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Loaded"), path, e.getLocalizedMessage()));
                    }
                    if (initialStream != null) {
                        try {
                            initialStream.close();
                        }
                        catch (IOException iOException) {}
                    } else if (outStream != null) {
                        try {
                            outStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block28;
                }
            }
            catch (Throwable throwable) {
                if (initialStream != null) {
                    try {
                        initialStream.close();
                    }
                    catch (IOException iOException) {}
                } else if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (initialStream != null) {
                try {
                    initialStream.close();
                }
                catch (IOException iOException) {}
            } else if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return file;
    }

    public String loadOneRule(String fileName, String helpFile) {
        return this.loadOneRule(fileName, helpFile, null, null, RuleSeverity.NONE, null, ListType.Analysis);
    }

    public String loadOneCustomRule(String className, String helpFile, String mainCategory, String secondaryCategory, RuleSeverity ruleSeverity, RuleInfo costEntry) {
        StringBuilder ruleDesc = new StringBuilder();
        String ruleId = this.loadCustomRule(className, mainCategory, secondaryCategory, ruleDesc);
        if (ruleId != null) {
            SortedSet<Object> ruleIds;
            if (helpFile != null) {
                this._helpIds.put(ruleId, helpFile);
            }
            if (costEntry != null) {
                this._costs.put(ruleId, costEntry);
            }
            this._severities.put(ruleId, ruleSeverity);
            String desc = ruleDesc.toString();
            if (!this._descToRuleIds.containsKey(desc)) {
                ruleIds = new TreeSet();
                this._descToRuleIds.put(desc, ruleIds);
            } else {
                ruleIds = this._descToRuleIds.get(desc);
            }
            ruleIds.add(ruleId);
            this._ruleIds.add(ruleId);
        } else {
            ReportUtility.logger.get().log(Level.FINEST, "Rule file not loaded: " + className);
        }
        return ruleId;
    }

    public boolean isValidRule(File rule, ListType listType) {
        boolean rulesValid;
        block38: {
            rulesValid = true;
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL schemaResource = null;
            String schemaType = null;
            switch (listType) {
                case Analysis: 
                case Evaluate: 
                case Inventory: {
                    schemaType = "/rules/binary-scanner-rule_1_0.xsd";
                    schemaResource = this.getClass().getResource("/rules/binary-scanner-rule_1_0.xsd");
                    break;
                }
                case FeatureList: {
                    schemaType = "/rules/binary-scanner-config-rule_1_0.xsd";
                    schemaResource = this.getClass().getResource("/rules/binary-scanner-config-rule_1_0.xsd");
                }
            }
            String fileName = rule.getName();
            if (schemaResource != null) {
                try {
                    FileInputStream fis;
                    block37: {
                        Schema schema = factory.newSchema(schemaResource);
                        Validator validator = schema.newValidator();
                        fis = null;
                        try {
                            try {
                                fis = new FileInputStream(rule);
                                StreamSource ruleFile = new StreamSource(fis);
                                try {
                                    validator.validate(ruleFile);
                                }
                                catch (SAXException e) {
                                    ReportUtility.logger.get().log(Level.FINE, "Failed to validate rule when read with UTF-8 encoding. Trying to read with IBM-1047 encoding.", e);
                                    StreamSource in = new StreamSource(new StringReader(ReportUtility.getFileStringEbcdic(new FileInputStream(rule))));
                                    try {
                                        validator.validate(in);
                                    }
                                    catch (SAXException ex) {
                                        rulesValid = false;
                                        if (ReportUtility.isDebug()) {
                                            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Loaded_Log"), fileName), ex);
                                        } else {
                                            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Loaded"), fileName, ex.getLocalizedMessage()));
                                        }
                                    }
                                    catch (IOException ex) {
                                        rulesValid = false;
                                        if (ReportUtility.isDebug()) {
                                            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Loaded_Log"), fileName), ex);
                                            break block37;
                                        }
                                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Loaded"), fileName, ex.getLocalizedMessage()));
                                    }
                                }
                                catch (IOException e) {
                                    rulesValid = false;
                                    if (ReportUtility.isDebug()) {
                                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Loaded_Log"), fileName), e);
                                        break block37;
                                    }
                                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Loaded"), fileName, e.getLocalizedMessage()));
                                }
                            }
                            catch (Exception e) {
                                rulesValid = false;
                                if (ReportUtility.isDebug()) {
                                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Loaded_Log"), fileName), e);
                                } else {
                                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Loaded"), fileName, e.getLocalizedMessage()));
                                }
                                try {
                                    if (fis != null) {
                                        fis.close();
                                    }
                                    break block38;
                                }
                                catch (Exception e2) {
                                    ReportUtility.logger.get().log(Level.FINE, "Exception closing FileInputStream: ", e2);
                                }
                                break block38;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                if (fis != null) {
                                    fis.close();
                                }
                            }
                            catch (Exception e) {
                                ReportUtility.logger.get().log(Level.FINE, "Exception closing FileInputStream: ", e);
                            }
                            throw throwable;
                        }
                    }
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (Exception e) {
                        ReportUtility.logger.get().log(Level.FINE, "Exception closing FileInputStream: ", e);
                    }
                }
                catch (SAXException e) {
                    rulesValid = false;
                    if (ReportUtility.isDebug()) {
                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_Schema_File_Could_Not_Be_Loaded_Log"), schemaType), e);
                        break block38;
                    }
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_Schema_File_Could_Not_Be_Loaded"), schemaType, e.getLocalizedMessage()));
                }
                catch (NullPointerException e) {
                    rulesValid = false;
                    if (ReportUtility.isDebug()) {
                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_Schema_File_Could_Not_Be_Loaded_Log"), schemaType), e);
                        break block38;
                    }
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_Schema_File_Could_Not_Be_Loaded_Log"), schemaType));
                }
            } else {
                rulesValid = false;
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_Schema_File_Not_Found"), schemaType, fileName));
            }
        }
        if (!rulesValid) {
            this._foundInvalidRule = true;
        }
        return rulesValid;
    }

    public boolean loadList(String fileName, Set<String> ruleIdLoaded, ListType listType) {
        boolean listLoaded = false;
        File tmpListFile = this.getFileFromRelativePath(fileName);
        File listFile = new File(fileName);
        if (tmpListFile == null) {
            return false;
        }
        try {
            String prefix = "";
            int index = fileName.lastIndexOf(47);
            if (index > -1) {
                prefix = fileName.substring(0, index + 1);
            }
            if (!this.loadedLists.contains(listFile)) {
                listLoaded = this.loadList(tmpListFile, ruleIdLoaded, prefix, listType);
                this.loadedLists.add(listFile);
                if (this.currentCategory != null) {
                    this.mapOfListToCategory.put(listFile, this.currentCategory);
                }
            } else if (this.currentCategory != null) {
                this.currentCategories.add(this.mapOfListToCategory.get(listFile));
            }
        }
        finally {
            tmpListFile.delete();
        }
        return listLoaded;
    }

    public boolean loadList(File ruleListFile, Set<String> ruleIdLoaded, String prefix, ListType listType) {
        boolean rulesValid = false;
        String fileName = ruleListFile.getName();
        if (!fileName.endsWith(".tmp") || !this.loadedLists.contains(ruleListFile)) {
            HashSet<String> loadedRuleNames;
            block45: {
                boolean userDefinedRule = false;
                rulesValid = this.isValidList(ruleListFile, listType);
                loadedRuleNames = new HashSet<String>();
                if (rulesValid) {
                    FileInputStream xmlFile;
                    block44: {
                        int index;
                        String absolutePath = ruleListFile.getAbsolutePath();
                        String relativePath = absolutePath.replace(String.valueOf(File.separator) + fileName, "");
                        if (prefix == null) {
                            prefix = "";
                            userDefinedRule = true;
                        }
                        if ((index = fileName.lastIndexOf(47)) > -1) {
                            prefix = fileName.substring(0, index + 1);
                        }
                        xmlFile = null;
                        try {
                            xmlFile = new FileInputStream(ruleListFile);
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                        if (xmlFile == null) {
                            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Found"), fileName));
                        }
                        try {
                            try {
                                Document xmlDoc = FileHelper.getParsedDocument(xmlFile);
                                if (xmlDoc != null) {
                                    NodeList rulesNodeList = xmlDoc.getElementsByTagName("rules");
                                    Element rulesElement = (Element)rulesNodeList.item(0);
                                    NamedNodeMap rulesAttrs = rulesElement.getAttributes();
                                    String mainCategory = null;
                                    String secondaryCategory = null;
                                    if (rulesAttrs != null) {
                                        Node secondaryCategoryNode;
                                        Node mainCategoryNode = rulesAttrs.getNamedItem("mainCategory");
                                        if (mainCategoryNode != null) {
                                            mainCategory = mainCategoryNode.getNodeValue();
                                        }
                                        if ((secondaryCategoryNode = rulesAttrs.getNamedItem("secondaryCategory")) != null) {
                                            secondaryCategory = secondaryCategoryNode.getNodeValue();
                                        }
                                    }
                                    ArrayList<String> classFileNames = new ArrayList<String>();
                                    ArrayList<String> ruleFileNames = new ArrayList<String>();
                                    HashMap<String, String> helpFileNames = new HashMap<String, String>();
                                    HashMap<String, RuleInfo> costs = new HashMap<String, RuleInfo>();
                                    HashMap<String, RuleSeverity> ruleSeverities = new HashMap<String, RuleSeverity>();
                                    String ruleFileName = null;
                                    NodeList nl = xmlDoc.getElementsByTagName("rule");
                                    int length = nl.getLength();
                                    int i = 0;
                                    while (i < length) {
                                        String prefixPath = null;
                                        try {
                                            Node severityNode;
                                            Element childElement = (Element)nl.item(i);
                                            NamedNodeMap attrs = childElement.getAttributes();
                                            Node ruleFileNameNode = attrs.getNamedItem("fileName");
                                            if (ruleFileNameNode != null) {
                                                ruleFileName = ruleFileNameNode.getNodeValue();
                                                prefixPath = ruleFileName.startsWith("\\") || ruleFileName.startsWith("/") ? ruleFileName : String.valueOf(prefix) + ruleFileName;
                                                ruleFileNames.add(prefixPath);
                                            } else {
                                                ruleFileNameNode = attrs.getNamedItem("className");
                                                if (ruleFileNameNode != null) {
                                                    ruleFileName = ruleFileNameNode.getNodeValue();
                                                    classFileNames.add(ruleFileName);
                                                    prefixPath = String.valueOf(prefix) + ruleFileName;
                                                } else {
                                                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Report_List_Rule_Not_Valid"), i + 1, fileName));
                                                }
                                            }
                                            Node helpFileNode = attrs.getNamedItem("help");
                                            if (helpFileNode != null) {
                                                String helpPathStr;
                                                File path;
                                                String helpPath = userDefinedRule ? ((path = new File(helpPathStr = helpFileNode.getNodeValue())).isAbsolute() ? helpPathStr : String.valueOf(relativePath) + File.separator + helpPathStr) : helpFileNode.getNodeValue();
                                                helpFileNames.put(prefixPath, helpPath);
                                            }
                                            Node devCostNode = attrs.getNamedItem("devCost");
                                            Node instanceCostNode = attrs.getNamedItem("instanceCost");
                                            Node complexityNode = attrs.getNamedItem("complexity");
                                            if (devCostNode != null || instanceCostNode != null || complexityNode != null) {
                                                float devCostValue = 0.0f;
                                                if (devCostNode != null) {
                                                    devCostValue = Float.parseFloat(devCostNode.getNodeValue());
                                                }
                                                float instanceCostValue = 0.0f;
                                                if (instanceCostNode != null) {
                                                    instanceCostValue = Float.parseFloat(instanceCostNode.getNodeValue());
                                                }
                                                String complexityValue = null;
                                                if (complexityNode != null) {
                                                    complexityValue = complexityNode.getNodeValue();
                                                }
                                                RuleInfo costEntry = new RuleInfo();
                                                costEntry.devCost = devCostValue;
                                                costEntry.instanceCost = instanceCostValue;
                                                costEntry.complexity = complexityValue;
                                                costs.put(prefixPath, costEntry);
                                            }
                                            if ((severityNode = attrs.getNamedItem("severity")) != null) {
                                                ruleSeverities.put(prefixPath, RuleSeverity.getRuleSeverity(severityNode.getNodeValue()));
                                            } else {
                                                ruleSeverities.put(prefixPath, RuleSeverity.NONE);
                                            }
                                        }
                                        catch (Exception e) {
                                            if (ReportUtility.isDebug()) {
                                                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Report_List_Rule_Not_Loaded_Log"), i + 1, fileName), e);
                                            }
                                            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Report_List_Rule_Not_Loaded"), i + 1, fileName, e.getLocalizedMessage()));
                                        }
                                        ++i;
                                    }
                                    Iterator iterator = ruleFileNames.iterator();
                                    while (iterator.hasNext()) {
                                        String thisRuleFileName;
                                        String rulePath = userDefinedRule ? String.valueOf(relativePath) + File.separator + thisRuleFileName : thisRuleFileName;
                                        String ruleName = this.loadOneRule(rulePath, (String)helpFileNames.get(thisRuleFileName = (String)iterator.next()), mainCategory, secondaryCategory, (RuleSeverity)((Object)ruleSeverities.get(thisRuleFileName)), (RuleInfo)costs.get(thisRuleFileName), listType, userDefinedRule);
                                        if (ruleName == null) continue;
                                        loadedRuleNames.add(ruleName);
                                    }
                                    for (String thisRuleFileName : classFileNames) {
                                        String ruleName = this.loadOneCustomRule(thisRuleFileName, (String)helpFileNames.get(String.valueOf(prefix) + thisRuleFileName), mainCategory, secondaryCategory, (RuleSeverity)((Object)ruleSeverities.get(String.valueOf(prefix) + thisRuleFileName)), (RuleInfo)costs.get(String.valueOf(prefix) + thisRuleFileName));
                                        if (ruleName == null) continue;
                                        loadedRuleNames.add(ruleName);
                                    }
                                    if (!fileName.endsWith(".tmp")) {
                                        this.loadedLists.add(ruleListFile);
                                        this.mapOfListToCategory.put(ruleListFile, this.currentCategory);
                                    }
                                    break block44;
                                }
                                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Valid"), fileName));
                            }
                            catch (Exception e) {
                                if (ReportUtility.isDebug()) {
                                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Loaded_Log"), fileName), e);
                                } else {
                                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Loaded"), fileName, e.getLocalizedMessage()));
                                }
                                try {
                                    ((InputStream)xmlFile).close();
                                }
                                catch (IOException e2) {
                                    if (ReportUtility.isDebug()) {
                                        ReportUtility.logger.get().log(Level.FINEST, "Rule file not closed: " + fileName, e2);
                                    }
                                    break block45;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            block46: {
                                try {
                                    ((InputStream)xmlFile).close();
                                }
                                catch (IOException e) {
                                    if (!ReportUtility.isDebug()) break block46;
                                    ReportUtility.logger.get().log(Level.FINEST, "Rule file not closed: " + fileName, e);
                                }
                            }
                            throw throwable;
                        }
                    }
                    try {
                        ((InputStream)xmlFile).close();
                    }
                    catch (IOException e) {
                        if (!ReportUtility.isDebug()) break block45;
                        ReportUtility.logger.get().log(Level.FINEST, "Rule file not closed: " + fileName, e);
                    }
                }
            }
            if (ruleIdLoaded != null) {
                ruleIdLoaded.addAll(loadedRuleNames);
            }
        } else {
            this.currentCategories.add(this.mapOfListToCategory.get(ruleListFile));
        }
        return rulesValid;
    }

    public boolean isValidList(File ruleListFile, ListType listType) {
        boolean rulesValid;
        block38: {
            rulesValid = true;
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL schemaResource = null;
            String schemaType = null;
            switch (listType) {
                case Analysis: 
                case Evaluate: 
                case Inventory: {
                    schemaType = "/rules/binary-scanner-rule-list_1_0.xsd";
                    schemaResource = this.getClass().getResource(schemaType);
                    break;
                }
                case FeatureList: {
                    schemaType = "/rules/binary-scanner-config-rule-list_1_0.xsd";
                    schemaResource = this.getClass().getResource(schemaType);
                }
            }
            String fileName = ruleListFile.getName();
            if (schemaResource != null) {
                try {
                    FileInputStream fis;
                    block37: {
                        Schema schema = factory.newSchema(schemaResource);
                        Validator validator = schema.newValidator();
                        File nextRule = ruleListFile;
                        fis = null;
                        try {
                            try {
                                fis = new FileInputStream(nextRule);
                                StreamSource ruleFile = new StreamSource(fis);
                                try {
                                    validator.validate(ruleFile);
                                }
                                catch (SAXException e) {
                                    ReportUtility.logger.get().log(Level.FINE, "Failed to validate rule list when read with UTF-8 encoding. Trying to read with IBM-1047 encoding.", e);
                                    StreamSource in = new StreamSource(new StringReader(ReportUtility.getFileStringEbcdic(new FileInputStream(nextRule))));
                                    try {
                                        validator.validate(in);
                                    }
                                    catch (SAXException ex) {
                                        rulesValid = false;
                                        if (ReportUtility.isDebug()) {
                                            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_List_File_Not_Loaded_Log"), fileName), ex);
                                        } else {
                                            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_List_File_Not_Loaded"), fileName, ex.getLocalizedMessage()));
                                        }
                                    }
                                    catch (IOException ex) {
                                        rulesValid = false;
                                        if (ReportUtility.isDebug()) {
                                            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_List_File_Not_Loaded_Log"), fileName), ex);
                                            break block37;
                                        }
                                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_List_File_Not_Loaded"), fileName, ex.getLocalizedMessage()));
                                    }
                                }
                                catch (IOException e) {
                                    rulesValid = false;
                                    if (ReportUtility.isDebug()) {
                                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_List_File_Not_Loaded_Log"), fileName), e);
                                        break block37;
                                    }
                                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_List_File_Not_Loaded"), fileName, e.getLocalizedMessage()));
                                }
                            }
                            catch (Exception e) {
                                rulesValid = false;
                                if (ReportUtility.isDebug()) {
                                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_List_File_Not_Loaded_Log"), fileName), e);
                                } else {
                                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_List_File_Not_Loaded"), fileName, e.getLocalizedMessage()));
                                }
                                try {
                                    if (fis != null) {
                                        fis.close();
                                    }
                                    break block38;
                                }
                                catch (Exception e2) {
                                    ReportUtility.logger.get().log(Level.FINE, "Exception closing FileInputStream: ", e2);
                                }
                                break block38;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                if (fis != null) {
                                    fis.close();
                                }
                            }
                            catch (Exception e) {
                                ReportUtility.logger.get().log(Level.FINE, "Exception closing FileInputStream: ", e);
                            }
                            throw throwable;
                        }
                    }
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (Exception e) {
                        ReportUtility.logger.get().log(Level.FINE, "Exception closing FileInputStream: ", e);
                    }
                }
                catch (SAXException e) {
                    rulesValid = false;
                    if (ReportUtility.isDebug()) {
                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_Schema_File_Could_Not_Be_Loaded_Log"), schemaType), e);
                        break block38;
                    }
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_Schema_File_Could_Not_Be_Loaded"), schemaType, e.getLocalizedMessage()));
                }
                catch (NullPointerException e) {
                    rulesValid = false;
                    if (ReportUtility.isDebug()) {
                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_Schema_File_Could_Not_Be_Loaded_Log"), schemaType), e);
                        break block38;
                    }
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_Schema_File_Could_Not_Be_Loaded_Log"), schemaType));
                }
            } else {
                rulesValid = false;
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_List_Schema_File_Not_Found"), schemaType, ruleListFile.getAbsolutePath()));
            }
        }
        if (!rulesValid) {
            this._foundInvalidRule = true;
        }
        return rulesValid;
    }

    public String loadOneRule(String fileName, String helpFile, String mainCategory, String secondaryCategory, RuleSeverity ruleSeverity, RuleInfo costEntry, ListType listType) {
        return this.loadOneRule(fileName, helpFile, mainCategory, secondaryCategory, ruleSeverity, costEntry, listType, false);
    }

    public String loadOneRule(String fileName, String helpFile, String mainCategory, String secondaryCategory, RuleSeverity ruleSeverity, RuleInfo costEntry, ListType listType, boolean userDefinedRule) {
        String ruleName;
        block10: {
            File ruleFile = null;
            ruleName = null;
            try {
                ruleFile = !userDefinedRule ? this.getFileFromRelativePath(fileName) : new File(fileName);
                if (!this.isValidRule(ruleFile, listType)) break block10;
                InputStream ruleIS = null;
                if (!userDefinedRule) {
                    ruleIS = this.getClass().getResourceAsStream(fileName);
                } else {
                    try {
                        ruleIS = new FileInputStream(fileName);
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                }
                if (ruleIS == null) {
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Found"), fileName));
                } else {
                    ruleName = this.loadRuleFromInputStream(ruleIS, fileName, mainCategory, secondaryCategory, helpFile, ruleSeverity, costEntry, userDefinedRule);
                }
            }
            finally {
                if (ruleFile != null && !userDefinedRule) {
                    ruleFile.delete();
                }
            }
        }
        return ruleName;
    }

    public String loadRuleFromInputStream(InputStream ruleFile, String fileName, String mainCategory, String secondaryCategory, String helpFile, RuleSeverity ruleSeverity, RuleInfo costEntry, boolean userDefinedRule) {
        String ruleName = null;
        try {
            try {
                Document thisDoc = FileHelper.getParsedDocument(ruleFile);
                if (thisDoc != null) {
                    NodeList ruleElements = thisDoc.getElementsByTagName("rule");
                    int numRuleElements = ruleElements.getLength();
                    if (numRuleElements == 0) {
                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Valid"), fileName));
                    }
                    int i = 0;
                    while (i < numRuleElements) {
                        StringBuilder ruleDesc;
                        Node ruleNode = ruleElements.item(i);
                        ruleName = this.loadRule(ruleNode, mainCategory, secondaryCategory, ruleDesc = new StringBuilder(), userDefinedRule);
                        if (ruleName != null) {
                            SortedSet<Object> ruleIds;
                            if (helpFile != null) {
                                this._helpIds.put(ruleName, helpFile);
                            }
                            if (costEntry != null) {
                                this._costs.put(ruleName, costEntry);
                            }
                            this._severities.put(ruleName, ruleSeverity);
                            String desc = ruleDesc.toString();
                            if (!this._descToRuleIds.containsKey(desc)) {
                                ruleIds = new TreeSet();
                                this._descToRuleIds.put(desc, ruleIds);
                            } else {
                                ruleIds = this._descToRuleIds.get(desc);
                            }
                            ruleIds.add(ruleName);
                            this._ruleIds.add(ruleName);
                        } else {
                            ReportUtility.logger.get().log(Level.FINEST, "Rule file not loaded: " + fileName);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                if (ReportUtility.isDebug()) {
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Loaded"), fileName), e);
                } else {
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Rule_File_Not_Loaded"), fileName, e.getLocalizedMessage()));
                }
                try {
                    ruleFile.close();
                }
                catch (IOException e2) {
                    if (ReportUtility.isDebug()) {
                        ReportUtility.logger.get().log(Level.FINEST, "Rule file not closed: " + fileName, e2);
                    }
                }
            }
        }
        finally {
            block24: {
                try {
                    ruleFile.close();
                }
                catch (IOException e) {
                    if (!ReportUtility.isDebug()) break block24;
                    ReportUtility.logger.get().log(Level.FINEST, "Rule file not closed: " + fileName, e);
                }
            }
        }
        return ruleName;
    }

    public static enum ListType {
        Analysis,
        Evaluate,
        FeatureList,
        Inventory;

    }
}

