/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom.inventory;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.binary.utilities.Constants;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class WebSphereImplementation
extends DetectFile {
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.java.WebSphereImplementations";
    protected static final Pattern[] classFile = new Pattern[]{Constants.CLASS_FILE_REG};
    protected static final Pattern[] implementations = new Pattern[]{Pattern.compile("^com\\.ibm\\.(?:websphere\\.(?!samples\\.)|ws\\.).*")};
    protected Map<String, List<String>> mapOfArchivesToFlag = new HashMap<String, List<String>>();

    public WebSphereImplementation() {
        this("WebSphereImplementation", RULE_DESC, classFile, false);
    }

    public WebSphereImplementation(String ruleName, String desc, Pattern[] files, boolean flagOnce) {
        super(ruleName, desc, files, flagOnce);
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.mapOfArchivesToFlag.clear();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        List<String> locations;
        Set<String> matches = store.getMatchingFileNames(classFile[0], false, true);
        Pattern websphereImplentations = implementations[0];
        for (String key : matches) {
            String packageName = ReportUtility.getPackage(key);
            if (packageName == null) continue;
            String archiveName = ReportUtility.getArchiveNamePath(key);
            if (!websphereImplentations.matcher(packageName).matches() || !this.shouldFlag(packageName, archiveName)) continue;
            if (this.mapOfArchivesToFlag.containsKey(packageName)) {
                locations = this.mapOfArchivesToFlag.get(packageName);
                locations.add(archiveName);
                continue;
            }
            locations = new ArrayList<String>();
            locations.add(archiveName);
            this.mapOfArchivesToFlag.put(packageName, locations);
        }
        StringBuilder sb = null;
        for (String key : this.mapOfArchivesToFlag.keySet()) {
            locations = this.mapOfArchivesToFlag.get(key);
            Collections.sort(locations);
            for (String name2 : locations) {
                if (sb == null) {
                    sb = new StringBuilder(name2);
                    continue;
                }
                sb.append(",");
                sb.append(name2);
            }
            this.detailResults.add(new DetailResult(this.ruleName, null, this.ruleDescription, sb.toString(), 1, key, 0));
            sb = null;
        }
    }

    public static List<Pattern> getWSPackages() {
        return Arrays.asList(implementations);
    }

    public boolean shouldFlag(String packageName, String archiveName) {
        List<String> archiveNames = this.mapOfArchivesToFlag.get(packageName);
        return archiveNames == null || !archiveNames.contains(archiveName);
    }
}

