/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom.inventory;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class DetectExcessResourcesInWebModule
extends DetectFile {
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.java.DetectExcessResourcesInWebModule";
    Map<String, Integer> webModuleResourceTotalsPerArchive = new HashMap<String, Integer>();
    protected static final Pattern[] resourceFileInWebModule = new Pattern[]{Pattern.compile(".*\\.war/.*\\.(html|htm|png|jpg|jpeg|tif|tiff|gif|pdf|jif|jiff|pcd|jp2|jpx|j2k|j2c|exr)$")};

    public DetectExcessResourcesInWebModule() {
        this("DetectExcessResourcesInWebModule", RULE_DESC, resourceFileInWebModule, false);
    }

    public DetectExcessResourcesInWebModule(String ruleName, String desc, Pattern[] files, boolean flagOnce) {
        super(ruleName, desc, files, flagOnce);
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.webModuleResourceTotalsPerArchive.clear();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        Set<String> matches = store.getMatchingFileNames(resourceFileInWebModule[0], true, true);
        if (matches.size() > 0) {
            String topArchiveName = ReportUtility.getFirstArchiveName(matches.iterator().next());
            if (topArchiveName.endsWith(".ear")) {
                for (String match : matches) {
                    if (!(match = ReportUtility.getLastArchiveFileName(match)).endsWith(".war")) continue;
                    int count = this.webModuleResourceTotalsPerArchive.containsKey(match) ? this.webModuleResourceTotalsPerArchive.get(match) : 0;
                    this.webModuleResourceTotalsPerArchive.put(match, count + 1);
                }
            } else {
                this.webModuleResourceTotalsPerArchive.put(topArchiveName, matches.size());
            }
            int excessiveWebModuleResourceThreshold = store.getHiddenJunitFlag() ? 10 : 100000;
            for (String archiveName : this.webModuleResourceTotalsPerArchive.keySet()) {
                int excessWebModuleResourceTotal = this.webModuleResourceTotalsPerArchive.get(archiveName);
                if (excessWebModuleResourceTotal <= excessiveWebModuleResourceThreshold) continue;
                String fileTotal = Integer.toString(excessWebModuleResourceTotal);
                this.detailResults.add(new DetailResult("DetectExcessResourcesInWebModule", archiveName, null, fileTotal));
            }
        }
    }
}

