/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom.inventory;

import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class CountSpringBeans
extends DetectAnnotation {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule, RuleType.XmlRule);
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.java.SpringBeans";
    protected static final String SPRING_BEAN = "org.springframework.context.annotation.Bean";
    protected static final String[] classNames = new String[]{"org.springframework.context.annotation.Bean"};
    protected static final String BEAN_TAG = "bean";
    protected static final String CLASS_ATTRIBUTE = "class";
    protected static final String[] tags = new String[]{"bean"};
    protected static final String BEANS_FILE = "(.*/)?.+\\.xml";
    protected static final String[] allXmlFileName = new String[]{"(.*/)?.+\\.xml"};
    protected static final String SPRING_JAR_REGEX_IGNORE = ".*/spring.*\\.jar/org/springframework/.*";
    protected static final String WAR = ".war";
    protected static final String JAR = ".jar";
    protected DetectElement _xmlSpringBeans = null;
    protected Map<String, Set<String>> xmlClassToAnnotationClassNames = new HashMap<String, Set<String>>();
    protected List<DetailResult> xmlDefinedBeanResults = new ArrayList<DetailResult>();
    protected Map<String, String> _fileNameToClassName = new HashMap<String, String>();

    public CountSpringBeans() {
        this("CountSpringBeans", RULE_DESC, classNames, null, null, null, null, null, false, null, null, null);
    }

    public CountSpringBeans(String ruleName, String desc, String[] classNames, String attributeName, String attributeType, String[] attributeValues, String defaultValue, String accessFlag, boolean flagOnce, String location, String defaultName, String missingAttributeName) {
        super(ruleName, desc, classNames, attributeName, attributeType, attributeValues, defaultValue, accessFlag, flagOnce, location, defaultName, missingAttributeName);
        this._xmlSpringBeans = new DetectElement("CountSpringBeans", RULE_DESC, tags, allXmlFileName, null, null, false, null, null, null, false, null, null, null, false, null, false){

            @Override
            protected boolean includeInResults(Node node, String fileName, XMLResource resource) {
                if (fileName.matches(CountSpringBeans.SPRING_JAR_REGEX_IGNORE)) {
                    return false;
                }
                String className = XMLRuleUtil.getAttributeOrChildNodeValue(node, CountSpringBeans.CLASS_ATTRIBUTE);
                if (className != null && !className.isEmpty()) {
                    CountSpringBeans.this.addClassToCollection(fileName, className, CountSpringBeans.this.xmlClassToAnnotationClassNames);
                    CountSpringBeans.this.xmlDefinedBeanResults.add(new DetailResult("CountSpringBeans", fileName, this.ruleDescription, String.valueOf(this.tags[0]) + "=" + className, 1, null, resource.getNodeLineNumber(node)));
                }
                return false;
            }
        };
    }

    protected void addClassToCollection(String fileName, String className, Map<String, Set<String>> xmlToClassNames) {
        if (xmlToClassNames.containsKey(fileName)) {
            Set<String> classes = xmlToClassNames.get(fileName);
            classes.add(className);
        } else {
            HashSet<String> classes = new HashSet<String>();
            classes.add(className);
            xmlToClassNames.put(fileName, classes);
        }
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        return allXmlFileName;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._xmlSpringBeans.clearResults();
        this._fileNameToClassName.clear();
        this.xmlClassToAnnotationClassNames.clear();
        this.xmlDefinedBeanResults = new ArrayList<DetailResult>();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._xmlSpringBeans.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> annoResults = super.getResults(store);
        Iterator<DetailResult> it = annoResults.iterator();
        while (it.hasNext()) {
            String xmlPath;
            Set<String> classes;
            DetailResult nextAnnoResult = it.next();
            String fileName = nextAnnoResult.getFileName();
            String annoClassName = this._fileNameToClassName.get(fileName);
            boolean flagToRemove = false;
            if (fileName.contains(WAR) && (classes = this.xmlClassToAnnotationClassNames.get(xmlPath = fileName.substring(0, fileName.lastIndexOf(WAR) + 4))) != null && classes.contains(annoClassName)) {
                flagToRemove = true;
            }
            if (!flagToRemove && fileName.contains(JAR) && (classes = this.xmlClassToAnnotationClassNames.get(xmlPath = fileName.substring(0, fileName.lastIndexOf(JAR) + 4))) != null && classes.contains(annoClassName)) {
                flagToRemove = true;
            }
            if (!flagToRemove) continue;
            it.remove();
        }
        annoResults.addAll(this.xmlDefinedBeanResults);
        return annoResults;
    }

    @Override
    protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
        boolean shouldScan = ReportUtility.shouldScanClassFileForRules(key);
        if (!shouldScan) {
            return false;
        }
        if (key.matches(SPRING_JAR_REGEX_IGNORE)) {
            return false;
        }
        this._fileNameToClassName.put(key, data.getClassName());
        return true;
    }
}

