/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UniqueEjbBindingNames
extends DetectElement {
    protected static final String RULE_NAME = "UniqueEjbBindingNames";
    protected static final String RULE_DESC = "appconversion.was2was.70.javaee5.EJB3UniqueNames";
    protected static final String[] fileNames = new String[]{"(.*/)?(META-INF|WEB-INF)/ibm-ejb-jar-bnd\\.xml"};
    protected static final String namespace = "*";
    protected static final String[] tags = new String[]{"ejb-jar-bnd"};
    private ArrayList<String> sessionAndMessageBeanNames = new ArrayList();
    private ArrayList<String> interceptorBeanNames = new ArrayList();
    private ArrayList<String> messageDestinaitonBeanNames = new ArrayList();
    private ArrayList<String> interfaceNames = new ArrayList();
    private ArrayList<String> ejbRefNames = new ArrayList();
    private ArrayList<String> resourceRefNames = new ArrayList();
    private ArrayList<String> resourceEnvRefNames = new ArrayList();
    private ArrayList<String> messageDestinationRefNames = new ArrayList();
    protected static final String sessionStr = "session";
    protected static final String messageDrivenStr = "message-driven";
    protected static final String interceptorStr = "interceptor";
    protected static final String messageDestinationStr = "message-destination";
    protected static final String interfaceStr = "interface";
    protected static final String ejbRefStr = "ejb-ref";
    protected static final String resourceRefStr = "resource-ref";
    protected static final String resourceEnvRefStr = "resource-env-ref";
    protected static final String messageDestinationRefStr = "message-destination-ref";

    public UniqueEjbBindingNames() {
        this(RULE_NAME, RULE_DESC, tags, fileNames, null, namespace, false, null, null, null, false);
    }

    public UniqueEjbBindingNames(String ruleName, String desc, String[] tags, String[] fileNames, String value, String namespace, boolean flagOnce, String docNamespace, String missingChildElement, String missingChildElementValue, boolean flagNotEmpty) {
        super(ruleName, desc, tags, fileNames, value, namespace, flagOnce, docNamespace, missingChildElement, missingChildElementValue, flagNotEmpty);
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.sessionAndMessageBeanNames.clear();
        this.interceptorBeanNames.clear();
        this.messageDestinaitonBeanNames.clear();
        this.interfaceNames.clear();
        this.ejbRefNames.clear();
        this.resourceRefNames.clear();
        this.resourceEnvRefNames.clear();
        this.messageDestinationRefNames.clear();
    }

    @Override
    protected boolean includeInResults(Node result, String key, XMLResource xmlResource) {
        this.sessionAndMessageBeanNames.clear();
        this.messageDestinaitonBeanNames.clear();
        this.interceptorBeanNames.clear();
        NodeList children = result.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            this.ejbRefNames.clear();
            this.resourceEnvRefNames.clear();
            this.resourceRefNames.clear();
            this.messageDestinationRefNames.clear();
            this.interfaceNames.clear();
            Node childNode = children.item(i);
            String localName = childNode.getLocalName();
            if (sessionStr.equals(localName) || messageDrivenStr.equals(localName)) {
                this.validateSessionAndMessageDrivenBeans(key, xmlResource, childNode);
            } else if (interceptorStr.equals(localName)) {
                this.validateInterceptors(key, xmlResource, childNode);
            } else if (messageDestinationStr.equals(localName)) {
                this.validateMessageDestinationBeans(key, xmlResource, childNode);
            }
            ++i;
        }
        return false;
    }

    private void validateSessionAndMessageDrivenBeans(String key, XMLResource xmlResource, Node childNode) {
        this.testNameUnique(key, xmlResource, childNode, this.sessionAndMessageBeanNames);
        NodeList subElements = childNode.getChildNodes();
        int j = 0;
        while (j < subElements.getLength()) {
            Node subNode = subElements.item(j);
            String childNodeLocalName = childNode.getLocalName();
            String subNodeLocalName = subNode.getLocalName();
            if (sessionStr.equals(childNodeLocalName) && interfaceStr.equals(subNodeLocalName)) {
                this.testClassUniqueAndFullyQualifiedName(key, xmlResource, subNode, this.interfaceNames);
            } else if (ejbRefStr.equals(subNodeLocalName)) {
                this.testNameUnique(key, xmlResource, subNode, this.ejbRefNames);
            } else if (resourceRefStr.equals(subNodeLocalName)) {
                this.testNameUnique(key, xmlResource, subNode, this.resourceRefNames);
            } else if (resourceEnvRefStr.equals(subNodeLocalName)) {
                this.testNameUnique(key, xmlResource, subNode, this.resourceEnvRefNames);
            } else if (messageDestinationRefStr.equals(subNodeLocalName)) {
                this.testNameUnique(key, xmlResource, subNode, this.messageDestinationRefNames);
            }
            ++j;
        }
    }

    private void testNameUnique(String key, XMLResource xmlResource, Node node, ArrayList<String> list) {
        NamedNodeMap map = node.getAttributes();
        Node nameNode = map.getNamedItem("name");
        if (nameNode != null) {
            String name2 = nameNode.getNodeValue();
            if (list.contains(name2)) {
                this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, node.getLocalName(), 1, null, xmlResource.getNodeLineNumber(node)));
            } else {
                list.add(name2);
            }
        }
    }

    private void testClassUniqueAndFullyQualifiedName(String key, XMLResource xmlResource, Node node, ArrayList<String> list) {
        NamedNodeMap map = node.getAttributes();
        Node classNode = map.getNamedItem("class");
        if (classNode != null) {
            String name2 = classNode.getNodeValue();
            if (!name2.contains(".")) {
                this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, node.getLocalName(), 1, null, xmlResource.getNodeLineNumber(node)));
            } else if (list.contains(name2)) {
                this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, node.getLocalName(), 1, null, xmlResource.getNodeLineNumber(node)));
            } else {
                list.add(name2);
            }
        }
    }

    private void validateInterceptors(String key, XMLResource xmlResource, Node node) {
        this.testClassUniqueAndFullyQualifiedName(key, xmlResource, node, this.interceptorBeanNames);
        NodeList subElements = node.getChildNodes();
        int j = 0;
        while (j < subElements.getLength()) {
            Node subNode = subElements.item(j);
            String subNodeLocalName = subNode.getLocalName();
            if (ejbRefStr.equals(subNodeLocalName)) {
                this.testNameUnique(key, xmlResource, subNode, this.ejbRefNames);
            } else if (resourceRefStr.equals(subNodeLocalName)) {
                this.testNameUnique(key, xmlResource, subNode, this.resourceRefNames);
            } else if (resourceEnvRefStr.equals(subNodeLocalName)) {
                this.testNameUnique(key, xmlResource, subNode, this.resourceEnvRefNames);
            } else if (messageDestinationRefStr.equals(subNodeLocalName)) {
                this.testNameUnique(key, xmlResource, subNode, this.messageDestinationRefNames);
            }
            ++j;
        }
    }

    private void validateMessageDestinationBeans(String key, XMLResource xmlResource, Node node) {
        this.testNameUnique(key, xmlResource, node, this.messageDestinaitonBeanNames);
    }
}

