/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectMethod;
import com.ibm.ws.report.binary.rules.DetectProperty;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.ArgumentDetail;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class RemoveWebLogicNonPortableJndiLookup
extends DetectMethod {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule, RuleType.PropertyRule, RuleType.XmlRule);
    protected static final String RULE_NAME = "RemoveWebLogicNonPortableJndiLookup";
    protected static final String RULE_DESC = "com.ibm.ws.appconversion.weblogic.rules.MigrateT3AndInitialContextFactory";
    private static final String WEBLOGIC_JNDI_INTCTX_FACTORY_VALUE_STR = "weblogic\\.jndi\\.WLInitialContextFactory";
    private static final String WEBLOGIC_URL_PROVIDER_VALUE_STR_T3 = "t3://.*";
    private static final String WEBLOGIC_URL_PROVIDER_VALUE_STR_T3S = "t3s://.*";
    protected static final String[] _methodNames = new String[]{"put", "<init>"};
    protected static final String[] _methodOwners = new String[]{"java.util.Hashtable", "javax.naming.InitialContext"};
    protected static final String[] _hashTablePutMethodName = new String[]{_methodNames[0]};
    protected static final String[] _hashTablePutOwner = new String[]{_methodOwners[0]};
    protected static final String _argHashTablePutTypes = "java.lang.Object, java.lang.Object";
    protected static List<ArgumentDetail> _argDetailHashTablePut = new ArrayList<ArgumentDetail>();
    protected static final String[] _constructorMethodName = new String[]{_methodNames[1]};
    protected static final String[] _initialContextConstructorOwner = new String[]{_methodOwners[1]};
    protected static final String _argConstructor = "java.util.Hashtable";
    protected static final String[] _propertyFileValues = new String[]{"weblogic\\.jndi\\.WLInitialContextFactory", "t3://.*", "t3s://.*"};
    protected static final String _propertyFiles = ".*\\.properties";
    protected static final String[] _xmlFiles = new String[]{".*/(?!weblogic)[^/]*\\.xml"};
    protected static final String _xmlTag = "*";
    protected static final String[] _elementContentValues = new String[]{".*(weblogic\\.jndi\\.WLInitialContextFactory|t3://.*|t3s://.*)"};
    protected DetectMethod _intialContextConstructor = null;
    protected DetectProperty _propertiesFileRule = null;
    protected DetectElement _elementContentRule = null;

    static {
        _argDetailHashTablePut.add(new ArgumentDetail(1, true, false, WEBLOGIC_JNDI_INTCTX_FACTORY_VALUE_STR, null, null));
        _argDetailHashTablePut.add(new ArgumentDetail(1, true, false, WEBLOGIC_URL_PROVIDER_VALUE_STR_T3, null, null));
        _argDetailHashTablePut.add(new ArgumentDetail(1, true, false, WEBLOGIC_URL_PROVIDER_VALUE_STR_T3S, null, null));
    }

    public RemoveWebLogicNonPortableJndiLookup() {
        this(RULE_NAME, RULE_DESC, null, false, false, false, null, null, null, null, null, null);
    }

    public RemoveWebLogicNonPortableJndiLookup(String ruleName, String ruleDesc, String[] classNames, boolean useAppProvidedLibraries, boolean skipScanForUsage, boolean flagOnce, String[] extendsClass, String[] implementsClass, String[] missingMethods, String[] missingMethodArgs, String[] implementsMethods, String[] implementsMethodArgs) {
        super(ruleName, ruleDesc, _hashTablePutMethodName, _hashTablePutOwner, null, _argHashTablePutTypes, null, false, _argDetailHashTablePut, null, null, true);
        this._intialContextConstructor = new DetectMethod(ruleName, ruleDesc, _constructorMethodName, _initialContextConstructorOwner, null, _argConstructor, null, false, null, null, null, true);
        this._propertiesFileRule = new DetectProperty(ruleName, ruleDesc, _propertyFiles, null, _propertyFileValues, false);
        this._elementContentRule = new DetectElement(ruleName, ruleDesc, null, _xmlFiles, _elementContentValues, null, false, null, null, null, false);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getMethodNames() {
        return _methodNames;
    }

    @Override
    public String[] getOwners() {
        return _methodOwners;
    }

    @Override
    public String[] getFileNames() {
        return _xmlFiles;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._intialContextConstructor.clearResults();
        this._propertiesFileRule.clearResults();
        this._elementContentRule.clearResults();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._intialContextConstructor.analyze(store, detectOnce);
        this._propertiesFileRule.analyze(store, detectOnce);
        this._elementContentRule.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        List<DetailResult> intialContextResults = this._intialContextConstructor.getResults(store);
        List<DetailResult> hashtablePutResults = super.getResults(store);
        if (intialContextResults != null && !intialContextResults.isEmpty() && hashtablePutResults != null && !hashtablePutResults.isEmpty()) {
            HashMap<String, ArrayList<DetailResult>> fileNameMap = new HashMap<String, ArrayList<DetailResult>>();
            for (DetailResult dr : hashtablePutResults) {
                ArrayList<DetailResult> resultList = (ArrayList<DetailResult>)fileNameMap.get(dr.getFileName());
                if (resultList == null) {
                    resultList = new ArrayList<DetailResult>();
                    fileNameMap.put(dr.getFileName(), resultList);
                }
                resultList.add(dr);
            }
            HashSet<String> filesAlreadyChecked = new HashSet<String>();
            for (DetailResult dr : intialContextResults) {
                String fileName = dr.getFileName();
                if (filesAlreadyChecked.contains(fileName)) continue;
                filesAlreadyChecked.add(fileName);
                if (!fileNameMap.containsKey(fileName)) continue;
                finalResults.addAll((Collection)fileNameMap.get(fileName));
            }
        }
        finalResults.addAll(this._propertiesFileRule.getResults(store));
        finalResults.addAll(this._elementContentRule.getResults(store));
        return finalResults;
    }
}

