/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectMethod;
import com.ibm.ws.report.binary.rules.DetectProperty;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.ArgumentDetail;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class NonPortableJNDILookup
extends DetectMethod {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule, RuleType.PropertyRule);
    protected static final String RULE_NAME = "RemoveWas2LibertyNonPortableJndiLookup";
    protected static final String RULE_DESC = "rules.was2liberty.InitialContext";
    private static final String JNDI_INTCTX_FACTORY_KEY = "java.naming.factory.initial";
    private static final String URL_PROVIDER_VALUE_STR = "java.naming.provider.url";
    protected static final String[] _methodNames = new String[]{"put", "<init>"};
    protected static final String[] _methodOwners = new String[]{"java.util.Hashtable", "javax.naming.InitialContext"};
    protected static final String[] _hashTablePutMethodName = new String[]{_methodNames[0]};
    protected static final String[] _hashTablePutOwner = new String[]{_methodOwners[0]};
    protected static final String _argHashTablePutTypes = "java.lang.Object, java.lang.Object";
    protected static List<ArgumentDetail> _argDetailHashTablePut = new ArrayList<ArgumentDetail>();
    protected static final String[] _constructorMethodName = new String[]{_methodNames[1]};
    protected static final String[] _initialContextConstructorOwner = new String[]{_methodOwners[1]};
    protected static final String _argConstructor = "java.util.Hashtable";
    protected static final String[] _propertyFileKeys = new String[]{"java.naming.factory.initial", "java.naming.provider.url"};
    protected static final String _propertyFiles = "(.*/)?jndi\\.properties";
    protected static String[] recipes = new String[]{"org.openrewrite.java.liberty.RemoveWas2LibertyNonPortableJndiLookup"};
    protected DetectMethod _intialContextConstructor = null;
    protected DetectProperty _propertiesFileRule = null;

    static {
        _argDetailHashTablePut.add(new ArgumentDetail(0, true, false, JNDI_INTCTX_FACTORY_KEY, null, null));
        _argDetailHashTablePut.add(new ArgumentDetail(1, true, false, ".*", null, null));
        _argDetailHashTablePut.add(new ArgumentDetail(0, true, false, URL_PROVIDER_VALUE_STR, null, null));
        _argDetailHashTablePut.add(new ArgumentDetail(1, true, false, ".*", null, null));
    }

    public NonPortableJNDILookup() {
        this(RULE_NAME, RULE_DESC, null, false, false, false, null, null, null, null, null, null);
    }

    public NonPortableJNDILookup(String ruleName, String ruleDesc, String[] classNames, boolean useAppProvidedLibraries, boolean skipScanForUsage, boolean flagOnce, String[] extendsClass, String[] implementsClass, String[] missingMethods, String[] missingMethodArgs, String[] implementsMethods, String[] implementsMethodArgs) {
        super(ruleName, ruleDesc, _hashTablePutMethodName, _hashTablePutOwner, null, _argHashTablePutTypes, null, false, _argDetailHashTablePut, null, null, true);
        this._intialContextConstructor = new DetectMethod(ruleName, ruleDesc, _constructorMethodName, _initialContextConstructorOwner, null, _argConstructor, null, false, null, null, null, true);
        this._propertiesFileRule = new DetectProperty(ruleName, ruleDesc, _propertyFiles, _propertyFileKeys, new String[]{".*", ".*"}, false);
        this.setRecipes(recipes);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getMethodNames() {
        return _methodNames;
    }

    @Override
    public String[] getOwners() {
        return _methodOwners;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._intialContextConstructor.clearResults();
        this._propertiesFileRule.clearResults();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._intialContextConstructor.analyze(store, detectOnce);
        this._propertiesFileRule.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        List<DetailResult> intialContextResults = this._intialContextConstructor.getResults(store);
        List<DetailResult> hashtablePutResults = super.getResults(store);
        if (intialContextResults != null && !intialContextResults.isEmpty() && hashtablePutResults != null && !hashtablePutResults.isEmpty()) {
            HashMap<String, ArrayList<DetailResult>> fileNameMap = new HashMap<String, ArrayList<DetailResult>>();
            for (DetailResult dr : hashtablePutResults) {
                ArrayList<DetailResult> resultList = (ArrayList<DetailResult>)fileNameMap.get(dr.getFileName());
                if (resultList == null) {
                    resultList = new ArrayList<DetailResult>();
                    fileNameMap.put(dr.getFileName(), resultList);
                }
                resultList.add(dr);
            }
            HashSet<String> filesAlreadyChecked = new HashSet<String>();
            for (DetailResult dr : intialContextResults) {
                String fileName = dr.getFileName();
                if (filesAlreadyChecked.contains(fileName)) continue;
                filesAlreadyChecked.add(fileName);
                if (!fileNameMap.containsKey(fileName)) continue;
                finalResults.addAll((Collection)fileNameMap.get(fileName));
            }
        }
        finalResults.addAll(this._propertiesFileRule.getResults(store));
        return finalResults;
    }
}

