/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.binary.rules.DetectManifestAttribute;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class MigrateWebLogicManifestRule
extends DetectManifestAttribute {
    protected static final String RULE_NAME = "MigrateWebLogicManifestRule";
    protected static final String RULE_DESC = "com.ibm.ws.appconversion.weblogic.manifest.analysis.rule.label";
    protected static final String CLASS_PATH = "Class-Path";
    protected static final Pattern[] appInfDependencyPattern = new Pattern[]{Pattern.compile(".*\\.ear/APP-INF/((?!.*[wjr]ar/).*/)?[^/]+\\.(?i)(jar|class)")};
    protected static final Pattern earPathPattern = Pattern.compile(".*\\.ear/");
    protected static final Pattern warManifestFilePattern = Pattern.compile(".*\\.ear/.*\\.war/META-INF/MANIFEST.MF");
    DetectFile _detectDependencies;
    Map<String, List<String>> mapOfEarsToAppInfDependencies = new HashMap<String, List<String>>();

    public MigrateWebLogicManifestRule() {
        this(RULE_NAME, RULE_DESC, CLASS_PATH, ".*", DetectRule.FlagOnce.NONE);
    }

    public MigrateWebLogicManifestRule(String ruleName, String desc, String name2, String value, DetectRule.FlagOnce flagOnceType) {
        super(ruleName, desc, name2, value, flagOnceType);
        this._detectDependencies = new DetectFile(ruleName, desc, appInfDependencyPattern, false){

            @Override
            public void analyze(SimpleDataStore store, boolean detectOnce) {
                int i = 0;
                while (i < this.files.length) {
                    Pattern pattern = this.files[i];
                    Set<String> matches = store.getMatchingFileNames(pattern);
                    for (String key : matches) {
                        String earName = ReportUtility.getFirstArchiveName(key);
                        List<String> appInfDependencies = MigrateWebLogicManifestRule.this.mapOfEarsToAppInfDependencies.get(earName);
                        if (appInfDependencies == null) {
                            appInfDependencies = new ArrayList<String>();
                            MigrateWebLogicManifestRule.this.mapOfEarsToAppInfDependencies.put(earName, appInfDependencies);
                        }
                        appInfDependencies.add(earPathPattern.matcher(key).replaceFirst(""));
                    }
                    ++i;
                }
            }
        };
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._detectDependencies.clearResults();
        this.mapOfEarsToAppInfDependencies.clear();
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        this._detectDependencies.analyze(store, false);
        ArrayList<DetailResult> finalResultsList = new ArrayList<DetailResult>();
        List<DetailResult> manifestResultsList = super.getResults(store);
        StringBuilder sb = new StringBuilder();
        for (DetailResult result : manifestResultsList) {
            String filePath = result.getFileName();
            if (!warManifestFilePattern.matcher(filePath).matches()) continue;
            String earName = ReportUtility.getFirstArchiveName(filePath);
            Set<String> setOfClassPathReferences = this.getClassPathFiles(result.getCriteria());
            for (String depencencyName : ReportUtility.nullGuard(this.mapOfEarsToAppInfDependencies.get(earName))) {
                if (setOfClassPathReferences.contains(depencencyName)) continue;
                sb.append(depencencyName).append("\n");
            }
            if (sb.length() == 0) continue;
            result.setCriteria(Messages.getFormattedMessage(Messages.getString("Report_Criteria_Missing_Class_Path"), sb.toString().trim()));
            finalResultsList.add(result);
            sb.setLength(0);
        }
        return finalResultsList;
    }

    public Set<String> getClassPathFiles(String classPath) {
        int indexOfEquals = classPath.indexOf(61);
        String classPathValue = classPath.substring(indexOfEquals).trim();
        return new HashSet<String>(Arrays.asList(classPathValue.split("\\s+")));
    }
}

