/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class InjectedJPAElementUnitName
extends DetectAnnotation {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.XmlRule, RuleType.JavaRule);
    protected static final String RULE_NAME = "InjectedJPAElementUnitName";
    protected static final String RULE_DESC = "com.ibm.ws.appconversion.weblogic.rules.InjectedJPAElementUnitName";
    protected static final String ANNOTATION_DETAILS_STRING_TYPE = "java.lang.String";
    protected static final String[] annotationNames = new String[]{"javax.persistence.PersistenceUnit", "javax.persistence.PersistenceContext"};
    protected static final String NAME = "name";
    protected static final String UNIT_NAME = "unitName";
    protected static final String[] tags = new String[]{"persistence-unit"};
    protected static final String[] fileNames = new String[]{"META-INF/persistence.xml"};
    protected static String namespace = "*";
    protected Map<DetailResult, String> potentialResultsToFieldNames = new HashMap<DetailResult, String>();
    protected Set<String> persistenceUnitNames = new HashSet<String>();
    protected DetectElement _persistenceUnitsXML = new DetectElement("InjectedJPAElementUnitName", "com.ibm.ws.appconversion.weblogic.rules.InjectedJPAElementUnitName", tags, fileNames, null, null, false, null, null, null, false){

        @Override
        protected boolean includeInResults(Node result, String key, XMLResource resource) {
            NamedNodeMap attrMap = result.getAttributes();
            InjectedJPAElementUnitName.this.persistenceUnitNames.add(XMLRuleUtil.getAttributeValue(attrMap, this.namespace, InjectedJPAElementUnitName.NAME));
            return false;
        }
    };

    public InjectedJPAElementUnitName() {
        this(RULE_NAME, RULE_DESC, annotationNames, null, null, null, null, null, false, null, null, null);
    }

    public InjectedJPAElementUnitName(String ruleName, String desc, String[] classNames, String attributeName, String attributeType, String[] attributeValues, String defaultValue, String accessFlag, boolean flagOnce, String location, String defaultName, String missingAttributeName) {
        super(ruleName, desc, classNames, attributeName, attributeType, attributeValues, defaultValue, accessFlag, flagOnce, location, defaultName, missingAttributeName);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        return fileNames;
    }

    @Override
    protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
        boolean containsNameAttr = ad.containsAttributeName(NAME);
        boolean containsUnitNameAttr = ad.containsAttributeName(UNIT_NAME);
        if (containsNameAttr && containsUnitNameAttr) {
            return false;
        }
        if (!containsNameAttr && !containsUnitNameAttr) {
            if (ad.getReferenceType() != 2) {
                return false;
            }
            String ref = ad.getReference();
            DetailResult result = new DetailResult(RULE_NAME, key, this.getRuleDescription(), ad.getName(), 1, ref, ad.getLineNumber());
            String[] refSplit = ref.split("\\s+");
            this.potentialResultsToFieldNames.put(result, refSplit[refSplit.length - 1]);
            return false;
        }
        return true;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._persistenceUnitsXML.clearResults();
        this.persistenceUnitNames.clear();
        this.potentialResultsToFieldNames.clear();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._persistenceUnitsXML.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> results = super.getResults(store);
        for (Map.Entry<DetailResult, String> resToField : this.potentialResultsToFieldNames.entrySet()) {
            DetailResult result = resToField.getKey();
            String field = resToField.getValue();
            if (!this.persistenceUnitNames.contains(field)) continue;
            results.add(result);
        }
        return results;
    }
}

