/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.MethodDetails;
import com.ibm.ws.report.binary.rules.DetectClass;
import com.ibm.ws.report.binary.rules.RuleType;
import java.util.EnumSet;
import java.util.List;

public class ExtendsServletInputOutputStream
extends DetectClass {
    protected static final String RULE_NAME = "ExtendsServletInputOutputStream";
    protected static final String RULE_DESC = "appconversion.javaee7.servlet.ExtendsServletInputOutputStream";
    protected static final String SERVLETOUTPUTSTREAM_CLASS_NAME = "javax.servlet.ServletOutputStream";
    protected static final String SERVLETINPUTSTREAM_CLASS_NAME = "javax.servlet.ServletInputStream";
    protected static final String[] classNames = new String[]{"javax.servlet.ServletOutputStream", "javax.servlet.ServletInputStream"};

    public ExtendsServletInputOutputStream() {
        this(RULE_NAME, RULE_DESC, null, false, false, false, classNames, null, null, null, null, null);
        ruleType = EnumSet.of(RuleType.JavaRule);
    }

    public ExtendsServletInputOutputStream(String ruleName, String desc, String[] classNames, boolean useAppProvidedLibraries, boolean skipScanForUsage, boolean flagOnce, String[] extendsClass, String[] implementsClass, String[] missingMethods, String[] missingMethodArgs, String[] implementsMethods, String[] implementsMethodArgs) {
        super(ruleName, desc, classNames, useAppProvidedLibraries, skipScanForUsage, flagOnce, extendsClass, implementsClass, missingMethods, missingMethodArgs, implementsMethods, implementsMethodArgs);
    }

    @Override
    protected boolean includeInResults(ClassDataStore data, String filename) {
        boolean includeInResults = false;
        if (data.isAbstract()) {
            return false;
        }
        List<MethodDetails> md1 = data.getImplementedMethodDetails("isReady");
        if (data.getParent().equals(SERVLETOUTPUTSTREAM_CLASS_NAME)) {
            List<MethodDetails> md2 = data.getImplementedMethodDetails("setWriteListener");
            includeInResults = md1.isEmpty() && md2.isEmpty() || md1.isEmpty() || md2.isEmpty();
        } else if (data.getParent().equals(SERVLETINPUTSTREAM_CLASS_NAME)) {
            List<MethodDetails> md2 = data.getImplementedMethodDetails("isFinished");
            List<MethodDetails> md3 = data.getImplementedMethodDetails("setReadListener");
            includeInResults = md1.isEmpty() && md2.isEmpty() && md3.isEmpty() || md1.isEmpty() || md2.isEmpty() || md3.isEmpty();
        }
        return includeInResults;
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"isReady", "setWriteListener", "setReadListener", "isFinished"};
    }
}

