/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAttribute;
import com.ibm.ws.report.binary.rules.DetectClass;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DetectStubClasses
extends DetectRule {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.XmlRule, RuleType.JavaRule);
    protected static final String RULE_NAME = "DetectStubClasses";
    protected static final String RULE_DESC = "com.ibm.rrd.liberty.rules.impl.xml.DetectStubClasses.rulename";
    protected static final String[] EJB_JAR_TAG = new String[]{"ejb-jar"};
    protected static final String[] EJB_JAR_XML_FILENAME = new String[]{"META-INF/ejb-jar.xml"};
    protected static final String VERSION_ATTRIBUTE = "version";
    protected static final String VERSION_ATTRIBUTE_VALUE = "2\\.(1|0)|(1\\.1)";
    protected static final String REMOTE_ELEMENT = "remote";
    protected static final String HOME_ELEMENT = "home";
    protected static final String[] interfaceEJBObjectOrHome = new String[]{"javax.ejb.EJBObject", "javax.ejb.EJBHome"};
    protected static final Pattern[] stubClassFileName = new Pattern[]{Pattern.compile(".*_Stub\\.class")};
    protected DetectFile _StubClass = null;
    protected DetectClass detectInterfaceNamesExtendEJBObjectOrHome = null;
    protected DetectAttribute detectVersion = null;
    protected Set<String> interfaceNamesExtendEJBObjectOrHome = new HashSet<String>();
    protected Map<String, List<String>> classesToImplementedInterfaces = new HashMap<String, List<String>>();
    protected Map<String, String> fileToClassName = new HashMap<String, String>();

    public DetectStubClasses() {
        this(RULE_NAME, RULE_DESC, false);
    }

    public DetectStubClasses(String ruleName, String desc, boolean flagOnce) {
        super(ruleName, desc, flagOnce);
        this.detectInterfaceNamesExtendEJBObjectOrHome = new DetectClass(ruleName, desc, null, false, false, false, interfaceEJBObjectOrHome, null, null, null, null, null){

            @Override
            protected boolean includeInResults(ClassDataStore data, String filename) {
                DetectStubClasses.this.interfaceNamesExtendEJBObjectOrHome.add(data.getClassName());
                return false;
            }
        };
        this.detectVersion = new DetectAttribute(ruleName, desc, EJB_JAR_TAG, EJB_JAR_XML_FILENAME, null, VERSION_ATTRIBUTE, VERSION_ATTRIBUTE_VALUE, null, false, null, null){

            @Override
            protected boolean includeInResults(String fileName, Node node) {
                String jarFileName = DetectStubClasses.this.getJarFileName(fileName);
                if (jarFileName != null) {
                    Element rootElement = ((Attr)node).getOwnerElement();
                    List<Element> remoteElements = XMLRuleUtil.getChildElements(rootElement, "*", DetectStubClasses.REMOTE_ELEMENT);
                    List<Element> homeElements = XMLRuleUtil.getChildElements(rootElement, "*", DetectStubClasses.HOME_ELEMENT);
                    if (homeElements != null && !homeElements.isEmpty() || remoteElements != null && !remoteElements.isEmpty()) {
                        return true;
                    }
                }
                return false;
            }
        };
        this._StubClass = new DetectFile(RULE_NAME, RULE_DESC, stubClassFileName, false);
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.detectVersion.clearResults();
        this._StubClass.clearResults();
        this.interfaceNamesExtendEJBObjectOrHome.clear();
        this.classesToImplementedInterfaces.clear();
        this.fileToClassName.clear();
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        return EJB_JAR_XML_FILENAME;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        this.detectInterfaceNamesExtendEJBObjectOrHome.analyze(store, detectOnce);
        this.detectVersion.analyze(store, detectOnce);
        Set<String> keys = store.getClassDataStoreKeys();
        for (String key : keys) {
            ClassDataStore data = store.getClassDataStore(key);
            String[] interfaceArr = data.getImplementedInterfaces();
            if (interfaceArr != null) {
                this.classesToImplementedInterfaces.put(data.getClassName(), Arrays.asList(interfaceArr));
            }
            this.fileToClassName.put(key, data.getClassName());
        }
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        String fileName;
        this._StubClass.analyze(store, false);
        List<DetailResult> fileResults = this._StubClass.getResults(store);
        List<DetailResult> versionResults = this.detectVersion.getResults(store);
        HashSet<String> jarNamesForStubs = new HashSet<String>();
        for (DetailResult result : fileResults) {
            String filePath = result.getFileName();
            if (!this.implementsInterfaceExtendingEJBObjectOrHome(filePath) || (fileName = this.getJarFileName(result.getFileName())) == null) continue;
            jarNamesForStubs.add(fileName);
        }
        Iterator<DetailResult> itr = versionResults.iterator();
        while (itr.hasNext()) {
            DetailResult result = itr.next();
            fileName = this.getJarFileName(result.getFileName());
            if (!jarNamesForStubs.contains(fileName)) continue;
            itr.remove();
        }
        return versionResults;
    }

    private boolean implementsInterfaceExtendingEJBObjectOrHome(String filePath) {
        List<String> interfacesArr;
        String className = this.fileToClassName.get(filePath);
        if (className != null && (interfacesArr = this.classesToImplementedInterfaces.get(className)) != null && !interfacesArr.isEmpty()) {
            for (String inter : interfacesArr) {
                if (!this.interfaceNamesExtendEJBObjectOrHome.contains(inter)) continue;
                return true;
            }
        }
        return false;
    }

    protected String getJarFileName(String fileName) {
        String jarFileName = null;
        int index = fileName.lastIndexOf(".jar");
        if (index > -1) {
            jarFileName = fileName.substring(0, index + 4);
        }
        return jarFileName;
    }
}

