/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAttribute;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DetectMetadataComplete
extends DetectAttribute {
    protected static final String RULE_NAME = "DetectMetadataComplete";
    protected static final String RULE_DESC = "appconversion.was2was.70.javaee5.DetectMetadataComplete";
    protected static final String[] webFileNames = new String[]{"WEB-INF/web.xml"};
    protected static final String[] webTag = new String[]{"web-app"};
    protected static final String versionAttribute = "version";
    protected static final String versionValue = "3\\.\\d|2\\.5";
    protected DetectAttribute _detectEjbModulesV3Plus = null;
    protected static final String[] ejbTag = new String[]{"ejb-jar"};
    protected static final String ejbVersionValue = "3\\.\\d";
    protected static final String[] ejbFileNames = new String[]{"(.*/)?(META-INF|WEB-INF)/ejb-jar\\.xml"};
    protected DetectAttribute _detectFilesWithPopulatedMetaCompAttr = new DetectAttribute("DetectMetadataComplete", "appconversion.was2was.70.javaee5.DetectMetadataComplete", metaTags, allFileNames, null, "metadata-complete", "\\w+", null, false, null, null);
    protected static final String[] metaTags = new String[]{"web-app", "ejb-jar"};
    protected static final String metaAttribute = "metadata-complete";
    protected static final String metaValue = "\\w+";
    protected static final String[] allFileNames = new String[]{"(.*/)?(META-INF|WEB-INF)/ejb-jar\\.xml", "WEB-INF/web.xml"};

    public DetectMetadataComplete() {
        this(RULE_NAME, RULE_DESC, webTag, webFileNames, null, versionAttribute, versionValue, null, false, null, null);
    }

    public DetectMetadataComplete(String ruleName, String desc, String[] tags, String[] fileNames, String namespace, String attributeName, String attributeValue, String attributeNamespace, boolean flagOnce, String validateNamespace, String documentNamespace) {
        super(ruleName, desc, tags, fileNames, namespace, attributeName, attributeValue, attributeNamespace, flagOnce, validateNamespace, documentNamespace);
        this._detectEjbModulesV3Plus = new DetectAttribute(RULE_NAME, RULE_DESC, ejbTag, ejbFileNames, null, versionAttribute, ejbVersionValue, null, false, null, null);
    }

    @Override
    public String[] getFileNames() {
        return allFileNames;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._detectFilesWithPopulatedMetaCompAttr.clearResults();
        this._detectEjbModulesV3Plus.clearResults();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._detectFilesWithPopulatedMetaCompAttr.analyze(store, detectOnce);
        this._detectEjbModulesV3Plus.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> parentResults = super.getResults(store);
        List<DetailResult> populatedMetaCompAttrResults = this._detectFilesWithPopulatedMetaCompAttr.getResults(store);
        parentResults.addAll(this._detectEjbModulesV3Plus.getResults(store));
        if (!parentResults.isEmpty()) {
            ArrayList<String> filesWithPopulatedMetaCompAttr = new ArrayList<String>();
            for (DetailResult nextResult : populatedMetaCompAttrResults) {
                filesWithPopulatedMetaCompAttr.add(nextResult.getFileName());
            }
            Iterator<DetailResult> it = parentResults.iterator();
            while (it.hasNext()) {
                DetailResult nextResult = it.next();
                if (!filesWithPopulatedMetaCompAttr.contains(nextResult.getFileName())) continue;
                it.remove();
            }
        }
        return parentResults;
    }
}

