/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.rules.DetectAttribute;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import java.util.List;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DetectJndiObjectFactoryBeanNoQuickFix
extends DetectAttribute {
    protected static final String RULE_NAME = "DetectJndiObjectFactoryBeanNoQuickFix";
    protected static final String RULE_DESC = "appconversion.framework.spring.xml.jndiObjectFactoryBeanNoQuickFix";
    protected static final String XML_FILE = ".xml";
    protected static final String CLASS_ATTRIBUTE_VALUE_REG = "org\\.springframework\\.jndi\\.JndiObjectFactoryBean";
    protected static final String PROPERTY_TAG = "property";
    protected static final String NAMESPACE = "*";
    protected static final Pattern CONTAINS_WAR_PATTERN = Pattern.compile(".*\\.war/.*");

    public DetectJndiObjectFactoryBeanNoQuickFix() {
        this(RULE_NAME, RULE_DESC, new String[]{"bean"}, new String[]{XML_FILE}, DetectRule.XMLFileType.SPRING, null, "class", CLASS_ATTRIBUTE_VALUE_REG, null, DetectRule.FlagOnce.NONE, null, null);
    }

    public DetectJndiObjectFactoryBeanNoQuickFix(String ruleName, String desc, String[] tags, String[] fileNames, DetectRule.XMLFileType xmlFileType, String namespace, String attributeName, String attributeValue, String attributeNamespace, DetectRule.FlagOnce flagOnceType, String validateNamespace, String documentNamespace) {
        super(ruleName, desc, tags, fileNames, xmlFileType, namespace, attributeName, attributeValue, attributeNamespace, flagOnceType, false, validateNamespace, documentNamespace);
    }

    @Override
    protected boolean includeInResults(String fileName, Node node) {
        boolean includeInResults = false;
        if (!CONTAINS_WAR_PATTERN.matcher(fileName).matches()) {
            includeInResults = true;
        } else {
            Element ownerNode = ((Attr)node).getOwnerElement();
            List<Element> jndiNameNode = XMLRuleUtil.getChildElementsByAttributeValue(ownerNode, NAMESPACE, PROPERTY_TAG, "name", "jndiName");
            List<Element> proxyInterfaceNode = XMLRuleUtil.getChildElementsByAttributeValue(ownerNode, NAMESPACE, PROPERTY_TAG, "name", "proxyInterface");
            includeInResults = jndiNameNode.isEmpty() || proxyInterfaceNode.isEmpty() ? true : this.arePropertiesInvalid(jndiNameNode, proxyInterfaceNode);
        }
        return includeInResults;
    }

    protected boolean arePropertiesInvalid(List<Element> jndiNameNode, List<Element> proxyInterfaceNode) {
        boolean arePropertiesInvalid = false;
        for (Element el : jndiNameNode) {
            String jndiNameVal = XMLRuleUtil.getAttributeOrChildNodeValue(el, "value");
            if (jndiNameVal != null && jndiNameVal.length() != 0 && !jndiNameVal.contains("$") && !jndiNameVal.contains("{")) continue;
            arePropertiesInvalid = true;
        }
        if (!arePropertiesInvalid) {
            for (Element el : proxyInterfaceNode) {
                String proxyInterfaceValue = XMLRuleUtil.getAttributeOrChildNodeValue(el, "value");
                if (proxyInterfaceValue != null && proxyInterfaceValue.length() != 0 && proxyInterfaceValue.equals("javax.sql.DataSource")) continue;
                arePropertiesInvalid = true;
            }
        }
        return arePropertiesInvalid;
    }
}

