/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectManifestAttribute;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DetectJakartaEE9IncompatibleSpringVersion
extends DetectManifestAttribute {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.ManifestRule);
    protected static final String RULE_NAME = "DetectJakartaEE9IncompatibleSpringVersion";
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.jakartaee9.spring.DetectJakartaEE9IncompatibleSpringVersion";
    protected static final String IMPLEMENTATION_VERSION = "Implementation-Version";
    protected static final String ARCHIVE_NAME = ".*/spring-core.*(RELEASE)?.jar/.*";

    public DetectJakartaEE9IncompatibleSpringVersion() {
        this(RULE_NAME, RULE_DESC, IMPLEMENTATION_VERSION, ".*", ARCHIVE_NAME, DetectRule.FlagOnce.NONE);
    }

    public DetectJakartaEE9IncompatibleSpringVersion(String ruleName, String desc, String name2, String value, String archiveName, DetectRule.FlagOnce flagOnceType) {
        super(ruleName, desc, name2, value, archiveName, flagOnceType, false);
    }

    @Override
    public void clearResults() {
        super.clearResults();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> manifestResults = super.getResults(store);
        if (!manifestResults.isEmpty()) {
            for (DetailResult dr : manifestResults) {
                String criteria = dr.getCriteria();
                Matcher intMatcher = Pattern.compile("\\d").matcher(criteria);
                if (!intMatcher.find()) continue;
                try {
                    int i = Integer.valueOf(intMatcher.group());
                    if (i >= 6) continue;
                    return manifestResults;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return new ArrayList<DetailResult>();
    }
}

