/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.AnnotationInfo;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectMethod;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Node;

public class DetectGetServletPath
extends DetectRule {
    protected static EnumSet<RuleType> ruleTypes = EnumSet.of(RuleType.JavaRule, RuleType.XmlRule);
    protected static final String RULE_NAME = "DetectGetServletPath";
    protected static final String RULE_DESC = "appconversion.competitive.rule.DetectGetServletPath";
    private final DetectElement detectUrlPattern;
    private static final String[] URL_PATTERN_TAGS = new String[]{"url-pattern", "servlet-class"};
    private static final String[] URL_PATTERN_FILES = new String[]{"WEB-INF/web.xml"};
    private static final String[] URL_PATTERN_PARENT = new String[]{"servlet-mapping", "servlet"};
    private final DetectAnnotation detectWebServlet;
    protected static final String[] ANNOTATION_CLASSES = new String[]{"javax.servlet.annotation.WebServlet"};
    protected static final String ANNOTATION_ATTRIBUTE_NAME = "urlPatterns|value";
    protected static final String ANNOTATION_ATTRIBUTE_TYPE = "java.lang.String";
    protected static final String[] ANNOTATION_ATTRIBUTE_VALUE = new String[]{".*"};
    private final DetectMethod detectMethodInvocations;
    protected static final String[] METHOD_NAMES = new String[]{"getServletPath", "getPathInfo"};
    protected static final String[] METHOD_OWNERS = new String[]{"javax.servlet.http.HttpServletRequest"};
    protected static final String RETURN_TYPE = "java.lang.String";
    protected static final String ARGUMENTS = "";
    private final HashSet<String> safeServletClasses = new HashSet();
    private final HashSet<String> badServletClasses = new HashSet();
    private final HashSet<String> badServletNames = new HashSet();
    private final HashSet<String> safeServletNames = new HashSet();
    private final HashMap<String, String> servletNamesToClasses = new HashMap();

    public DetectGetServletPath() {
        super(RULE_NAME, RULE_DESC, false);
        this.detectMethodInvocations = new DetectMethod(RULE_NAME, RULE_DESC, METHOD_NAMES, METHOD_OWNERS, "java.lang.String", ARGUMENTS, null, false, null, null, null);
        this.detectWebServlet = new DetectAnnotation(RULE_NAME, RULE_DESC, ANNOTATION_CLASSES, ANNOTATION_ATTRIBUTE_NAME, "java.lang.String", ANNOTATION_ATTRIBUTE_VALUE, null, null, false, "class", null, null){

            @Override
            protected boolean includeInResults(String key, ClassDataStore data, AnnotationInfo ai) {
                String className = ReportUtility.getQualifiedClassName(key);
                if (ai.getAttributeValue().equals("/")) {
                    DetectGetServletPath.this.badServletClasses.add(className);
                    DetectGetServletPath.this.safeServletClasses.remove(className);
                } else if (!DetectGetServletPath.this.badServletClasses.contains(className)) {
                    DetectGetServletPath.this.safeServletClasses.add(className);
                }
                return false;
            }
        };
        this.detectUrlPattern = new DetectElement(RULE_NAME, RULE_DESC, URL_PATTERN_TAGS, URL_PATTERN_FILES, null, null, false, null, null, null, false, null, null, null, false, URL_PATTERN_PARENT, false){

            @Override
            protected boolean includeInResults(Node result, String key, XMLResource resource) {
                Node parent = result.getParentNode();
                String servletName = XMLRuleUtil.getAttributeOrChildNodeValue(parent, "servlet-name");
                if (URL_PATTERN_TAGS[0].equals(result.getLocalName())) {
                    String urlMapping = XMLRuleUtil.getTextWithoutWhitespace(result);
                    if ("/".equals(urlMapping)) {
                        DetectGetServletPath.this.badServletNames.add(servletName);
                        DetectGetServletPath.this.safeServletNames.remove(servletName);
                    } else if (!DetectGetServletPath.this.badServletNames.contains(servletName)) {
                        DetectGetServletPath.this.safeServletNames.add(servletName);
                    }
                } else {
                    String className = XMLRuleUtil.getTextWithoutWhitespace(result);
                    DetectGetServletPath.this.servletNamesToClasses.put(servletName, className);
                }
                return false;
            }
        };
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.safeServletClasses.clear();
        this.badServletClasses.clear();
        this.safeServletNames.clear();
        this.badServletNames.clear();
        this.safeServletNames.clear();
        this.detectUrlPattern.clearResults();
        this.detectWebServlet.clearResults();
        this.detectMethodInvocations.clearResults();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        this.detectUrlPattern.analyze(store, detectOnce);
        this.detectWebServlet.analyze(store, detectOnce);
        this.detectMethodInvocations.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> methodFlags = this.detectMethodInvocations.getResults(store);
        for (String servletName : this.badServletNames) {
            this.safeServletClasses.remove(this.servletNamesToClasses.get(servletName));
        }
        for (String servletName : this.safeServletNames) {
            String servletClass = this.servletNamesToClasses.get(servletName);
            if (this.badServletClasses.contains(servletClass)) continue;
            this.safeServletClasses.add(servletClass);
        }
        for (DetailResult methodFlag : methodFlags) {
            String className = ReportUtility.getQualifiedClassName(methodFlag.getFileName());
            if (this.safeServletClasses.contains(className)) continue;
            this.detailResults.add(methodFlag);
        }
        return this.detailResults;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleTypes;
    }

    @Override
    public String[] getMethodNames() {
        return METHOD_NAMES;
    }

    @Override
    public String[] getAnnotations() {
        return ANNOTATION_CLASSES;
    }

    @Override
    public String[] getFileNames() {
        return URL_PATTERN_FILES;
    }
}

