/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.DetectClass;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;

public class ConsumesAndProducesAnnoCheck
extends DetectAnnotation {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule);
    protected static final String RULE_NAME = "ConsumesAndProducesAnnoCheck";
    protected static final String RULE_DESC = "appconversion.javaee7.jaxrs.ConsumesAndProducesAnnoCheck";
    protected static final String[] classNames = new String[]{"javax.ws.rs.Consumes", "javax.ws.rs.Produces"};
    protected static final String[] implementsClass = new String[]{"javax.ws.rs.ext.MessageBodyReader", "javax.ws.rs.ext.MessageBodyWriter"};
    protected DetectClass _witerOrReaderImplementation = new DetectClass("ConsumesAndProducesAnnoCheck", "appconversion.javaee7.jaxrs.ConsumesAndProducesAnnoCheck", null, false, false, false, null, implementsClass, null, null, null, null);

    public ConsumesAndProducesAnnoCheck() {
        this(RULE_NAME, RULE_DESC, classNames, null, null, null, null, null, false, "class", null, null);
    }

    public ConsumesAndProducesAnnoCheck(String ruleName, String desc, String[] classNames, String attributeName, String attributeType, String[] attributeValues, String defaultValue, String accessFlag, boolean flagOnce, String location, String defaultName, String missingAttributeName) {
        super(ruleName, desc, classNames, attributeName, attributeType, attributeValues, defaultValue, accessFlag, flagOnce, location, defaultName, missingAttributeName);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._witerOrReaderImplementation.clearResults();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._witerOrReaderImplementation.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        List<DetailResult> parentResults = super.getResults(store);
        List<DetailResult> writerOrReaderImp = this._witerOrReaderImplementation.getResults(store);
        if (!parentResults.isEmpty() && !writerOrReaderImp.isEmpty()) {
            HashSet<String> readerFilePathNames = new HashSet<String>();
            HashSet<String> writerFilePathNames = new HashSet<String>();
            for (DetailResult nextResult : writerOrReaderImp) {
                if (nextResult.getCriteria().equals("javax.ws.rs.ext.MessageBodyReader")) {
                    readerFilePathNames.add(nextResult.getFileName());
                    continue;
                }
                writerFilePathNames.add(nextResult.getFileName());
            }
            for (DetailResult nextResult : parentResults) {
                String annoName = nextResult.getCriteria();
                if (annoName.equals("javax.ws.rs.Consumes") && readerFilePathNames.contains(nextResult.getFileName())) {
                    finalResults.add(nextResult);
                    continue;
                }
                if (!annoName.equals("javax.ws.rs.Produces") || !writerFilePathNames.contains(nextResult.getFileName())) continue;
                finalResults.add(nextResult);
            }
        }
        return finalResults;
    }
}

