/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class DetectProperty
extends DetectRule {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.PropertyRule);
    protected String fileName = null;
    protected String[] keys = null;
    protected String[] values = null;
    protected boolean detectPomProperties = false;
    protected boolean detectMessageProperties = false;
    public static final Pattern POM_PROPERTY_REGEX = Pattern.compile("(.*/)?pom\\.properties");
    public static final Pattern MESSAGE_PROPERTY_REGEX = Pattern.compile("(.*/)?([mM]essage(s)?\\.properties|(.*)_[a-z][a-z](_[A-Z][A-Z])?\\.properties)");

    public DetectProperty(String ruleName, String desc, String fileName, String[] keys, String[] values, boolean flagOnce) {
        this(ruleName, desc, fileName, keys, values, flagOnce ? DetectRule.FlagOnce.ARCHIVE : DetectRule.FlagOnce.NONE, false, false, false);
    }

    public DetectProperty(String ruleName, String desc, String fileName, String[] keys, String[] values, DetectRule.FlagOnce flagOnceType, boolean hideResult, boolean detectPomProperties, boolean detectMessageProperties) {
        super(ruleName, desc, flagOnceType, hideResult);
        this.fileName = fileName;
        this.keys = keys;
        this.values = values;
        this.detectPomProperties = detectPomProperties;
        this.detectMessageProperties = detectMessageProperties;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        if (detectOnce && !this.detailResults.isEmpty()) {
            return;
        }
        Set<String> fileNames = store.getPropsKeys();
        for (String name2 : fileNames) {
            int i;
            int size;
            boolean match;
            if (!DetectProperty.flaggablePropertiesFile(this.detectPomProperties, this.detectMessageProperties, name2) || !(match = XMLRuleUtil.isMatchingFile(name2, this.fileName)) || !this.shouldFlag(name2)) continue;
            Properties props = store.getProps(name2);
            if (this.keys != null && this.keys.length > 0) {
                size = this.keys.length;
                i = 0;
                while (i < size) {
                    String key = this.keys[i];
                    if (key != null) {
                        if (props.containsKey(key)) {
                            String value = this.values[i];
                            if (value != null) {
                                String propValue = props.getProperty(key);
                                if (propValue != null && propValue.matches(value) && this.includeInResults(props, name2, key)) {
                                    if (this.flag(name2)) {
                                        this.detailResults.add(new DetailResult(this.ruleName, name2, this.ruleDescription, String.valueOf(key) + "=" + propValue));
                                    }
                                    if (detectOnce || this.flagOnce) {
                                        return;
                                    }
                                }
                            } else if (this.includeInResults(props, name2, key)) {
                                if (this.flag(name2)) {
                                    this.detailResults.add(new DetailResult(this.ruleName, name2, this.ruleDescription, key));
                                }
                                if (detectOnce || this.flagOnce) {
                                    return;
                                }
                            }
                        }
                    } else {
                        this.addDetailResultsForAnyKey(props, name2, detectOnce, i);
                    }
                    ++i;
                }
                continue;
            }
            size = this.values.length;
            i = 0;
            while (i < size) {
                this.addDetailResultsForAnyKey(props, name2, detectOnce, i);
                ++i;
            }
        }
    }

    public static boolean flaggablePropertiesFile(boolean detectPomProperties, boolean detectMessageProperties, String file) {
        if (!detectPomProperties && POM_PROPERTY_REGEX.matcher(file).matches()) {
            ReportUtility.logger.get().log(Level.FINEST, Messages.getFormattedMessage(Messages.getString("PomProperties_Skipped"), file));
            return false;
        }
        if (!detectMessageProperties && MESSAGE_PROPERTY_REGEX.matcher(file).matches()) {
            ReportUtility.logger.get().log(Level.FINEST, Messages.getFormattedMessage(Messages.getString("MessagesFile_Skipped"), file));
            return false;
        }
        return true;
    }

    private void addDetailResultsForAnyKey(Properties props, String name2, boolean detectOnce, int position) {
        Set<Object> propKeys = props.keySet();
        for (Object nextKey : propKeys) {
            String nextValue = props.getProperty((String)nextKey);
            if (nextValue == null || !nextValue.matches(this.values[position]) || !this.includeInResults(props, name2, nextKey)) continue;
            if (this.flag(name2)) {
                this.detailResults.add(new DetailResult(this.ruleName, name2, this.ruleDescription, nextKey + "=" + nextValue));
            }
            if (!detectOnce && !this.flagOnce) continue;
            return;
        }
    }

    protected boolean includeInResults(Properties props, String filename, Object key) {
        return true;
    }
}

